/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import io.sirix.access.DatabaseType;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.page.AbstractForwardingPage;
import io.sirix.page.PageReference;
import io.sirix.page.PageUtils;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PathSummaryPage
extends AbstractForwardingPage {
    private Page delegate;
    private final Int2LongMap maxNodeKeys;
    private final Int2IntMap currentMaxLevelsOfIndirectPages;

    public PathSummaryPage() {
        this.delegate = new ReferencesPage4();
        this.maxNodeKeys = new Int2LongOpenHashMap();
        this.currentMaxLevelsOfIndirectPages = new Int2IntOpenHashMap();
    }

    public PageReference getIndirectPageReference(int index) {
        return this.getOrCreateReference(index);
    }

    PathSummaryPage(Page delegate, Int2LongMap maxNodeKeys, Int2IntMap currentMaxLevelsOfIndirectPages) {
        this.delegate = delegate;
        this.maxNodeKeys = maxNodeKeys;
        this.currentMaxLevelsOfIndirectPages = currentMaxLevelsOfIndirectPages;
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mDelegate", (Object)this.delegate).toString();
    }

    @Override
    protected Page delegate() {
        return this.delegate;
    }

    public void createPathSummaryTree(DatabaseType databaseType, PageReadOnlyTrx pageReadTrx, int index, TransactionIntentLog log) {
        PageReference reference = this.getOrCreateReference(index);
        if (reference == null) {
            this.delegate = new BitmapReferencesPage(1024, (ReferencesPage4)this.delegate());
            reference = this.delegate.getOrCreateReference(index);
        }
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15) {
            PageUtils.createTree(databaseType, reference, IndexType.PATH_SUMMARY, pageReadTrx, log);
            if (this.maxNodeKeys.get(index) == 0L) {
                this.maxNodeKeys.put(index, 0L);
            } else {
                this.maxNodeKeys.put(index, this.maxNodeKeys.get(index) + 1L);
            }
            this.currentMaxLevelsOfIndirectPages.merge(index, 1, Integer::sum);
        }
    }

    public int getCurrentMaxLevelOfIndirectPages(int index) {
        return this.currentMaxLevelsOfIndirectPages.getOrDefault(index, 1);
    }

    public int getCurrentMaxLevelOfIndirectPagesSize() {
        return this.currentMaxLevelsOfIndirectPages.size();
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages(int index) {
        return this.currentMaxLevelsOfIndirectPages.merge(index, 1, Integer::sum);
    }

    public int getMaxNodeKeySize() {
        return this.maxNodeKeys.size();
    }

    public long getMaxNodeKey(int indexNo) {
        return this.maxNodeKeys.get(indexNo);
    }

    public long incrementAndGetMaxNodeKey(int indexNo) {
        long newMaxNodeKey = this.maxNodeKeys.get(indexNo) + 1L;
        this.maxNodeKeys.put(indexNo, newMaxNodeKey);
        return newMaxNodeKey;
    }
}

