/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import io.sirix.access.DatabaseType;
import io.sirix.access.User;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.page.AbstractForwardingPage;
import io.sirix.page.CASPage;
import io.sirix.page.DeweyIDPage;
import io.sirix.page.NamePage;
import io.sirix.page.PageReference;
import io.sirix.page.PageUtils;
import io.sirix.page.PathPage;
import io.sirix.page.PathSummaryPage;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.interfaces.Page;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RevisionRootPage
extends AbstractForwardingPage {
    private static final int INDIRECT_DOCUMENT_INDEX_REFERENCE_OFFSET = 0;
    private static final int INDIRECT_CHANGED_NODES_INDEX_REFERENCE_OFFSET = 1;
    private static final int INDIRECT_RECORD_TO_REVISIONS_INDEX_REFERENCE_OFFSET = 2;
    private static final int PATH_SUMMARY_REFERENCE_OFFSET = 3;
    private static final int NAME_REFERENCE_OFFSET = 4;
    private static final int CAS_REFERENCE_OFFSET = 5;
    private static final int PATH_REFERENCE_OFFSET = 6;
    private static final int DEWEYID_REFERENCE_OFFSET = 7;
    private long maxNodeKeyInDocumentIndex;
    private long maxNodeKeyInChangedNodesIndex;
    private long maxNodeKeyInRecordToRevisionsIndex;
    private long revisionTimestamp;
    private final Page delegate;
    private final int revision;
    private String commitMessage;
    private int currentMaxLevelOfDocumentIndexIndirectPages;
    private int currentMaxLevelOfChangedNodesIndirectPages;
    private int currentMaxLevelOfRecordToRevisionsIndirectPages;
    private User user;
    private Instant commitTimestamp;

    public RevisionRootPage() {
        this.delegate = new BitmapReferencesPage(8);
        this.getOrCreateReference(3).setPage(new PathSummaryPage());
        this.getOrCreateReference(4).setPage(new NamePage());
        this.getOrCreateReference(5).setPage(new CASPage());
        this.getOrCreateReference(6).setPage(new PathPage());
        this.getOrCreateReference(7).setPage(new DeweyIDPage());
        this.revision = 0;
        this.maxNodeKeyInDocumentIndex = -1L;
        this.maxNodeKeyInChangedNodesIndex = -1L;
        this.maxNodeKeyInRecordToRevisionsIndex = -1L;
        this.currentMaxLevelOfDocumentIndexIndirectPages = 1;
        this.currentMaxLevelOfChangedNodesIndirectPages = 1;
        this.currentMaxLevelOfRecordToRevisionsIndirectPages = 1;
    }

    RevisionRootPage(Page delegate, int revision, long maxNodeKeyInDocumentIndex, long maxNodeKeyInChangedNodesIndex, long maxNodeKeyInRecordToRevisionsIndex, long revisionTimestamp, String commitMessage, int currentMaxLevelOfDocumentIndexIndirectPages, int currentMaxLevelOfChangedNodesIndirectPages, int currentMaxLevelOfRecordToRevisionsIndirectPages, User user) {
        this.delegate = delegate;
        this.revision = revision;
        this.maxNodeKeyInDocumentIndex = maxNodeKeyInDocumentIndex;
        this.maxNodeKeyInChangedNodesIndex = maxNodeKeyInChangedNodesIndex;
        this.maxNodeKeyInRecordToRevisionsIndex = maxNodeKeyInRecordToRevisionsIndex;
        this.revisionTimestamp = revisionTimestamp;
        this.commitMessage = commitMessage;
        this.currentMaxLevelOfDocumentIndexIndirectPages = currentMaxLevelOfDocumentIndexIndirectPages;
        this.currentMaxLevelOfChangedNodesIndirectPages = currentMaxLevelOfChangedNodesIndirectPages;
        this.currentMaxLevelOfRecordToRevisionsIndirectPages = currentMaxLevelOfRecordToRevisionsIndirectPages;
        this.user = user;
    }

    public RevisionRootPage(RevisionRootPage committedRevisionRootPage, @NonNegative int representRev) {
        Page pageDelegate = committedRevisionRootPage.delegate();
        this.delegate = new BitmapReferencesPage(pageDelegate, ((BitmapReferencesPage)pageDelegate).getBitmap());
        this.revision = representRev;
        this.user = committedRevisionRootPage.user;
        this.maxNodeKeyInDocumentIndex = committedRevisionRootPage.maxNodeKeyInDocumentIndex;
        this.maxNodeKeyInChangedNodesIndex = committedRevisionRootPage.maxNodeKeyInChangedNodesIndex;
        this.maxNodeKeyInRecordToRevisionsIndex = committedRevisionRootPage.maxNodeKeyInRecordToRevisionsIndex;
        this.revisionTimestamp = committedRevisionRootPage.revisionTimestamp;
        this.commitMessage = committedRevisionRootPage.commitMessage;
        this.currentMaxLevelOfDocumentIndexIndirectPages = committedRevisionRootPage.currentMaxLevelOfDocumentIndexIndirectPages;
        this.currentMaxLevelOfChangedNodesIndirectPages = committedRevisionRootPage.currentMaxLevelOfChangedNodesIndirectPages;
        this.currentMaxLevelOfRecordToRevisionsIndirectPages = committedRevisionRootPage.currentMaxLevelOfRecordToRevisionsIndirectPages;
    }

    public PageReference getPathSummaryPageReference() {
        return this.getOrCreateReference(3);
    }

    public PageReference getCASPageReference() {
        return this.getOrCreateReference(5);
    }

    public PageReference getNamePageReference() {
        return this.getOrCreateReference(4);
    }

    public PageReference getPathPageReference() {
        return this.getOrCreateReference(6);
    }

    public PageReference getIndirectDocumentIndexPageReference() {
        return this.getOrCreateReference(0);
    }

    public PageReference getIndirectChangedNodesIndexPageReference() {
        return this.getOrCreateReference(1);
    }

    public PageReference getIndirectRecordToRevisionsIndexPageReference() {
        return this.getOrCreateReference(2);
    }

    public PageReference getDeweyIdPageReference() {
        return this.getOrCreateReference(7);
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public long getRevisionTimestamp() {
        return this.revisionTimestamp;
    }

    public long getMaxNodeKeyInDocumentIndex() {
        return this.maxNodeKeyInDocumentIndex;
    }

    public long incrementAndGetMaxNodeKeyInDocumentIndex() {
        return ++this.maxNodeKeyInDocumentIndex;
    }

    public void setMaxNodeKeyInDocumentIndex(@NonNegative long maxNodeKeyInDocumentIndex) {
        this.maxNodeKeyInDocumentIndex = maxNodeKeyInDocumentIndex;
    }

    public long getMaxNodeKeyInChangedNodesIndex() {
        return this.maxNodeKeyInChangedNodesIndex;
    }

    public long incrementAndGetMaxNodeKeyInChangedNodesIndex() {
        return ++this.maxNodeKeyInChangedNodesIndex;
    }

    public void setMaxNodeKeyInInChangedNodesIndex(@NonNegative long maxNodeKeyInChangedNodesIndex) {
        this.maxNodeKeyInChangedNodesIndex = maxNodeKeyInChangedNodesIndex;
    }

    public long getMaxNodeKeyInRecordToRevisionsIndex() {
        return this.maxNodeKeyInRecordToRevisionsIndex;
    }

    public long incrementAndGetMaxNodeKeyInRecordToRevisionsIndex() {
        return ++this.maxNodeKeyInRecordToRevisionsIndex;
    }

    public void setMaxNodeKeyInRecordToRevisionsIndex(@NonNegative long maxNodeKeyInRecordToRevisionsIndex) {
        this.maxNodeKeyInRecordToRevisionsIndex = maxNodeKeyInRecordToRevisionsIndex;
    }

    @Override
    public void commit(@NonNull PageTrx pageWriteTrx) {
        if (this.revision == pageWriteTrx.getUberPage().getRevisionNumber()) {
            super.commit(pageWriteTrx);
        }
    }

    public Instant getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public void setCommitTimestamp(Instant revisionTimestamp) {
        Objects.requireNonNull(revisionTimestamp);
        long revisionTimestampToSet = revisionTimestamp.toEpochMilli();
        if (this.revisionTimestamp > revisionTimestampToSet || revisionTimestamp.isAfter(Instant.now())) {
            throw new IllegalStateException("Revision timestamp must be bigger than previous revision timestamp, but not bigger than current time.");
        }
        this.commitTimestamp = revisionTimestamp;
    }

    public void setRevisionTimestamp(long revisionTimestamp) {
        this.revisionTimestamp = revisionTimestamp;
    }

    public int getCurrentMaxLevelOfDocumentIndexIndirectPages() {
        return this.currentMaxLevelOfDocumentIndexIndirectPages;
    }

    public int incrementAndGetCurrentMaxLevelOfDocumentIndexIndirectPages() {
        return ++this.currentMaxLevelOfDocumentIndexIndirectPages;
    }

    public int getCurrentMaxLevelOfChangedNodesIndexIndirectPages() {
        return this.currentMaxLevelOfChangedNodesIndirectPages;
    }

    public int incrementAndGetCurrentMaxLevelOfChangedNodesIndexIndirectPages() {
        return ++this.currentMaxLevelOfChangedNodesIndirectPages;
    }

    public int getCurrentMaxLevelOfRecordToRevisionsIndexIndirectPages() {
        return this.currentMaxLevelOfRecordToRevisionsIndirectPages;
    }

    public int incrementAndGetCurrentMaxLevelOfRecordToRevisionsIndexIndirectPages() {
        return ++this.currentMaxLevelOfRecordToRevisionsIndirectPages;
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("revisionTimestamp", this.revisionTimestamp).add("maxNodeKey", this.maxNodeKeyInDocumentIndex).add("delegate", (Object)this.delegate).add("nodePage", (Object)this.getOrCreateReference(0)).add("namePage", (Object)this.getOrCreateReference(4)).add("pathSummaryPage", (Object)this.getOrCreateReference(3)).add("pathPage", (Object)this.getOrCreateReference(6)).add("CASPage", (Object)this.getOrCreateReference(5)).add("deweyIDPage", (Object)this.getOrCreateReference(7)).toString();
    }

    @Override
    protected Page delegate() {
        return this.delegate;
    }

    public void createDocumentIndexTree(DatabaseType databaseType, PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        PageReference reference = this.getIndirectDocumentIndexPageReference();
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15) {
            PageUtils.createTree(databaseType, reference, IndexType.DOCUMENT, pageReadTrx, log);
            this.incrementAndGetMaxNodeKeyInDocumentIndex();
        }
    }

    public void createChangedNodesIndexTree(DatabaseType databaseType, PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        PageReference reference = this.getIndirectChangedNodesIndexPageReference();
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15) {
            PageUtils.createTree(databaseType, reference, IndexType.CHANGED_NODES, pageReadTrx, log);
            this.incrementAndGetMaxNodeKeyInChangedNodesIndex();
        }
    }

    public void createRecordToRevisionsIndexTree(DatabaseType databaseType, PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        PageReference reference = this.getIndirectRecordToRevisionsIndexPageReference();
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15) {
            PageUtils.createTree(databaseType, reference, IndexType.RECORD_TO_REVISIONS, pageReadTrx, log);
            this.incrementAndGetMaxNodeKeyInRecordToRevisionsIndex();
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CommitCredentials getCommitCredentials() {
        return new CommitCredentials(this.user, this.commitMessage);
    }

    public Optional<User> getUser() {
        return Optional.ofNullable(this.user);
    }
}

