/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import io.sirix.api.PageTrx;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.interfaces.Page;
import io.sirix.settings.Constants;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UberPage
implements Page {
    private final int revisionCount;
    private boolean isBootstrap;
    private RevisionRootPage rootPage;
    private PageReference rootPageReference;

    public UberPage() {
        this.revisionCount = 1;
        this.isBootstrap = true;
    }

    public UberPage(int revisionCount) {
        this.revisionCount = revisionCount;
        this.isBootstrap = false;
        this.rootPage = null;
    }

    public UberPage(UberPage committedUberPage) {
        if (committedUberPage.isBootstrap()) {
            this.revisionCount = committedUberPage.revisionCount;
            this.isBootstrap = committedUberPage.isBootstrap;
            this.rootPage = committedUberPage.rootPage;
        } else {
            this.revisionCount = committedUberPage.revisionCount + 1;
            this.isBootstrap = false;
            this.rootPage = null;
        }
    }

    public int getRevisionCount() {
        return this.revisionCount;
    }

    public int getRevisionNumber() {
        return this.revisionCount - 1;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public void setBootstrap(boolean bootstrap) {
        this.isBootstrap = bootstrap;
    }

    @Override
    public List<PageReference> getReferences() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("forwarding page", (Object)super.toString()).add("revisionCount", this.revisionCount).add("isBootstrap", this.isBootstrap).toString();
    }

    public void createRevisionTree(TransactionIntentLog log) {
        this.rootPage = new RevisionRootPage();
        Page namePage = this.rootPage.getNamePageReference().getPage();
        log.put(this.rootPage.getNamePageReference(), PageContainer.getInstance(namePage, namePage));
        Page casPage = this.rootPage.getCASPageReference().getPage();
        log.put(this.rootPage.getCASPageReference(), PageContainer.getInstance(casPage, casPage));
        Page pathPage = this.rootPage.getPathPageReference().getPage();
        log.put(this.rootPage.getPathPageReference(), PageContainer.getInstance(pathPage, pathPage));
        Page pathSummaryPage = this.rootPage.getPathSummaryPageReference().getPage();
        log.put(this.rootPage.getPathSummaryPageReference(), PageContainer.getInstance(pathSummaryPage, pathSummaryPage));
        Page deweyIDPage = this.rootPage.getDeweyIdPageReference().getPage();
        log.put(this.rootPage.getDeweyIdPageReference(), PageContainer.getInstance(deweyIDPage, deweyIDPage));
        this.rootPageReference = new PageReference();
        log.put(this.rootPageReference, PageContainer.getInstance(this.rootPage, this.rootPage));
    }

    public int[] getPageCountExp(IndexType indexType) {
        return switch (indexType) {
            default -> throw new MatchException(null, null);
            case IndexType.PATH_SUMMARY -> Constants.PATHINP_LEVEL_PAGE_COUNT_EXPONENT;
            case IndexType.DOCUMENT, IndexType.CHANGED_NODES, IndexType.RECORD_TO_REVISIONS, IndexType.DEWEYID_TO_RECORDID, IndexType.PATH, IndexType.CAS, IndexType.NAME -> Constants.INP_LEVEL_PAGE_COUNT_EXPONENT;
            case IndexType.REVISIONS -> Constants.UBPINP_LEVEL_PAGE_COUNT_EXPONENT;
        };
    }

    @Override
    public void commit(@NonNull PageTrx pageWriteTrx) {
        pageWriteTrx.commit(this.rootPageReference);
    }

    public UberPage setRevisionRootPage(RevisionRootPage rootPage) {
        this.rootPage = rootPage;
        return this;
    }

    public UberPage setRevisionRootPageReference(PageReference pageReference) {
        this.rootPageReference = pageReference;
        return this;
    }

    @Override
    public PageReference getOrCreateReference(@NonNegative int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        throw new UnsupportedOperationException();
    }

    public PageReference getRevisionRootReference() {
        return this.rootPageReference;
    }
}

