/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page.interfaces;

import io.sirix.api.PageTrx;
import io.sirix.page.PageReference;
import java.io.Closeable;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;

public interface Page
extends Closeable {
    default public Page clearPage() {
        return this;
    }

    public List<PageReference> getReferences();

    default public void commit(PageTrx pageWriteTrx) {
        List<PageReference> references = this.getReferences();
        for (PageReference reference : references) {
            if (reference.getLogKey() == -15) continue;
            pageWriteTrx.commit(reference);
        }
    }

    public PageReference getOrCreateReference(@NonNegative int var1);

    public boolean setOrCreateReference(int var1, PageReference var2);

    @Override
    default public void close() {
    }
}

