/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.serialize;

import com.google.common.base.Preconditions;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.Database;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.api.visitor.NodeVisitor;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.axis.IncludeSelf;
import io.sirix.node.NodeKind;
import io.sirix.service.AbstractSerializer;
import io.sirix.service.json.serialize.JsonMaxLevelMaxNodesMaxChildNodesVisitor;
import io.sirix.service.json.serialize.JsonSerializerProperties;
import io.sirix.service.json.serialize.StringValue;
import io.sirix.service.xml.serialize.XmlSerializerProperties;
import io.sirix.settings.Fixed;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.SirixFiles;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.LoggerFactory;

public final class JsonSerializer
extends AbstractSerializer<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(JsonSerializer.class));
    private final Appendable out;
    private final boolean indent;
    private final int indentSpaces;
    private final boolean withInitialIndent;
    private final boolean emitXQueryResultSequence;
    private final boolean serializeTimestamp;
    private final boolean withMetaData;
    private final boolean withNodeKeyMetaData;
    private final boolean withNodeKeyAndChildNodeKeyMetaData;
    private final boolean serializeStartNodeWithBrackets;
    private boolean hadToAddBracket;
    private int currentIndent;

    private JsonSerializer(JsonResourceSession resourceMgr, Builder builder) {
        super(resourceMgr, (NodeVisitor)(builder.maxLevel == Long.MAX_VALUE && builder.maxNodes == Long.MAX_VALUE && builder.maxChildNodes == Long.MAX_VALUE ? null : new JsonMaxLevelMaxNodesMaxChildNodesVisitor(builder.startNodeKey, IncludeSelf.YES, builder.maxLevel, builder.maxNodes, builder.maxChildNodes)), builder.startNodeKey, builder.version, builder.versions);
        this.out = builder.stream;
        this.indent = builder.indent;
        this.indentSpaces = builder.indentSpaces;
        this.withInitialIndent = builder.initialIndent;
        this.emitXQueryResultSequence = builder.emitXQueryResultSequence;
        this.serializeTimestamp = builder.serializeTimestamp;
        this.withMetaData = builder.withMetaData;
        this.withNodeKeyMetaData = builder.withNodeKey;
        this.withNodeKeyAndChildNodeKeyMetaData = builder.withNodeKeyAndChildCount;
        this.serializeStartNodeWithBrackets = builder.serializeStartNodeWithBrackets;
    }

    @Override
    public void emitNode(JsonNodeReadOnlyTrx rtx) {
        try {
            boolean hasChildren = rtx.hasChildren();
            switch (rtx.getKind()) {
                case JSON_DOCUMENT: {
                    break;
                }
                case OBJECT: {
                    this.emitMetaData(rtx);
                    if (this.withMetaDataField() && this.shouldEmitChildren(hasChildren)) {
                        this.appendArrayStart(true);
                    }
                    this.appendObjectStart(this.shouldEmitChildren(hasChildren));
                    if (!hasChildren || this.visitor != null && (!this.hasToSkipSiblings && this.currentLevel() + 1L > this.maxLevel() || this.hasToSkipSiblings && this.currentLevel() > this.maxLevel())) {
                        this.appendObjectEnd(false);
                        if (this.withMetaDataField()) {
                            this.appendObjectEnd(true);
                        }
                        this.printCommaIfNeeded(rtx);
                    }
                    break;
                }
                case ARRAY: {
                    this.emitMetaData(rtx);
                    this.appendArrayStart(this.shouldEmitChildren(hasChildren));
                    if (!hasChildren || this.visitor != null && (!this.hasToSkipSiblings && this.currentLevel() + 1L > this.maxLevel() || this.hasToSkipSiblings && this.currentLevel() > this.maxLevel())) {
                        this.appendArrayEnd(false);
                        if (this.withMetaDataField()) {
                            this.appendObjectEnd(true);
                        }
                        this.printCommaIfNeeded(rtx);
                    }
                    break;
                }
                case OBJECT_KEY: {
                    if (this.startNodeKey != Fixed.NULL_NODE_KEY.getStandardProperty() && rtx.getNodeKey() == this.startNodeKey && this.serializeStartNodeWithBrackets) {
                        this.appendObjectStart(hasChildren);
                        this.hadToAddBracket = true;
                    }
                    if (this.withMetaDataField()) {
                        if (rtx.hasLeftSibling() && (this.startNodeKey == Fixed.NULL_NODE_KEY.getStandardProperty() || rtx.getNodeKey() != this.startNodeKey)) {
                            this.appendObjectStart(true);
                        }
                        this.appendObjectKeyValue(this.quote("key"), this.quote(rtx.getName().stringValue())).appendSeparator().appendObjectKey(this.quote("metadata")).appendObjectStart(hasChildren);
                        if (this.withNodeKeyMetaData || this.withNodeKeyAndChildNodeKeyMetaData) {
                            this.appendObjectKeyValue(this.quote("nodeKey"), String.valueOf(rtx.getNodeKey()));
                        }
                        if (this.withMetaData) {
                            this.appendSeparator();
                            if (rtx.getHash() != 0L) {
                                this.appendObjectKeyValue(this.quote("hash"), this.quote(this.printHashValue(rtx)));
                                this.appendSeparator();
                            }
                            this.appendObjectKeyValue(this.quote("type"), this.quote(rtx.getKind().toString()));
                            if (rtx.getHash() != 0L) {
                                this.appendSeparator().appendObjectKeyValue(this.quote("descendantCount"), String.valueOf(rtx.getDescendantCount()));
                            }
                        }
                        this.appendObjectEnd(hasChildren).appendSeparator();
                        this.appendObjectKey(this.quote("value"));
                        break;
                    }
                    this.appendObjectKey(this.quote(rtx.getName().stringValue()));
                    break;
                }
                case BOOLEAN_VALUE: 
                case OBJECT_BOOLEAN_VALUE: {
                    this.emitMetaData(rtx);
                    this.appendObjectValue(Boolean.valueOf(rtx.getValue()).toString());
                    if (this.withMetaDataField()) {
                        this.appendObjectEnd(true);
                    }
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                case NULL_VALUE: 
                case OBJECT_NULL_VALUE: {
                    this.emitMetaData(rtx);
                    this.appendObjectValue("null");
                    if (this.withMetaDataField()) {
                        this.appendObjectEnd(true);
                    }
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                case NUMBER_VALUE: 
                case OBJECT_NUMBER_VALUE: {
                    this.emitMetaData(rtx);
                    this.appendObjectValue(rtx.getValue());
                    if (this.withMetaDataField()) {
                        this.appendObjectEnd(true);
                    }
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                case STRING_VALUE: 
                case OBJECT_STRING_VALUE: {
                    this.emitMetaData(rtx);
                    this.appendObjectValue(this.quote(StringValue.escape(rtx.getValue())));
                    if (this.withMetaDataField()) {
                        this.appendObjectEnd(true);
                    }
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                default: {
                    throw new IllegalStateException("Node kind not known!");
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private String printHashValue(JsonNodeReadOnlyTrx rtx) {
        return String.format("%016x", rtx.getHash());
    }

    private boolean withMetaDataField() {
        return this.withMetaData || this.withNodeKeyMetaData || this.withNodeKeyAndChildNodeKeyMetaData;
    }

    private boolean shouldEmitChildren(boolean hasChildren) {
        return this.visitor == null && hasChildren || this.visitor != null && hasChildren && this.currentLevel() + 1L <= this.maxLevel();
    }

    private void emitMetaData(JsonNodeReadOnlyTrx rtx) throws IOException {
        if (this.withMetaDataField()) {
            this.appendObjectStart(true).appendObjectKey(this.quote("metadata")).appendObjectStart(true);
            if (this.withNodeKeyMetaData || this.withNodeKeyAndChildNodeKeyMetaData) {
                this.appendObjectKeyValue(this.quote("nodeKey"), String.valueOf(rtx.getNodeKey()));
                if (this.withMetaData || this.withNodeKeyAndChildNodeKeyMetaData && (rtx.getKind() == NodeKind.OBJECT || rtx.getKind() == NodeKind.ARRAY)) {
                    this.appendSeparator();
                }
            }
            if (this.withMetaData) {
                if (rtx.getHash() != 0L) {
                    this.appendObjectKeyValue(this.quote("hash"), this.quote(this.printHashValue(rtx)));
                    this.appendSeparator();
                }
                this.appendObjectKeyValue(this.quote("type"), this.quote(rtx.getKind().toString()));
                if (rtx.getHash() != 0L && (rtx.getKind() == NodeKind.OBJECT || rtx.getKind() == NodeKind.ARRAY)) {
                    this.appendSeparator().appendObjectKeyValue(this.quote("descendantCount"), String.valueOf(rtx.getDescendantCount()));
                }
            }
            if (this.withNodeKeyAndChildNodeKeyMetaData && (rtx.getKind() == NodeKind.OBJECT || rtx.getKind() == NodeKind.ARRAY)) {
                if (this.withMetaData) {
                    this.appendSeparator();
                }
                this.appendObjectKeyValue(this.quote("childCount"), String.valueOf(rtx.getChildCount()));
            }
            this.appendObjectEnd(true).appendSeparator().appendObjectKey(this.quote("value"));
        }
    }

    @Override
    protected void setTrxForVisitor(JsonNodeReadOnlyTrx rtx) {
        this.castVisitor().setTrx(rtx);
    }

    private long maxLevel() {
        return this.castVisitor().getMaxLevel();
    }

    private long maxChildNodes() {
        return this.castVisitor().getMaxChildNodes();
    }

    private long maxNumberOfNodes() {
        return this.castVisitor().getMaxNodes();
    }

    private JsonMaxLevelMaxNodesMaxChildNodesVisitor castVisitor() {
        return (JsonMaxLevelMaxNodesMaxChildNodesVisitor)this.visitor;
    }

    private long currentLevel() {
        return this.castVisitor().getCurrentLevel();
    }

    private long currentChildNodes() {
        return this.castVisitor().getCurrentChildNodes();
    }

    private long numberOfVisitedNodesPlusOne() {
        return this.castVisitor().getNumberOfVisitedNodesPlusOne();
    }

    @Override
    protected boolean isSubtreeGoingToBeVisited(JsonNodeReadOnlyTrx rtx) {
        if (rtx.isObjectKey()) {
            return true;
        }
        return this.visitor == null || !this.hasToSkipSiblings && this.currentLevel() + 1L <= this.maxLevel() || this.hasToSkipSiblings && this.currentLevel() <= this.maxLevel();
    }

    @Override
    protected boolean areSiblingNodesGoingToBeSkipped(JsonNodeReadOnlyTrx rtx) {
        if (rtx.isObjectKey() || this.visitor == null) {
            return false;
        }
        return this.currentChildNodes() + 1L > this.maxChildNodes();
    }

    private void printCommaIfNeeded(JsonNodeReadOnlyTrx rtx) throws IOException {
        boolean hasRightSibling = rtx.hasRightSibling();
        if (hasRightSibling && rtx.getNodeKey() != this.startNodeKey && (this.visitor == null || this.currentChildNodes() < this.maxChildNodes() && this.numberOfVisitedNodesPlusOne() < this.maxNumberOfNodes())) {
            this.appendSeparator();
        }
    }

    @Override
    protected void emitEndNode(JsonNodeReadOnlyTrx rtx, boolean lastEndNode) {
        try {
            VisitResultType lastVisitResultType = this.visitor == null ? null : ((JsonMaxLevelMaxNodesMaxChildNodesVisitor)this.visitor).getLastVisitResultType();
            switch (rtx.getKind()) {
                case ARRAY: {
                    if (this.withMetaDataField()) {
                        this.appendArrayEnd(true).appendObjectEnd(true);
                    } else {
                        this.appendArrayEnd(this.shouldEmitChildren(rtx.hasChildren()));
                    }
                    if (!this.hasToAppendSeparator(rtx, lastVisitResultType, lastEndNode)) break;
                    this.appendSeparator();
                    break;
                }
                case OBJECT: {
                    if (this.withMetaDataField()) {
                        this.appendArrayEnd(true).appendObjectEnd(true);
                    } else {
                        this.appendObjectEnd(this.shouldEmitChildren(rtx.hasChildren()));
                    }
                    if (!this.hasToAppendSeparator(rtx, lastVisitResultType, lastEndNode)) break;
                    this.appendSeparator();
                    break;
                }
                case OBJECT_KEY: {
                    if (this.withMetaDataField() && (this.startNodeKey == Fixed.NULL_NODE_KEY.getStandardProperty() || rtx.getNodeKey() != this.startNodeKey) || this.hadToAddBracket && rtx.getNodeKey() == this.startNodeKey) {
                        this.appendObjectEnd(true);
                    }
                    if (!this.hasToAppendSeparator(rtx, lastVisitResultType, lastEndNode)) break;
                    this.appendSeparator();
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private boolean hasToAppendSeparator(JsonNodeReadOnlyTrx rtx, VisitResultType lastVisitResultType, boolean lastEndNode) {
        return rtx.hasRightSibling() && rtx.getNodeKey() != this.startNodeKey && VisitResultType.TERMINATE != lastVisitResultType && (this.visitor == null || lastEndNode);
    }

    @Override
    protected void emitStartDocument() {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (length > 1) {
                this.appendObjectStart(true);
                if (this.indent) {
                    this.stack.push(-15L);
                }
                this.appendObjectKey(this.quote("sirix"));
                this.appendArrayStart(true);
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndDocument() {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (length > 1) {
                if (this.indent) {
                    this.stack.popLong();
                }
                this.appendArrayEnd(true).appendObjectEnd(true);
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionStartNode(@NonNull JsonNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (this.emitXQueryResultSequence || length > 1) {
                this.appendObjectStart(rtx.hasChildren()).appendObjectKeyValue(this.quote("revisionNumber"), Integer.toString(rtx.getRevisionNumber())).appendSeparator();
                if (this.serializeTimestamp) {
                    this.appendObjectKeyValue(this.quote("revisionTimestamp"), this.quote(DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).format(rtx.getRevisionTimestamp()))).appendSeparator();
                }
                this.appendObjectKey(this.quote("revision"));
                if (rtx.hasFirstChild()) {
                    this.stack.push(-15L);
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionEndNode(@NonNull JsonNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (this.emitXQueryResultSequence || length > 1) {
                if (rtx.moveToDocumentRoot() && rtx.hasFirstChild()) {
                    this.stack.popLong();
                }
                this.appendObjectEnd(rtx.hasChildren());
                if (this.hasMoreRevisionsToSerialize(rtx)) {
                    this.appendSeparator();
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private boolean hasMoreRevisionsToSerialize(JsonNodeReadOnlyTrx rtx) {
        return rtx.getRevisionNumber() < this.revisions[this.revisions.length - 1] || this.revisions.length == 1 && this.revisions[0] == -1 && rtx.getRevisionNumber() < rtx.getResourceSession().getMostRecentRevisionNumber();
    }

    private void indent() throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.currentIndent; ++i) {
                this.out.append(" ");
            }
        }
    }

    private void newLine() throws IOException {
        if (this.indent) {
            this.out.append("\n");
            this.indent();
        }
    }

    private JsonSerializer appendObjectStart(boolean hasChildren) throws IOException {
        this.out.append('{');
        if (hasChildren) {
            this.currentIndent += this.indentSpaces;
            this.newLine();
        }
        return this;
    }

    private JsonSerializer appendObjectEnd(boolean hasChildren) throws IOException {
        if (hasChildren) {
            this.currentIndent -= this.indentSpaces;
            this.newLine();
        }
        this.out.append('}');
        return this;
    }

    private void appendArrayStart(boolean hasChildren) throws IOException {
        this.out.append('[');
        if (hasChildren) {
            this.currentIndent += this.indentSpaces;
            this.newLine();
        }
    }

    private JsonSerializer appendArrayEnd(boolean hasChildren) throws IOException {
        if (hasChildren) {
            this.currentIndent -= this.indentSpaces;
            this.newLine();
        }
        this.out.append(']');
        return this;
    }

    private JsonSerializer appendObjectKey(String key) throws IOException {
        this.out.append(key);
        if (this.indent) {
            this.out.append(": ");
        } else {
            this.out.append(":");
        }
        return this;
    }

    private void appendObjectValue(String value) throws IOException {
        this.out.append(value);
    }

    private JsonSerializer appendObjectKeyValue(String key, String value) throws IOException {
        this.out.append(key);
        if (this.indent) {
            this.out.append(": ");
        } else {
            this.out.append(":");
        }
        this.out.append(value);
        return this;
    }

    private JsonSerializer appendSeparator() throws IOException {
        this.out.append(',');
        this.newLine();
        return this;
    }

    private String quote(String value) {
        return "\"" + value + "\"";
    }

    public static void main(String ... args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            throw new IllegalArgumentException("Usage: JsonSerializer database output.json");
        }
        LOGWRAPPER.info("Serializing '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path target = Paths.get(args[1], new String[0]);
        SirixFiles.recursiveRemove(target);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.createFile(target, new FileAttribute[0]);
        Path databaseFile = Paths.get(args[0], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(databaseFile);
        Databases.createJsonDatabase(config);
        try (Database<JsonResourceSession> db = Databases.openJsonDatabase(databaseFile);){
            db.createResource(new ResourceConfiguration.Builder("shredded").build());
            try (JsonResourceSession resMgr = db.beginResourceSession("shredded");
                 FileWriter outputStream = new FileWriter(target.toFile());){
                JsonSerializer serializer = JsonSerializer.newBuilder(resMgr, outputStream, new int[0]).build();
                serializer.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + "ms].", new Object[0]);
    }

    public static Builder newBuilder(JsonResourceSession resMgr, Writer stream, int ... revisions) {
        return new Builder(resMgr, stream, revisions);
    }

    public static Builder newBuilder(JsonResourceSession resMgr, @NonNegative long nodeKey, Writer stream, JsonSerializerProperties properties, int ... revisions) {
        return new Builder(resMgr, nodeKey, stream, properties, revisions);
    }

    public static final class Builder {
        private boolean indent;
        private int indentSpaces = 2;
        private final Appendable stream;
        private final JsonResourceSession resourceMgr;
        private int[] versions;
        private int version;
        private long startNodeKey;
        private boolean initialIndent;
        private boolean emitXQueryResultSequence;
        private boolean serializeTimestamp;
        private boolean withMetaData;
        private long maxLevel;
        private long maxNodes;
        private boolean withNodeKey;
        private boolean withNodeKeyAndChildCount;
        private boolean serializeStartNodeWithBrackets;
        private long maxChildNodes;

        public Builder(JsonResourceSession resourceMgr, Appendable stream, int ... revisions) {
            this.serializeStartNodeWithBrackets = true;
            this.maxLevel = Long.MAX_VALUE;
            this.startNodeKey = 0L;
            this.resourceMgr = Objects.requireNonNull(resourceMgr);
            this.stream = Objects.requireNonNull(stream);
            if (revisions == null || revisions.length == 0) {
                this.version = this.resourceMgr.getMostRecentRevisionNumber();
            } else {
                this.version = revisions[0];
                this.versions = new int[revisions.length - 1];
                System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            }
            this.maxNodes = Long.MAX_VALUE;
            this.maxChildNodes = Long.MAX_VALUE;
        }

        public Builder(JsonResourceSession resourceMgr, @NonNegative long nodeKey, Writer stream, JsonSerializerProperties properties, int ... revisions) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
            this.serializeStartNodeWithBrackets = true;
            this.maxLevel = -1L;
            this.resourceMgr = Objects.requireNonNull(resourceMgr);
            this.startNodeKey = nodeKey;
            this.stream = Objects.requireNonNull(stream);
            if (revisions == null || revisions.length == 0) {
                this.version = this.resourceMgr.getMostRecentRevisionNumber();
            } else {
                this.version = revisions[0];
                this.versions = new int[revisions.length - 1];
                System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            }
            ConcurrentMap<String, Object> map = Objects.requireNonNull(properties.getProps());
            this.indent = Objects.requireNonNull((Boolean)map.get(XmlSerializerProperties.S_INDENT[0]));
            this.indentSpaces = Objects.requireNonNull((Integer)map.get(XmlSerializerProperties.S_INDENT_SPACES[0]));
        }

        public Builder startNodeKey(long nodeKey) {
            this.startNodeKey = nodeKey;
            return this;
        }

        public Builder numberOfNodes(long maxNodes) {
            this.maxNodes = maxNodes;
            return this;
        }

        public Builder serializeStartNodeWithBrackets(boolean serializeStartNodeWithBrackets) {
            this.serializeStartNodeWithBrackets = serializeStartNodeWithBrackets;
            return this;
        }

        public Builder maxLevel(long maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder withInitialIndent() {
            this.initialIndent = true;
            return this;
        }

        public Builder maxChildren(long maxChildren) {
            this.maxChildNodes = maxChildren;
            return this;
        }

        public Builder isXQueryResultSequence() {
            this.emitXQueryResultSequence = true;
            return this;
        }

        public Builder serializeTimestamp(boolean serializeTimestamp) {
            this.serializeTimestamp = serializeTimestamp;
            return this;
        }

        public Builder withMetaData(boolean withMetaData) {
            this.withMetaData = withMetaData;
            this.withNodeKey = true;
            this.withNodeKeyAndChildCount = true;
            return this;
        }

        public Builder withNodeKeyMetaData(boolean withNodeKey) {
            this.withNodeKey = withNodeKey;
            return this;
        }

        public Builder withNodeKeyAndChildCountMetaData(boolean withNodeKeyAndChildCount) {
            this.withNodeKeyAndChildCount = withNodeKeyAndChildCount;
            return this;
        }

        public Builder prettyPrint() {
            this.indent = true;
            return this;
        }

        public Builder revisions(int[] revisions) {
            Objects.requireNonNull(revisions);
            this.version = revisions[0];
            this.versions = new int[revisions.length - 1];
            System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            return this;
        }

        public JsonSerializer build() {
            return new JsonSerializer(this.resourceMgr, this);
        }
    }
}

