/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.shredder;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.json.Array;
import io.sirix.access.trx.node.json.objectvalue.ArrayValue;
import io.sirix.access.trx.node.json.objectvalue.BooleanValue;
import io.sirix.access.trx.node.json.objectvalue.NullValue;
import io.sirix.access.trx.node.json.objectvalue.NumberValue;
import io.sirix.access.trx.node.json.objectvalue.ObjectRecordValue;
import io.sirix.access.trx.node.json.objectvalue.ObjectValue;
import io.sirix.access.trx.node.json.objectvalue.StringValue;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.node.NodeKind;
import io.sirix.service.InsertPosition;
import io.sirix.service.ShredderCommit;
import io.sirix.service.json.JsonNumber;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.Callable;

public final class JsonItemShredder
implements Callable<Long> {
    private final JsonNodeTrx wtx;
    private final Item item;
    private final ShredderCommit commit;
    private final LongStack parents;
    private InsertPosition insert;
    private int level;
    private final boolean skipRootJson;

    private JsonItemShredder(Builder builder) {
        this.wtx = builder.wtx;
        this.item = builder.item;
        this.insert = builder.insert;
        this.commit = builder.commit;
        this.skipRootJson = builder.skipRootJsonToken;
        this.parents = new LongArrayList();
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public Long call() {
        long revision = this.wtx.getRevisionNumber();
        this.insertNewContent();
        this.commit.commit(this.wtx);
        return revision;
    }

    private void json(Sequence parent, Sequence sequence, String objectField, boolean nextTokenIsParent) {
        Sequence sequence2 = sequence;
        Objects.requireNonNull(sequence2);
        Sequence sequence3 = sequence2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Atomic.class, Array.class, io.brackit.query.jdm.json.Object.class}, (Object)sequence3, n)) {
            case 0: {
                Atomic atomic = (Atomic)sequence3;
                if (sequence instanceof Numeric) {
                    Number number = JsonNumber.stringToNumber(sequence.toString());
                    if (objectField != null) {
                        NumberValue value = new NumberValue(number);
                        this.addObjectRecord(objectField, value, nextTokenIsParent);
                        break;
                    }
                    this.insertNumberValue(number, nextTokenIsParent);
                    break;
                }
                if (((Atomic)sequence).type() == Type.BOOL) {
                    boolean bool = sequence.booleanValue();
                    if (objectField != null) {
                        BooleanValue value = new BooleanValue(bool);
                        this.addObjectRecord(objectField, value, nextTokenIsParent);
                        break;
                    }
                    this.insertBooleanValue(bool, nextTokenIsParent);
                    break;
                }
                if (((Atomic)sequence).type() == Type.NULL) {
                    if (objectField != null) {
                        NullValue value = new NullValue();
                        this.addObjectRecord(objectField, value, nextTokenIsParent);
                        break;
                    }
                    this.insertNullValue(nextTokenIsParent);
                    break;
                }
                String str = ((Atomic)sequence).asStr().stringValue();
                if (objectField != null) {
                    StringValue value = new StringValue(str);
                    this.addObjectRecord(objectField, value, nextTokenIsParent);
                    break;
                }
                this.insertStringValue(str, nextTokenIsParent);
                break;
            }
            case 1: {
                Array a = (Array)sequence3;
                ++this.level;
                if (this.level != 1 || !this.skipRootJson) {
                    if (objectField != null) {
                        ArrayValue value = new ArrayValue();
                        this.addObjectRecord(objectField, value, nextTokenIsParent);
                    } else {
                        this.insertArray();
                    }
                }
                for (int i = 0; i < a.len(); ++i) {
                    Sequence seq = a.at(i);
                    this.json((Sequence)a, seq, null, false);
                }
                --this.level;
                if (this.level == 0 && this.skipRootJson) break;
                this.parents.popLong();
                this.wtx.moveTo(this.parents.peekLong(0));
                if (!(parent instanceof io.brackit.query.jdm.json.Object)) break;
                this.parents.popLong();
                this.wtx.moveTo(this.parents.peekLong(0));
                break;
            }
            case 2: {
                io.brackit.query.jdm.json.Object object = (io.brackit.query.jdm.json.Object)sequence3;
                ++this.level;
                if (this.level != 1 || !this.skipRootJson) {
                    if (objectField != null) {
                        ObjectValue value = new ObjectValue();
                        this.addObjectRecord(objectField, value, nextTokenIsParent);
                    } else {
                        this.addObject();
                    }
                }
                for (int i = 0; i < object.len(); ++i) {
                    Sequence value = object.value(i);
                    this.json((Sequence)object, value, object.name(i).stringValue(), i + 1 == object.len() || !(value instanceof Array) && !(value instanceof io.brackit.query.jdm.json.Object));
                }
                --this.level;
                if (this.level == 0 && this.skipRootJson) break;
                this.parents.popLong();
                this.wtx.moveTo(this.parents.peekLong(0));
                if (!(parent instanceof io.brackit.query.jdm.json.Object)) break;
                this.parents.popLong();
                this.wtx.moveTo(this.parents.peekLong(0));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(sequence));
            }
        }
    }

    private void insertNewContent() {
        this.level = 0;
        this.json(null, (Sequence)this.item, null, false);
    }

    private long insertStringValue(String stringValue, boolean nextTokenIsParent) {
        String value = Objects.requireNonNull(stringValue);
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertStringValueAsFirstChild(value).getNodeKey();
                }
                yield this.wtx.insertStringValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertStringValueAsLastChild(value).getNodeKey();
                }
                yield this.wtx.insertStringValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertStringValueAsLeftSibling(value).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertStringValueAsRightSibling(value).getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertBooleanValue(boolean boolValue, boolean nextTokenIsParent) {
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertBooleanValueAsFirstChild(boolValue).getNodeKey();
                }
                yield this.wtx.insertBooleanValueAsRightSibling(boolValue).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertBooleanValueAsLastChild(boolValue).getNodeKey();
                }
                yield this.wtx.insertBooleanValueAsRightSibling(boolValue).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertBooleanValueAsLeftSibling(boolValue).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertBooleanValueAsRightSibling(boolValue).getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertNumberValue(Number numberValue, boolean nextTokenIsParent) {
        Number value = Objects.requireNonNull(numberValue);
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNumberValueAsFirstChild(value).getNodeKey();
                }
                yield this.wtx.insertNumberValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNumberValueAsLastChild(value).getNodeKey();
                }
                yield this.wtx.insertNumberValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertNumberValueAsLeftSibling(value).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertNumberValueAsRightSibling(value).getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private void adaptTrxPosAndStack(boolean nextTokenIsParent, long key) {
        this.parents.popLong();
        if (nextTokenIsParent) {
            this.wtx.moveTo(this.parents.peekLong(0));
        } else {
            this.parents.push(key);
        }
    }

    private long insertNullValue(boolean nextTokenIsParent) {
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNullValueAsFirstChild().getNodeKey();
                }
                yield this.wtx.insertNullValueAsRightSibling().getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNullValueAsLastChild().getNodeKey();
                }
                yield this.wtx.insertNullValueAsRightSibling().getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertNullValueAsLeftSibling().getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertNullValueAsRightSibling().getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertArray() {
        long key = -1L;
        switch (this.insert) {
            case AS_FIRST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertArrayAsFirstChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertArrayAsRightSibling().getNodeKey();
                break;
            }
            case AS_LAST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertArrayAsLastChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertArrayAsRightSibling().getNodeKey();
                break;
            }
            case AS_LEFT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertArrayAsLeftSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertArrayAsRightSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.parents.popLong();
        this.parents.push(key);
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        return key;
    }

    private long addObject() {
        long key = -1L;
        switch (this.insert) {
            case AS_FIRST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertObjectAsFirstChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertObjectAsRightSibling().getNodeKey();
                break;
            }
            case AS_LAST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertObjectAsLastChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertObjectAsRightSibling().getNodeKey();
                break;
            }
            case AS_LEFT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertObjectAsLeftSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertObjectAsRightSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.parents.popLong();
        this.parents.push(key);
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        return key;
    }

    private void addObjectRecord(String name, ObjectRecordValue<?> value, boolean isNextTokenParentToken) {
        assert (name != null);
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertObjectRecordAsFirstChild(name, value).getNodeKey();
                }
                yield this.wtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertObjectRecordAsLastChild(name, value).getNodeKey();
                }
                yield this.wtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertObjectRecordAsLeftSibling(name, value).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
            default -> throw new AssertionError();
        };
        this.parents.popLong();
        this.parents.push(this.wtx.getParentKey());
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        if (this.wtx.getKind() == NodeKind.OBJECT || this.wtx.getKind() == NodeKind.ARRAY) {
            this.parents.popLong();
            this.parents.push(key);
            this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        } else {
            this.adaptTrxPosAndStack(isNextTokenParentToken, key);
        }
    }

    public static class Builder {
        private final JsonNodeTrx wtx;
        private final Item item;
        private final InsertPosition insert;
        private ShredderCommit commit = ShredderCommit.NOCOMMIT;
        private boolean skipRootJsonToken;

        public Builder(JsonNodeTrx wtx, Item item, InsertPosition insert) {
            this.wtx = Objects.requireNonNull(wtx);
            this.item = Objects.requireNonNull(item);
            this.insert = Objects.requireNonNull(insert);
        }

        public Builder commitAfterwards() {
            this.commit = ShredderCommit.COMMIT;
            return this;
        }

        public Builder skipRootJsonToken() {
            this.skipRootJsonToken = true;
            return this;
        }

        public JsonItemShredder build() {
            return new JsonItemShredder(this);
        }
    }
}

