/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.shredder;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.json.objectvalue.ArrayValue;
import io.sirix.access.trx.node.json.objectvalue.BooleanValue;
import io.sirix.access.trx.node.json.objectvalue.NullValue;
import io.sirix.access.trx.node.json.objectvalue.NumberValue;
import io.sirix.access.trx.node.json.objectvalue.ObjectRecordValue;
import io.sirix.access.trx.node.json.objectvalue.ObjectValue;
import io.sirix.access.trx.node.json.objectvalue.StringValue;
import io.sirix.api.Database;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.exception.SirixIOException;
import io.sirix.node.NodeKind;
import io.sirix.service.InsertPosition;
import io.sirix.service.ShredderCommit;
import io.sirix.service.json.JsonNumber;
import io.sirix.settings.Fixed;
import io.sirix.utils.LogWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongStack;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.LoggerFactory;

public final class JsonShredder
implements Callable<Long> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(JsonShredder.class));
    private final JsonNodeTrx wtx;
    private final JsonReader reader;
    private final ShredderCommit commit;
    private final LongStack parents;
    private InsertPosition insert;
    private int level;
    private final boolean skipRootJson;

    private JsonShredder(Builder builder) {
        this.wtx = builder.wtx;
        this.reader = builder.reader;
        this.insert = builder.insert;
        this.commit = builder.commit;
        this.skipRootJson = builder.skipRootJsonToken;
        this.parents = new LongArrayList();
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public Long call() {
        long revision = this.wtx.getRevisionNumber();
        this.insertNewContent();
        this.commit.commit(this.wtx);
        return revision;
    }

    private void insertNewContent() {
        try {
            this.level = 0;
            boolean endReached = false;
            long insertedRootNodeKey = -1L;
            while (this.reader.peek() != JsonToken.END_DOCUMENT && !endReached) {
                JsonToken nextToken = this.reader.peek();
                switch (nextToken) {
                    case BEGIN_OBJECT: {
                        insertedRootNodeKey = this.processBeginObject(insertedRootNodeKey);
                        break;
                    }
                    case NAME: {
                        this.processName();
                        break;
                    }
                    case END_OBJECT: {
                        endReached = this.processEndObject();
                        break;
                    }
                    case BEGIN_ARRAY: {
                        insertedRootNodeKey = this.processBeginArray(insertedRootNodeKey);
                        break;
                    }
                    case END_ARRAY: {
                        endReached = this.processEndArray();
                        break;
                    }
                    case STRING: {
                        insertedRootNodeKey = this.processString(insertedRootNodeKey);
                        break;
                    }
                    case BOOLEAN: {
                        insertedRootNodeKey = this.processBoolean(insertedRootNodeKey);
                        break;
                    }
                    case NULL: {
                        insertedRootNodeKey = this.processNull(insertedRootNodeKey);
                        break;
                    }
                    case NUMBER: {
                        insertedRootNodeKey = this.processNumber(insertedRootNodeKey);
                        break;
                    }
                }
            }
            this.wtx.moveTo(insertedRootNodeKey);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private long processNumber(long insertedRootNodeKey) throws IOException {
        Number number = this.readNumber();
        long insertedNumberValueNodeKey = this.insertNumberValue(number, this.reader.peek() == JsonToken.NAME || this.reader.peek() == JsonToken.END_OBJECT);
        if (insertedRootNodeKey == -1L) {
            insertedRootNodeKey = insertedNumberValueNodeKey;
        }
        return insertedRootNodeKey;
    }

    private long processNull(long insertedRootNodeKey) throws IOException {
        this.reader.nextNull();
        long insertedNullValueNodeKey = this.insertNullValue(this.reader.peek() == JsonToken.NAME || this.reader.peek() == JsonToken.END_OBJECT);
        if (insertedRootNodeKey == -1L) {
            insertedRootNodeKey = insertedNullValueNodeKey;
        }
        return insertedRootNodeKey;
    }

    private long processBoolean(long insertedRootNodeKey) throws IOException {
        boolean bool = this.reader.nextBoolean();
        long insertedBooleanValueNodeKey = this.insertBooleanValue(bool, this.reader.peek() == JsonToken.NAME || this.reader.peek() == JsonToken.END_OBJECT);
        if (insertedRootNodeKey == -1L) {
            insertedRootNodeKey = insertedBooleanValueNodeKey;
        }
        return insertedRootNodeKey;
    }

    private long processString(long insertedRootNodeKey) throws IOException {
        String string = this.reader.nextString();
        long insertedStringValueNodeKey = this.insertStringValue(string, this.reader.peek() == JsonToken.NAME || this.reader.peek() == JsonToken.END_OBJECT);
        if (insertedRootNodeKey == -1L) {
            insertedRootNodeKey = insertedStringValueNodeKey;
        }
        return insertedRootNodeKey;
    }

    private boolean processEndArray() throws IOException {
        boolean endReached = false;
        --this.level;
        if (this.level == 0) {
            endReached = true;
        }
        this.reader.endArray();
        this.processTrxMovement();
        return endReached;
    }

    private long processBeginArray(long insertedRootNodeKey) throws IOException {
        ++this.level;
        this.reader.beginArray();
        if (this.level != 1 || !this.skipRootJson) {
            long insertedArrayNodeKey = this.insertArray();
            if (insertedRootNodeKey == -1L) {
                insertedRootNodeKey = insertedArrayNodeKey;
            }
        }
        return insertedRootNodeKey;
    }

    private boolean processEndObject() throws IOException {
        boolean endReached = false;
        --this.level;
        if (this.level == 0) {
            endReached = true;
        }
        this.reader.endObject();
        this.processTrxMovement();
        return endReached;
    }

    private void processName() throws IOException {
        String name = this.reader.nextName();
        this.addObjectRecord(name);
    }

    private long processBeginObject(long insertedRootNodeKey) throws IOException {
        ++this.level;
        this.reader.beginObject();
        if (this.level != 1 || !this.skipRootJson) {
            long insertedObjectNodeKey = this.addObject();
            if (insertedRootNodeKey == -1L) {
                insertedRootNodeKey = insertedObjectNodeKey;
            }
        }
        return insertedRootNodeKey;
    }

    private void processTrxMovement() throws IOException {
        if (this.level != 0 || !this.skipRootJson) {
            this.parents.popLong();
            this.wtx.moveTo(this.parents.peekLong(0));
            if (this.reader.peek() == JsonToken.NAME || this.reader.peek() == JsonToken.END_OBJECT) {
                this.parents.popLong();
                this.wtx.moveTo(this.parents.peekLong(0));
            }
        }
    }

    private Number readNumber() throws IOException {
        String stringValue = this.reader.nextString();
        return JsonNumber.stringToNumber(stringValue);
    }

    private long insertStringValue(String stringValue, boolean nextTokenIsParent) {
        String value = Objects.requireNonNull(stringValue);
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertStringValueAsFirstChild(value).getNodeKey();
                }
                yield this.wtx.insertStringValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertStringValueAsLastChild(value).getNodeKey();
                }
                yield this.wtx.insertStringValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertStringValueAsLeftSibling(value).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertStringValueAsRightSibling(value).getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertBooleanValue(boolean boolValue, boolean nextTokenIsParent) {
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertBooleanValueAsFirstChild(boolValue).getNodeKey();
                }
                yield this.wtx.insertBooleanValueAsRightSibling(boolValue).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertBooleanValueAsLastChild(boolValue).getNodeKey();
                }
                yield this.wtx.insertBooleanValueAsRightSibling(boolValue).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertBooleanValueAsLeftSibling(boolValue).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertBooleanValueAsRightSibling(boolValue).getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertNumberValue(Number numberValue, boolean nextTokenIsParent) {
        Number value = Objects.requireNonNull(numberValue);
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNumberValueAsFirstChild(value).getNodeKey();
                }
                yield this.wtx.insertNumberValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNumberValueAsLastChild(value).getNodeKey();
                }
                yield this.wtx.insertNumberValueAsRightSibling(value).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertNumberValueAsLeftSibling(value).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertNumberValueAsRightSibling(value).getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private void adaptTrxPosAndStack(boolean nextTokenIsParent, long key) {
        this.parents.popLong();
        if (nextTokenIsParent) {
            this.wtx.moveTo(this.parents.peekLong(0));
        } else {
            this.parents.push(key);
        }
    }

    private long insertNullValue(boolean nextTokenIsParent) {
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNullValueAsFirstChild().getNodeKey();
                }
                yield this.wtx.insertNullValueAsRightSibling().getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertNullValueAsLastChild().getNodeKey();
                }
                yield this.wtx.insertNullValueAsRightSibling().getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertNullValueAsLeftSibling().getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertNullValueAsRightSibling().getNodeKey();
            default -> throw new AssertionError();
        };
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertArray() {
        long key;
        switch (this.insert) {
            case AS_FIRST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertArrayAsFirstChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertArrayAsRightSibling().getNodeKey();
                break;
            }
            case AS_LAST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertArrayAsLastChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertArrayAsRightSibling().getNodeKey();
                break;
            }
            case AS_LEFT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertArrayAsLeftSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertArrayAsRightSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.parents.popLong();
        this.parents.push(key);
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        return key;
    }

    private long addObject() {
        long key;
        switch (this.insert) {
            case AS_FIRST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertObjectAsFirstChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertObjectAsRightSibling().getNodeKey();
                break;
            }
            case AS_LAST_CHILD: {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertObjectAsLastChild().getNodeKey();
                    break;
                }
                key = this.wtx.insertObjectAsRightSibling().getNodeKey();
                break;
            }
            case AS_LEFT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertObjectAsLeftSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.JSON_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.wtx.insertObjectAsRightSibling().getNodeKey();
                this.insert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.parents.popLong();
        this.parents.push(key);
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        return key;
    }

    private void addObjectRecord(String name) throws IOException {
        assert (name != null);
        ObjectRecordValue<?> value = this.getObjectRecordValue();
        long key = switch (this.insert) {
            case InsertPosition.AS_FIRST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertObjectRecordAsFirstChild(name, value).getNodeKey();
                }
                yield this.wtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
            }
            case InsertPosition.AS_LAST_CHILD -> {
                if (this.parents.peekLong(0) == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    yield this.wtx.insertObjectRecordAsLastChild(name, value).getNodeKey();
                }
                yield this.wtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
            }
            case InsertPosition.AS_LEFT_SIBLING -> this.wtx.insertObjectRecordAsLeftSibling(name, value).getNodeKey();
            case InsertPosition.AS_RIGHT_SIBLING -> this.wtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
            default -> throw new AssertionError();
        };
        this.parents.popLong();
        this.parents.push(this.wtx.getParentKey());
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        if (this.wtx.getKind() == NodeKind.OBJECT || this.wtx.getKind() == NodeKind.ARRAY) {
            this.parents.popLong();
            this.parents.push(key);
            this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        } else {
            boolean isNextTokenParentToken = this.reader.peek() == JsonToken.NAME || this.reader.peek() == JsonToken.END_OBJECT;
            this.adaptTrxPosAndStack(isNextTokenParentToken, key);
        }
    }

    public ObjectRecordValue<?> getObjectRecordValue() throws IOException {
        JsonToken nextToken = this.reader.peek();
        return switch (nextToken) {
            case JsonToken.BEGIN_OBJECT -> {
                ++this.level;
                this.reader.beginObject();
                yield new ObjectValue();
            }
            case JsonToken.BEGIN_ARRAY -> {
                ++this.level;
                this.reader.beginArray();
                yield new ArrayValue();
            }
            case JsonToken.BOOLEAN -> {
                boolean booleanVal = this.reader.nextBoolean();
                yield new BooleanValue(booleanVal);
            }
            case JsonToken.STRING -> {
                String stringVal = this.reader.nextString();
                yield new StringValue(stringVal);
            }
            case JsonToken.NULL -> {
                this.reader.nextNull();
                yield new NullValue();
            }
            case JsonToken.NUMBER -> {
                Number numberVal = this.readNumber();
                yield new NumberValue(numberVal);
            }
            default -> throw new AssertionError();
        };
    }

    public static void main(String ... args) {
        if (args.length != 2 && args.length != 3) {
            throw new IllegalArgumentException("Usage: JsonShredder JSONFile Database");
        }
        LOGWRAPPER.info("Shredding '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path targetDatabasePath = Paths.get(args[1], new String[0]);
        DatabaseConfiguration databaseConfig = new DatabaseConfiguration(targetDatabasePath);
        Databases.removeDatabase(targetDatabasePath);
        Databases.createJsonDatabase(databaseConfig);
        try (Database<JsonResourceSession> db = Databases.openJsonDatabase(targetDatabasePath);){
            db.createResource(ResourceConfiguration.newBuilder("shredded").build());
            try (JsonResourceSession resMgr = db.beginResourceSession("shredded");
                 JsonNodeTrx wtx = (JsonNodeTrx)resMgr.beginNodeTrx();){
                Path path = Paths.get(args[0], new String[0]);
                JsonReader jsonReader = JsonShredder.createFileReader(path);
                JsonShredder shredder = new Builder(wtx, jsonReader, InsertPosition.AS_FIRST_CHILD).commitAfterwards().build();
                shredder.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + " ms].", new Object[0]);
    }

    public static JsonReader createFileReader(Path path) {
        Objects.requireNonNull(path);
        try {
            FileReader fileReader = new FileReader(path.toFile());
            JsonReader jsonReader = new JsonReader((Reader)fileReader);
            jsonReader.setLenient(true);
            return jsonReader;
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static JsonReader createStringReader(String json) {
        Objects.requireNonNull(json);
        StringReader stringReader = new StringReader(json);
        JsonReader jsonReader = new JsonReader((Reader)stringReader);
        jsonReader.setLenient(true);
        return jsonReader;
    }

    public static class Builder {
        private final JsonNodeTrx wtx;
        private final JsonReader reader;
        private final InsertPosition insert;
        private ShredderCommit commit = ShredderCommit.NOCOMMIT;
        private boolean skipRootJsonToken;

        public Builder(JsonNodeTrx wtx, JsonReader reader, InsertPosition insert) {
            this.wtx = Objects.requireNonNull(wtx);
            this.reader = Objects.requireNonNull(reader);
            this.insert = Objects.requireNonNull(insert);
        }

        public Builder commitAfterwards() {
            this.commit = ShredderCommit.COMMIT;
            return this;
        }

        public Builder skipRootJsonToken() {
            this.skipRootJsonToken = true;
            return this;
        }

        public JsonShredder build() {
            return new JsonShredder(this);
        }
    }
}

