/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.serialize;

import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractSerializer
implements Callable<Void> {
    protected final XmlResourceSession mResMgr;
    protected final Deque<Long> mStack = new ArrayDeque<Long>();
    protected final int[] mRevisions;
    protected final long mNodeKey;

    public AbstractSerializer(XmlResourceSession resMgr, @NonNegative int revision, int ... revisions) {
        this.mRevisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.mResMgr = Objects.requireNonNull(resMgr);
        this.mNodeKey = 0L;
    }

    public AbstractSerializer(XmlResourceSession resMgr, @NonNegative long key, @NonNegative int revision, int ... revisions) {
        this.mRevisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.mResMgr = Objects.requireNonNull(resMgr);
        this.mNodeKey = key;
    }

    private void initialize(@NonNegative int revision, int ... revisions) {
        this.mRevisions[0] = revision;
        if (revisions != null) {
            for (int i = 0; i < revisions.length; ++i) {
                this.mRevisions[i + 1] = revisions[i];
            }
        }
    }

    @Override
    public Void call() throws SirixException {
        this.emitStartDocument();
        int nrOfRevisions = this.mRevisions.length;
        int length = nrOfRevisions == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : nrOfRevisions;
        for (int i = 1; i <= length; ++i) {
            try (XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.mResMgr.beginNodeReadOnlyTrx(nrOfRevisions == 1 && this.mRevisions[0] < 0 ? i : this.mRevisions[i - 1]);){
                this.emitRevisionStartTag(rtx);
                rtx.moveTo(this.mNodeKey);
                DescendantAxis descAxis = new DescendantAxis(rtx, IncludeSelf.YES);
                boolean closeElements = false;
                long key = rtx.getNodeKey();
                while (descAxis.hasNext()) {
                    key = descAxis.next();
                    if (closeElements) {
                        while (!this.mStack.isEmpty() && this.mStack.peek().longValue() != rtx.getLeftSiblingKey()) {
                            rtx.moveTo(this.mStack.pop());
                            this.emitEndTag(rtx);
                            rtx.moveTo(key);
                        }
                        if (!this.mStack.isEmpty()) {
                            rtx.moveTo(this.mStack.pop());
                            this.emitEndTag(rtx);
                        }
                        rtx.moveTo(key);
                        closeElements = false;
                    }
                    this.emitNode(rtx);
                    if (rtx.getKind() == NodeKind.ELEMENT && rtx.hasFirstChild()) {
                        this.mStack.push(rtx.getNodeKey());
                    }
                    if (rtx.hasFirstChild() || rtx.hasRightSibling()) continue;
                    closeElements = true;
                }
                while (!this.mStack.isEmpty() && this.mStack.peek() != -15L) {
                    rtx.moveTo(this.mStack.pop());
                    this.emitEndTag(rtx);
                }
                this.emitRevisionEndTag(rtx);
                continue;
            }
        }
        this.emitEndDocument();
        return null;
    }

    protected abstract void emitStartDocument();

    protected abstract void emitNode(XmlNodeReadOnlyTrx var1);

    protected abstract void emitEndTag(XmlNodeReadOnlyTrx var1);

    protected abstract void emitRevisionStartTag(XmlNodeReadOnlyTrx var1);

    protected abstract void emitRevisionEndTag(XmlNodeReadOnlyTrx var1);

    protected abstract void emitEndDocument();
}

