/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.serialize;

import io.brackit.query.atomic.QNm;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.Utils;
import io.sirix.api.Database;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.exception.SirixException;
import io.sirix.service.AbstractSerializer;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.XMLToken;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXSerializer
extends AbstractSerializer<XmlNodeReadOnlyTrx, XmlNodeTrx>
implements XMLReader {
    private final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(SAXSerializer.class));
    private ContentHandler contentHandler;

    public SAXSerializer(XmlResourceSession resMgr, ContentHandler handler, @NonNegative int revision, int ... revisions) {
        super(resMgr, null, revision, revisions);
        this.contentHandler = handler;
    }

    @Override
    protected void emitNode(XmlNodeReadOnlyTrx rtx) {
        switch (rtx.getKind()) {
            case XML_DOCUMENT: {
                break;
            }
            case ELEMENT: {
                this.generateElement(rtx);
                break;
            }
            case TEXT: {
                this.generateText(rtx);
                break;
            }
            case COMMENT: {
                this.generateComment(rtx);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.generatePI(rtx);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Node kind not supported by sirix!");
            }
        }
    }

    @Override
    protected void emitEndNode(XmlNodeReadOnlyTrx rtx, boolean lastEndNode) {
        QNm qName = rtx.getName();
        String mURI = qName.getNamespaceURI();
        try {
            this.contentHandler.endPrefixMapping(qName.getPrefix());
            this.contentHandler.endElement(mURI, qName.getLocalName(), Utils.buildName(qName));
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionStartNode(@NonNull XmlNodeReadOnlyTrx rtx) {
        int length;
        int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
        if (length > 1) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("sdb", "revision", "sdb:revision", "", Integer.toString(rtx.getRevisionNumber()));
            try {
                this.contentHandler.startElement("https://sirix.io", "sirix-item", "sdb:sirix-item", atts);
            }
            catch (SAXException e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void emitRevisionEndNode(@NonNull XmlNodeReadOnlyTrx rtx) {
        int length;
        int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
        if (length > 1) {
            try {
                this.contentHandler.endElement("https://sirix.io", "sirix-item", "sdb:sirix-item");
            }
            catch (SAXException e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    private void generateComment(XmlNodeReadOnlyTrx rtx) {
        try {
            char[] content = rtx.getValue().toCharArray();
            this.contentHandler.characters(content, 0, content.length);
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    private void generatePI(XmlNodeReadOnlyTrx rtx) {
        try {
            this.contentHandler.processingInstruction(rtx.getName().getLocalName(), rtx.getValue());
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    private void generateElement(XmlNodeReadOnlyTrx rtx) {
        AttributesImpl atts = new AttributesImpl();
        long key = rtx.getNodeKey();
        try {
            String mURI;
            QNm qName;
            int i;
            int namesCount = rtx.getNamespaceCount();
            for (i = 0; i < namesCount; ++i) {
                rtx.moveToNamespace(i);
                qName = rtx.getName();
                this.contentHandler.startPrefixMapping(qName.getPrefix(), qName.getNamespaceURI());
                mURI = qName.getNamespaceURI();
                if (qName.getPrefix() == null || qName.getPrefix().length() == 0) {
                    atts.addAttribute(mURI, "xmlns", "xmlns", "CDATA", mURI);
                } else {
                    atts.addAttribute(mURI, "xmlns", "xmlns:" + rtx.getName().getPrefix(), "CDATA", mURI);
                }
                rtx.moveTo(key);
            }
            int attCount = rtx.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                rtx.moveToAttribute(i);
                qName = rtx.getName();
                mURI = qName.getNamespaceURI();
                atts.addAttribute(mURI, qName.getLocalName(), Utils.buildName(qName), rtx.getType(), rtx.getValue());
                rtx.moveTo(key);
            }
            QNm qName2 = rtx.getName();
            this.contentHandler.startElement(qName2.getNamespaceURI(), qName2.getLocalName(), Utils.buildName(qName2), atts);
            if (!rtx.hasFirstChild()) {
                this.contentHandler.endElement(qName2.getNamespaceURI(), qName2.getLocalName(), Utils.buildName(qName2));
            }
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    private void generateText(XmlNodeReadOnlyTrx rtx) {
        try {
            this.contentHandler.characters(XMLToken.escapeContent(rtx.getValue()).toCharArray(), 0, rtx.getValue().length());
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void setTrxForVisitor(XmlNodeReadOnlyTrx rtx) {
    }

    @Override
    protected boolean areSiblingNodesGoingToBeSkipped(XmlNodeReadOnlyTrx rtx) {
        return false;
    }

    @Override
    protected boolean isSubtreeGoingToBeVisited(XmlNodeReadOnlyTrx rtx) {
        return true;
    }

    public static void main(String ... args) {
        Path path = Paths.get(args[0], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(path);
        Databases.createXmlDatabase(config);
        Database<XmlResourceSession> database = Databases.openXmlDatabase(path);
        database.createResource(new ResourceConfiguration.Builder("shredded").build());
        try (XmlResourceSession resource = database.beginResourceSession("shredded");){
            DefaultHandler defHandler = new DefaultHandler();
            SAXSerializer serializer = new SAXSerializer(resource, defHandler, resource.getMostRecentRevisionNumber(), new int[0]);
            serializer.call();
        }
    }

    @Override
    protected void emitStartDocument() {
        try {
            int length;
            this.contentHandler.startDocument();
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (length > 1) {
                String ns = "https://sirix.io";
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("https://sirix.io", "xmlns", "xmlns:sdb", "", "https://sirix.io");
                this.contentHandler.startElement("sdb", "sirix", "sdb:sirix", atts);
            }
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndDocument() {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (length > 1) {
                this.contentHandler.endElement("sdb", "sirix", "sdb:sirix");
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void parse(String systemID) throws IOException, SAXException {
        this.emitStartDocument();
        try {
            super.call();
        }
        catch (SirixException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        this.emitEndDocument();
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = Objects.requireNonNull(contentHandler);
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }
}

