/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.serialize;

import io.brackit.query.atomic.QNm;
import io.sirix.api.Axis;
import io.sirix.api.Filter;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.filter.FilterAxis;
import io.sirix.axis.filter.xml.TextFilter;
import io.sirix.node.NodeKind;
import io.sirix.utils.XMLToken;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;

public final class StAXSerializer
implements XMLEventReader {
    private boolean mCloseElements;
    private XMLEvent mEvent;
    private final XMLEventFactory mFac = XMLEventFactory.newFactory();
    private long mKey;
    private boolean mCloseElementsEmitted;
    private boolean mNextTag = false;
    private final Axis mAxis;
    private final Deque<Long> mStack;
    private boolean mToLastKey;
    private long mLastKey;
    private final boolean mCloseRtx;
    private boolean mFirst;
    private boolean mEmitEndDocument;
    private boolean mHasNext;
    private final long mStartRightSibling;
    private final long mStartParent;
    private boolean mCalledHasNext;

    public StAXSerializer(XmlNodeReadOnlyTrx rtx) {
        this(rtx, true);
    }

    public StAXSerializer(XmlNodeReadOnlyTrx pRtx, boolean pCloseRtx) {
        this.mAxis = new DescendantAxis(Objects.requireNonNull(pRtx), IncludeSelf.YES);
        this.mCloseRtx = pCloseRtx;
        this.mStack = new ArrayDeque<Long>();
        this.mFirst = true;
        this.mEmitEndDocument = true;
        this.mHasNext = true;
        this.mStartParent = pRtx.getParentKey();
        this.mStartRightSibling = pRtx.getRightSiblingKey();
    }

    private void emitEndTag(XmlNodeReadOnlyTrx rtx) {
        long nodeKey = rtx.getNodeKey();
        QNm qName = rtx.getName();
        this.mEvent = this.mFac.createEndElement(new QName(qName.getNamespaceURI(), qName.getLocalName(), qName.getPrefix()), new NamespaceIterator(rtx));
        rtx.moveTo(nodeKey);
    }

    private void emitNode(XmlNodeReadOnlyTrx rtx) {
        switch (rtx.getKind()) {
            case XML_DOCUMENT: {
                this.mEvent = this.mFac.createStartDocument();
                break;
            }
            case ELEMENT: {
                long key = rtx.getNodeKey();
                QNm qName = rtx.getName();
                this.mEvent = this.mFac.createStartElement(new QName(qName.getNamespaceURI(), qName.getLocalName(), qName.getPrefix()), new AttributeIterator(rtx), new NamespaceIterator(rtx));
                rtx.moveTo(key);
                break;
            }
            case TEXT: {
                this.mEvent = this.mFac.createCharacters(XMLToken.escapeContent(rtx.getValue()));
                break;
            }
            case COMMENT: {
                this.mEvent = this.mFac.createComment(XMLToken.escapeContent(rtx.getValue()));
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.mEvent = this.mFac.createProcessingInstruction(rtx.getName().getLocalName(), rtx.getValue());
                break;
            }
            default: {
                throw new IllegalStateException("Kind not known!");
            }
        }
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.mCloseRtx) {
            this.mAxis.asXmlNodeReadTrx().close();
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        XmlNodeReadOnlyTrx rtx = this.mAxis.asXmlNodeReadTrx();
        long nodeKey = rtx.getNodeKey();
        if (this.mCloseElements && this.mToLastKey) {
            rtx.moveTo(this.mLastKey);
        }
        if (this.mEvent.getEventType() != 1) {
            rtx.moveTo(nodeKey);
            throw new XMLStreamException("getElementText() only can be called on a start element");
        }
        FilterAxis<XmlNodeReadOnlyTrx> textFilterAxis = new FilterAxis<XmlNodeReadOnlyTrx>(new DescendantAxis(rtx), new TextFilter(rtx), new Filter[0]);
        StringBuilder strBuilder = new StringBuilder();
        while (textFilterAxis.hasNext()) {
            textFilterAxis.next();
            strBuilder.append(rtx.getValue());
        }
        rtx.moveTo(nodeKey);
        return XMLToken.escapeContent(strBuilder.toString());
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        boolean retVal = false;
        retVal = !this.mStack.isEmpty() && (this.mCloseElements || this.mCloseElementsEmitted) ? true : this.mAxis.hasNext();
        if (!retVal && this.mEmitEndDocument) {
            this.mHasNext = false;
            retVal = !retVal;
        }
        return retVal;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (!this.mCalledHasNext && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            if (this.mHasNext && !this.mCloseElements && !this.mCloseElementsEmitted) {
                this.mKey = this.mAxis.next();
                if (this.mNextTag) {
                    if (this.mAxis.asXmlNodeReadTrx().getKind() != NodeKind.ELEMENT) {
                        throw new XMLStreamException("The next tag isn't a start- or end-tag!");
                    }
                    this.mNextTag = false;
                }
            }
            if (!this.mHasNext && this.mEmitEndDocument) {
                this.mEmitEndDocument = false;
                this.mEvent = this.mFac.createEndDocument();
            } else {
                this.emit(this.mAxis.asXmlNodeReadTrx());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.mFirst = false;
        return this.mEvent;
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        this.mNextTag = true;
        return this.nextEvent();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        long currNodeKey = this.mAxis.asXmlNodeReadTrx().getNodeKey();
        XmlNodeReadOnlyTrx rtx = this.mAxis.asXmlNodeReadTrx();
        if (!this.mHasNext && this.mEmitEndDocument) {
            this.mEvent = this.mFac.createEndDocument();
        } else {
            if (!this.mHasNext) {
                return null;
            }
            if (this.mCloseElements && !this.mCloseElementsEmitted && !this.mStack.isEmpty()) {
                rtx.moveTo(this.mStack.peek());
                this.emitEndTag(rtx);
            } else if (this.mFirst && this.mAxis.includeSelf() == IncludeSelf.YES) {
                this.emitNode(rtx);
            } else if (rtx.hasFirstChild()) {
                rtx.moveToFirstChild();
                this.emitNode(rtx);
            } else if (rtx.hasRightSibling()) {
                if (rtx.getRightSiblingKey() == this.mStartRightSibling) {
                    this.mEvent = this.mFac.createEndDocument();
                } else {
                    rtx.moveToRightSibling();
                    NodeKind nodeKind = rtx.getKind();
                    this.processNode(nodeKind);
                }
            } else if (rtx.hasParent()) {
                if (rtx.getParentKey() == this.mStartParent) {
                    this.mEvent = this.mFac.createEndDocument();
                } else {
                    rtx.moveToParent();
                    this.emitEndTag(rtx);
                }
            }
        }
        rtx.moveTo(currNodeKey);
        this.mFirst = false;
        return this.mEvent;
    }

    @Override
    public Object next() {
        try {
            this.mEvent = this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return this.mEvent;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported!");
    }

    private void processNode(NodeKind nodeKind) {
        assert (nodeKind != null);
        switch (nodeKind) {
            case ELEMENT: {
                this.emitEndTag(this.mAxis.asXmlNodeReadTrx());
                break;
            }
            case TEXT: 
            case COMMENT: 
            case PROCESSING_INSTRUCTION: {
                this.emitNode(this.mAxis.asXmlNodeReadTrx());
                break;
            }
        }
    }

    private void emit(XmlNodeReadOnlyTrx rtx) throws IOException {
        assert (rtx != null);
        if (this.mCloseElements) {
            if (!this.mStack.isEmpty() && this.mStack.peek().longValue() != rtx.getLeftSiblingKey()) {
                rtx.moveTo(this.mStack.pop());
                this.emitEndTag(rtx);
                rtx.moveTo(this.mKey);
            } else if (!this.mStack.isEmpty()) {
                rtx.moveTo(this.mStack.pop());
                this.emitEndTag(rtx);
                rtx.moveTo(this.mKey);
                this.mCloseElementsEmitted = true;
                this.mCloseElements = false;
            }
        } else {
            this.mCloseElementsEmitted = false;
            this.emitNode(rtx);
            this.mLastKey = rtx.getNodeKey();
            if (rtx.getKind() == NodeKind.ELEMENT) {
                this.mStack.push(this.mLastKey);
            }
            if (!rtx.hasFirstChild() && !rtx.hasRightSibling() || rtx.getKind() == NodeKind.ELEMENT && !rtx.hasFirstChild()) {
                this.moveToNextNode();
            }
        }
    }

    private void moveToNextNode() {
        this.mToLastKey = true;
        if (this.mAxis.hasNext()) {
            this.mKey = this.mAxis.next();
        }
        this.mCloseElements = true;
    }

    private static final class NamespaceIterator
    implements Iterator<Namespace> {
        private final XmlNodeReadOnlyTrx mRtx;
        private final int mNamespCount;
        private int mIndex;
        private final long mNodeKey;
        private final XMLEventFactory mFac = XMLEventFactory.newInstance();

        public NamespaceIterator(XmlNodeReadOnlyTrx rtx) {
            this.mRtx = Objects.requireNonNull(rtx);
            this.mNodeKey = this.mRtx.getNodeKey();
            this.mIndex = 0;
            this.mNamespCount = this.mRtx.getKind() == NodeKind.ELEMENT ? this.mRtx.getNamespaceCount() : 0;
        }

        @Override
        public boolean hasNext() {
            boolean retVal = false;
            if (this.mIndex < this.mNamespCount) {
                retVal = true;
            }
            return retVal;
        }

        @Override
        public Namespace next() {
            this.mRtx.moveTo(this.mNodeKey);
            this.mRtx.moveToNamespace(this.mIndex++);
            assert (this.mRtx.getKind() == NodeKind.NAMESPACE);
            QNm qName = this.mRtx.getName();
            this.mRtx.moveTo(this.mNodeKey);
            return this.mFac.createNamespace(qName.getPrefix(), qName.getNamespaceURI());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }
    }

    private static final class AttributeIterator
    implements Iterator<Attribute> {
        private final XmlNodeReadOnlyTrx mRtx;
        private final int mAttCount;
        private int mIndex;
        private final long mNodeKey;
        private final XMLEventFactory mFac = XMLEventFactory.newFactory();

        public AttributeIterator(XmlNodeReadOnlyTrx rtx) {
            this.mRtx = Objects.requireNonNull(rtx);
            this.mNodeKey = this.mRtx.getNodeKey();
            this.mIndex = 0;
            this.mAttCount = this.mRtx.getKind() == NodeKind.ELEMENT ? this.mRtx.getAttributeCount() : 0;
        }

        @Override
        public boolean hasNext() {
            boolean retVal = false;
            if (this.mIndex < this.mAttCount) {
                retVal = true;
            }
            return retVal;
        }

        @Override
        public Attribute next() {
            this.mRtx.moveTo(this.mNodeKey);
            this.mRtx.moveToAttribute(this.mIndex++);
            assert (this.mRtx.getKind() == NodeKind.ATTRIBUTE);
            QNm qName = this.mRtx.getName();
            String value = XMLToken.escapeAttribute(this.mRtx.getValue());
            this.mRtx.moveTo(this.mNodeKey);
            return this.mFac.createAttribute(new QName(qName.getNamespaceURI(), qName.getLocalName(), qName.getPrefix()), value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }
    }
}

