/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.serialize;

import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.node.immutable.xml.ImmutableAttributeNode;
import io.sirix.node.immutable.xml.ImmutableComment;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.immutable.xml.ImmutableNamespace;
import io.sirix.node.immutable.xml.ImmutablePI;
import io.sirix.node.immutable.xml.ImmutableText;
import io.sirix.node.immutable.xml.ImmutableXmlDocumentRootNode;
import io.sirix.node.interfaces.immutable.ImmutableStructNode;

public final class XmlMaxLevelVisitor
implements XmlNodeVisitor {
    private final long maxLevel;
    private XmlNodeReadOnlyTrx rtx;
    private long currentLevel;
    private VisitResultType lastVisitResultType;

    public XmlMaxLevelVisitor(long maxLevel) {
        this.maxLevel = maxLevel;
    }

    public XmlMaxLevelVisitor setTrx(XmlNodeReadOnlyTrx rtx) {
        this.rtx = rtx;
        return this;
    }

    public VisitResultType getLastVisitResultType() {
        return this.lastVisitResultType;
    }

    public long getCurrentLevel() {
        return this.currentLevel;
    }

    public long getMaxLevel() {
        return this.maxLevel;
    }

    private void adaptLevel(ImmutableStructNode node) {
        if (node.hasFirstChild()) {
            ++this.currentLevel;
        } else if (!node.hasRightSibling()) {
            do {
                this.rtx.moveToParent();
                --this.currentLevel;
            } while (!this.rtx.hasRightSibling() && this.currentLevel > 0L);
        }
    }

    private VisitResult getVisitResultType() {
        if (this.currentLevel >= this.maxLevel) {
            --this.currentLevel;
            this.lastVisitResultType = VisitResultType.SKIPSUBTREE;
            return this.lastVisitResultType;
        }
        this.lastVisitResultType = VisitResultType.CONTINUE;
        return this.lastVisitResultType;
    }

    @Override
    public VisitResult visit(ImmutablePI node) {
        return this.getVisitResultType();
    }

    @Override
    public VisitResult visit(ImmutableComment node) {
        return this.getVisitResultType();
    }

    @Override
    public VisitResult visit(ImmutableElement node) {
        this.adaptLevel(node);
        VisitResult visitResult = this.getVisitResultType();
        return visitResult;
    }

    @Override
    public VisitResult visit(ImmutableAttributeNode node) {
        return VisitResultType.CONTINUE;
    }

    @Override
    public VisitResult visit(ImmutableNamespace node) {
        return VisitResultType.CONTINUE;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        return this.getVisitResultType();
    }

    @Override
    public VisitResult visit(ImmutableXmlDocumentRootNode node) {
        return VisitResultType.CONTINUE;
    }
}

