/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.serialize;

import com.google.common.base.Preconditions;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.Database;
import io.sirix.api.visitor.NodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.node.NodeKind;
import io.sirix.service.AbstractSerializer;
import io.sirix.service.xml.serialize.XmlMaxLevelVisitor;
import io.sirix.service.xml.serialize.XmlSerializerProperties;
import io.sirix.settings.CharsForSerializing;
import io.sirix.settings.Constants;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.SirixFiles;
import io.sirix.utils.XMLToken;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.LoggerFactory;

public final class XmlSerializer
extends AbstractSerializer<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(XmlSerializer.class));
    private static final int ASCII_OFFSET = 48;
    private static final long[] LONG_POWERS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final OutputStream out;
    private final boolean indent;
    private final boolean serializeXMLDeclaration;
    private final boolean serializeRest;
    private final boolean serializeRestSequence;
    private final boolean serializeId;
    private final int indentSpaces;
    private final boolean withInitialIndent;
    private final boolean emitXQueryResultSequence;
    private final boolean serializeTimestamp;
    private final boolean metaData;

    private XmlSerializer(XmlResourceSession resourceMgr, @NonNegative long nodeKey, XmlSerializerBuilder builder, boolean initialIndent, @NonNegative int revision, int ... revsions) {
        super(resourceMgr, (NodeVisitor)(builder.maxLevel == -1L ? null : new XmlMaxLevelVisitor(builder.maxLevel)), nodeKey, revision, revsions);
        this.out = new BufferedOutputStream(builder.stream, 4096);
        this.indent = builder.indent;
        this.serializeXMLDeclaration = builder.declaration;
        this.serializeRest = builder.rest;
        this.serializeRestSequence = builder.restSequence;
        this.serializeId = builder.id;
        this.indentSpaces = builder.indentSpaces;
        this.withInitialIndent = builder.initialIndent;
        this.emitXQueryResultSequence = builder.emitXQueryResultSequence;
        this.serializeTimestamp = builder.serializeTimestamp;
        this.metaData = builder.metaData;
    }

    @Override
    protected void emitNode(XmlNodeReadOnlyTrx rtx) {
        try {
            switch (rtx.getKind()) {
                case XML_DOCUMENT: {
                    break;
                }
                case ELEMENT: {
                    int index;
                    this.indent();
                    this.out.write(CharsForSerializing.OPEN.getBytes());
                    this.writeQName(rtx);
                    long key = rtx.getNodeKey();
                    int nspCount = rtx.getNamespaceCount();
                    for (index = 0; index < nspCount; ++index) {
                        rtx.moveToNamespace(index);
                        if (rtx.getPrefixKey() == -1) {
                            this.out.write(CharsForSerializing.XMLNS.getBytes());
                            this.write(rtx.nameForKey(rtx.getURIKey()));
                            this.out.write(CharsForSerializing.QUOTE.getBytes());
                        } else {
                            this.out.write(CharsForSerializing.XMLNS_COLON.getBytes());
                            this.write(rtx.nameForKey(rtx.getPrefixKey()));
                            this.out.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                            this.write(rtx.nameForKey(rtx.getURIKey()));
                            this.out.write(CharsForSerializing.QUOTE.getBytes());
                        }
                        rtx.moveTo(key);
                    }
                    if (this.serializeId || this.metaData) {
                        if (this.serializeRest) {
                            this.out.write(CharsForSerializing.REST_PREFIX.getBytes());
                        } else if (this.revisions.length > 1 || this.revisions.length == 1 && this.revisions[0] == -1) {
                            this.out.write(CharsForSerializing.SID_PREFIX.getBytes());
                        } else {
                            this.out.write(CharsForSerializing.SPACE.getBytes());
                        }
                        this.out.write(CharsForSerializing.ID.getBytes());
                        this.out.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                        this.write(rtx.getNodeKey());
                        this.out.write(CharsForSerializing.QUOTE.getBytes());
                    }
                    if (this.metaData) {
                        if (this.serializeRest) {
                            this.out.write(CharsForSerializing.REST_PREFIX.getBytes());
                        } else if (this.revisions.length > 1 || this.revisions.length == 1 && this.revisions[0] == -1) {
                            this.out.write(CharsForSerializing.SID_PREFIX.getBytes());
                        } else {
                            this.out.write(CharsForSerializing.SPACE.getBytes());
                        }
                        this.out.write(CharsForSerializing.ID.getBytes());
                        this.out.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                        this.write(rtx.getNodeKey());
                        this.out.write(CharsForSerializing.QUOTE.getBytes());
                    }
                    int attCount = rtx.getAttributeCount();
                    for (index = 0; index < attCount; ++index) {
                        rtx.moveToAttribute(index);
                        this.out.write(CharsForSerializing.SPACE.getBytes());
                        this.writeQName(rtx);
                        this.out.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                        this.out.write(XMLToken.escapeAttribute(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                        this.out.write(CharsForSerializing.QUOTE.getBytes());
                        rtx.moveTo(key);
                    }
                    if (rtx.hasFirstChild() && (this.visitor == null || this.currentLevel() + 1L < this.maxLevel())) {
                        this.out.write(CharsForSerializing.CLOSE.getBytes());
                    } else {
                        this.out.write(CharsForSerializing.SLASH_CLOSE.getBytes());
                    }
                    if (this.indent && (rtx.getFirstChildKind() != NodeKind.TEXT || rtx.getChildCount() != 1L)) {
                        this.out.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    break;
                }
                case COMMENT: {
                    this.indent();
                    this.out.write(CharsForSerializing.OPENCOMMENT.getBytes());
                    this.out.write(XMLToken.escapeContent(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                    if (this.indent) {
                        this.out.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    this.out.write(CharsForSerializing.CLOSECOMMENT.getBytes());
                    break;
                }
                case TEXT: {
                    if (rtx.hasRightSibling() || rtx.hasLeftSibling()) {
                        this.indent();
                    }
                    this.out.write(XMLToken.escapeContent(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                    if (this.indent && (rtx.hasRightSibling() || rtx.hasLeftSibling())) {
                        this.out.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    this.indent();
                    this.out.write(CharsForSerializing.OPENPI.getBytes());
                    this.writeQName(rtx);
                    this.out.write(CharsForSerializing.SPACE.getBytes());
                    this.out.write(XMLToken.escapeContent(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                    if (this.indent) {
                        this.out.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    this.out.write(CharsForSerializing.CLOSEPI.getBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node kind not known!");
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndNode(XmlNodeReadOnlyTrx rtx, boolean lastEndNode) {
        try {
            if (this.indent && (rtx.getFirstChildKind() != NodeKind.TEXT || rtx.getChildCount() != 1L)) {
                this.indent();
            }
            this.out.write(CharsForSerializing.OPEN_SLASH.getBytes());
            this.writeQName(rtx);
            this.out.write(CharsForSerializing.CLOSE.getBytes());
            if (this.indent) {
                this.out.write(CharsForSerializing.NEWLINE.getBytes());
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private void writeQName(XmlNodeReadOnlyTrx rtx) throws IOException {
        if (rtx.getPrefixKey() != -1) {
            this.out.write(rtx.rawNameForKey(rtx.getPrefixKey()));
            this.out.write(CharsForSerializing.COLON.getBytes());
        }
        this.out.write(rtx.rawNameForKey(rtx.getLocalNameKey()));
    }

    @Override
    protected void emitStartDocument() {
        try {
            int length;
            if (this.serializeXMLDeclaration) {
                this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
                if (this.indent) {
                    this.out.write(CharsForSerializing.NEWLINE.getBytes());
                }
            }
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (this.serializeRestSequence || length > 1) {
                if (this.serializeRestSequence) {
                    this.write("<rest:sequence xmlns:rest=\"https://sirix.io/rest\">");
                } else {
                    this.write("<sdb:sirix xmlns:sdb=\"https://sirix.io/rest\">");
                }
                if (this.indent) {
                    this.out.write(CharsForSerializing.NEWLINE.getBytes());
                    this.stack.push(-15L);
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndDocument() {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (this.serializeRestSequence || length > 1) {
                if (this.indent) {
                    this.stack.popLong();
                }
                this.indent();
                if (this.serializeRestSequence) {
                    this.write("</rest:sequence>");
                } else {
                    this.write("</sdb:sirix>");
                }
            }
            this.out.flush();
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionStartNode(@NonNull XmlNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (this.serializeRest || length > 1) {
                this.indent();
                if (this.serializeRest) {
                    this.write("<rest:item");
                } else {
                    this.write("<sdb:sirix-item");
                }
                if (length > 1 || this.emitXQueryResultSequence) {
                    if (this.serializeRest) {
                        this.write(" rest:revision=\"");
                    } else {
                        this.write(" sdb:revision=\"");
                    }
                    this.write(Integer.toString(rtx.getRevisionNumber()));
                    this.write("\"");
                    if (this.serializeTimestamp) {
                        if (this.serializeRest) {
                            this.write(" rest:revisionTimestamp=\"");
                        } else {
                            this.write(" sdb:revisionTimestamp=\"");
                        }
                        this.write(DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).format(rtx.getRevisionTimestamp()));
                        this.write("\"");
                    }
                    this.write(">");
                } else if (this.serializeRest) {
                    this.write(">");
                }
                if (rtx.hasFirstChild()) {
                    this.stack.push(-15L);
                }
                if (this.indent) {
                    this.out.write(CharsForSerializing.NEWLINE.getBytes());
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionEndNode(@NonNull XmlNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.revisions.length == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : this.revisions.length;
            if (this.serializeRest || length > 1) {
                if (rtx.moveToDocumentRoot() && rtx.hasFirstChild()) {
                    this.stack.popLong();
                }
                this.indent();
                if (this.serializeRest) {
                    this.write("</rest:item>");
                } else {
                    this.write("</sdb:sirix-item>");
                }
            }
            if (this.indent) {
                this.out.write(CharsForSerializing.NEWLINE.getBytes());
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void setTrxForVisitor(XmlNodeReadOnlyTrx rtx) {
        this.castVisitor().setTrx(rtx);
    }

    @Override
    protected boolean areSiblingNodesGoingToBeSkipped(XmlNodeReadOnlyTrx rtx) {
        return false;
    }

    @Override
    protected boolean isSubtreeGoingToBeVisited(XmlNodeReadOnlyTrx rtx) {
        return this.visitor == null || this.currentLevel() + 1L < this.maxLevel();
    }

    private long maxLevel() {
        return this.castVisitor().getMaxLevel();
    }

    private XmlMaxLevelVisitor castVisitor() {
        return (XmlMaxLevelVisitor)this.visitor;
    }

    private long currentLevel() {
        return this.castVisitor().getCurrentLevel();
    }

    private void indent() throws IOException {
        if (this.indent) {
            int indentSpaces = this.withInitialIndent ? (this.stack.size() + 1) * this.indentSpaces : this.stack.size() * this.indentSpaces;
            for (int i = 0; i < indentSpaces; ++i) {
                this.out.write(" ".getBytes(Constants.DEFAULT_ENCODING));
            }
        }
    }

    private void write(String value) throws UnsupportedEncodingException, IOException {
        this.out.write(value.getBytes(Constants.DEFAULT_ENCODING));
    }

    private void write(long value) throws IOException {
        int length = (int)Math.log10(value);
        long remainder = value;
        for (int i = length; i >= 0; --i) {
            byte digit = (byte)(remainder / LONG_POWERS[i]);
            this.out.write((byte)(digit + 48));
            remainder -= (long)digit * LONG_POWERS[i];
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            throw new IllegalArgumentException("Usage: XMLSerializer input-TT output.xml");
        }
        LOGWRAPPER.info("Serializing '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path target = Paths.get(args[1], new String[0]);
        SirixFiles.recursiveRemove(target);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.createFile(target, new FileAttribute[0]);
        Files.deleteIfExists(target);
        Path databaseFile = Paths.get(args[0], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(databaseFile);
        Databases.createXmlDatabase(config);
        try (Database<XmlResourceSession> db = Databases.openXmlDatabase(databaseFile);){
            db.createResource(ResourceConfiguration.newBuilder("shredded").build());
            try (XmlResourceSession resMgr = db.beginResourceSession("shredded");
                 FileOutputStream outputStream = new FileOutputStream(target.toFile());){
                XmlSerializer serializer = XmlSerializer.newBuilder(resMgr, outputStream, new int[0]).emitXMLDeclaration().build();
                serializer.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + "ms].", new Object[0]);
    }

    public static XmlSerializerBuilder newBuilder(XmlResourceSession resMgr, OutputStream stream, int ... revisions) {
        return new XmlSerializerBuilder(resMgr, stream, revisions);
    }

    public static XmlSerializerBuilder newBuilder(XmlResourceSession resMgr, @NonNegative long nodeKey, OutputStream stream, XmlSerializerProperties properties, int ... revisions) {
        return new XmlSerializerBuilder(resMgr, nodeKey, stream, properties, revisions);
    }

    public static final class XmlSerializerBuilder {
        public boolean restSequence;
        private boolean indent;
        private boolean rest;
        private boolean declaration;
        private boolean id;
        private int indentSpaces = 2;
        private final OutputStream stream;
        private final XmlResourceSession resourceMgr;
        private int[] versions;
        private int version;
        private long nodeKey;
        private boolean initialIndent;
        private boolean emitXQueryResultSequence;
        private boolean serializeTimestamp;
        private boolean metaData;
        private long maxLevel;

        public XmlSerializerBuilder(XmlResourceSession resourceMgr, OutputStream stream, int ... revisions) {
            this.maxLevel = -1L;
            this.nodeKey = 0L;
            this.resourceMgr = Objects.requireNonNull(resourceMgr);
            this.stream = Objects.requireNonNull(stream);
            if (revisions == null || revisions.length == 0) {
                this.version = this.resourceMgr.getMostRecentRevisionNumber();
            } else {
                this.version = revisions[0];
                this.versions = new int[revisions.length - 1];
                System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            }
        }

        public XmlSerializerBuilder(XmlResourceSession resourceMgr, @NonNegative long nodeKey, OutputStream stream, XmlSerializerProperties properties, int ... revisions) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
            this.maxLevel = -1L;
            this.resourceMgr = Objects.requireNonNull(resourceMgr);
            this.nodeKey = nodeKey;
            this.stream = Objects.requireNonNull(stream);
            if (revisions == null || revisions.length == 0) {
                this.version = this.resourceMgr.getMostRecentRevisionNumber();
            } else {
                this.version = revisions[0];
                this.versions = new int[revisions.length - 1];
                System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            }
            ConcurrentMap<String, Object> map = Objects.requireNonNull(properties.getProps());
            this.indent = Objects.requireNonNull((Boolean)map.get(XmlSerializerProperties.S_INDENT[0]));
            this.rest = Objects.requireNonNull((Boolean)map.get(XmlSerializerProperties.S_REST[0]));
            this.id = Objects.requireNonNull((Boolean)map.get(XmlSerializerProperties.S_ID[0]));
            this.indentSpaces = Objects.requireNonNull((Integer)map.get(XmlSerializerProperties.S_INDENT_SPACES[0]));
            this.declaration = Objects.requireNonNull((Boolean)map.get(XmlSerializerProperties.S_XMLDECL[0]));
        }

        public XmlSerializerBuilder startNodeKey(long nodeKey) {
            this.nodeKey = nodeKey;
            return this;
        }

        public XmlSerializerBuilder withInitialIndent() {
            this.initialIndent = true;
            return this;
        }

        public XmlSerializerBuilder isXQueryResultSequence() {
            this.emitXQueryResultSequence = true;
            return this;
        }

        public XmlSerializerBuilder serializeTimestamp(boolean serializeTimestamp) {
            this.serializeTimestamp = serializeTimestamp;
            return this;
        }

        public XmlSerializerBuilder prettyPrint() {
            this.indent = true;
            return this;
        }

        public XmlSerializerBuilder emitRESTful() {
            this.rest = true;
            return this;
        }

        public XmlSerializerBuilder emitRESTSequence() {
            this.restSequence = true;
            return this;
        }

        public XmlSerializerBuilder emitXMLDeclaration() {
            this.declaration = true;
            return this;
        }

        public XmlSerializerBuilder emitIDs() {
            this.id = true;
            return this;
        }

        public XmlSerializerBuilder emitMetaData() {
            this.metaData = true;
            return this;
        }

        public XmlSerializerBuilder maxLevel(long maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public XmlSerializerBuilder revisions(int[] revisions) {
            Objects.requireNonNull(revisions);
            this.version = revisions[0];
            this.versions = new int[revisions.length - 1];
            System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            return this;
        }

        public XmlSerializer build() {
            return new XmlSerializer(this.resourceMgr, this.nodeKey, this, this.initialIndent, this.version, this.versions);
        }
    }
}

