/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.shredder;

import io.brackit.query.atomic.QNm;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import io.sirix.service.InsertPosition;
import io.sirix.service.xml.shredder.Shredder;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongStack;
import java.util.Objects;

public abstract class AbstractShredder
implements Shredder<String, QNm> {
    private final XmlNodeTrx wtx;
    private final LongStack parents;
    private InsertPosition insertLocation;

    public AbstractShredder(XmlNodeTrx wtx, InsertPosition insertLocation) {
        this.wtx = Objects.requireNonNull(wtx);
        this.insertLocation = Objects.requireNonNull(insertLocation);
        this.parents = new LongArrayList();
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public void processComment(String commentValue) throws SirixException {
        String value = Objects.requireNonNull(commentValue);
        if (!value.isEmpty()) {
            long key = this.parents.topLong() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.wtx.insertCommentAsFirstChild(value).getNodeKey() : this.wtx.insertCommentAsRightSibling(value).getNodeKey();
            this.parents.popLong();
            this.parents.push(key);
        }
    }

    @Override
    public void processPI(String processingContent, String processingTarget) throws SirixException {
        String content = Objects.requireNonNull(processingContent);
        String target = Objects.requireNonNull(processingTarget);
        if (!target.isEmpty()) {
            long key = this.parents.topLong() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.wtx.insertPIAsFirstChild(target, content).getNodeKey() : this.wtx.insertPIAsRightSibling(target, content).getNodeKey();
            this.parents.popLong();
            this.parents.push(key);
        }
    }

    @Override
    public void processText(String textValue) throws SirixException {
        String text = Objects.requireNonNull(textValue);
        if (!text.isEmpty()) {
            long key = this.parents.topLong() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.wtx.insertTextAsFirstChild(text).getNodeKey() : this.wtx.insertTextAsRightSibling(text).getNodeKey();
            this.parents.popLong();
            this.parents.push(key);
        }
    }

    @Override
    public void processStartTag(QNm elementName) throws SirixException {
        long key;
        QNm name = Objects.requireNonNull(elementName);
        switch (this.insertLocation) {
            case AS_FIRST_CHILD: {
                if (this.parents.topLong() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.wtx.insertElementAsFirstChild(name).getNodeKey();
                    break;
                }
                key = this.wtx.insertElementAsRightSibling(name).getNodeKey();
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.XML_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-element!");
                }
                key = this.wtx.insertElementAsRightSibling(name).getNodeKey();
                this.insertLocation = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            case AS_LEFT_SIBLING: {
                if (this.wtx.getKind() == NodeKind.XML_DOCUMENT || this.wtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-element!");
                }
                key = this.wtx.insertElementAsLeftSibling(name).getNodeKey();
                this.insertLocation = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.parents.popLong();
        this.parents.push(key);
        this.parents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public void processEndTag(QNm elementName) {
        this.parents.popLong();
        this.wtx.moveTo(this.parents.topLong());
    }

    @Override
    public void processEmptyElement(QNm elementName) throws SirixException {
        this.processStartTag(elementName);
        this.processEndTag(elementName);
    }
}

