/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.shredder;

import io.brackit.query.atomic.QNm;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.Database;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixIOException;
import io.sirix.node.NodeKind;
import io.sirix.service.InsertPosition;
import io.sirix.service.ShredderCommit;
import io.sirix.service.xml.shredder.XmlShredder;
import io.sirix.settings.Fixed;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.TypedValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.LoggerFactory;

@Deprecated
public final class XMLUpdateShredder
implements Callable<Long> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(XMLUpdateShredder.class));
    protected transient File mFile;
    protected transient Queue<XMLEvent> mEvents;
    private transient long mNodeKey;
    private transient boolean mFound;
    private transient boolean mInsertedEndTag;
    private transient boolean mMovedToRightSibling;
    private transient boolean mRemovedNode;
    private transient boolean mIsRightSibling;
    private transient long mLastNodeKey;
    private transient long mKeyMatches;
    private transient long mMaxNodeKey;
    private transient ShredderCommit mCommit;
    private transient int mLevelInToShredder;
    private transient QName mRootElem;
    private transient EInternalInsert mInternalInsert;
    private transient EDelete mDelete;
    private transient boolean mInserted;
    private transient boolean mEmptyElement;
    private final XmlNodeTrx mWtx;
    private final XMLEventReader mReader;
    private InsertPosition mInsert;

    public XMLUpdateShredder(XmlNodeTrx paramWtx, XMLEventReader paramReader, InsertPosition paramAddAsFirstChild, Object paramData, ShredderCommit paramCommit) throws SirixIOException {
        this.mInsert = paramAddAsFirstChild;
        this.mWtx = paramWtx;
        this.mReader = paramReader;
        if (paramData == null || paramCommit == null) {
            throw new IllegalArgumentException("None of the constructor parameters may be null!");
        }
        this.mMaxNodeKey = this.mWtx.getMaxNodeKey();
        this.mCommit = paramCommit;
        if (paramData instanceof File) {
            this.mFile = (File)paramData;
        } else if (paramData instanceof List) {
            this.mEvents = (ArrayDeque)paramData;
        }
    }

    @Override
    public Long call() throws SirixException {
        long revision = this.mWtx.getRevisionNumber();
        this.updateOnly();
        if (this.mCommit == ShredderCommit.COMMIT) {
            this.mWtx.commit();
        }
        return revision;
    }

    private void updateOnly() throws SirixException {
        try {
            this.mLevelInToShredder = 0;
            this.mMovedToRightSibling = false;
            boolean firstEvent = true;
            if (this.mMaxNodeKey == 0L) {
                new XmlShredder.Builder(this.mWtx, this.mReader, this.mInsert).build().call();
            } else {
                if (this.mWtx.getKind() == NodeKind.XML_DOCUMENT) {
                    long startkey = Fixed.DOCUMENT_NODE_KEY.getStandardProperty() + 1L;
                    while (!this.mWtx.moveTo(startkey)) {
                        ++startkey;
                    }
                }
                XMLEvent event = null;
                StringBuilder sBuilder = new StringBuilder();
                XMLEventFactory fac = XMLEventFactory.newInstance();
                block9: while (this.mReader.hasNext()) {
                    if (this.mDelete == EDelete.ATSTARTMIDDLE) {
                        this.mDelete = EDelete.NODELETE;
                    } else {
                        event = this.mReader.nextEvent();
                        if (event.isCharacters() && event.asCharacters().isWhiteSpace()) continue;
                        assert (event != null);
                        if (firstEvent) {
                            firstEvent = false;
                            if (event.getEventType() == 7) {
                                while (this.mReader.hasNext() && event.getEventType() != 1) {
                                    event = this.mReader.nextEvent();
                                }
                                assert (event.getEventType() == 1);
                            }
                            if (event.getEventType() != 1) {
                                throw new IllegalStateException("StAX parser has to be on START_DOCUMENT or START_ELEMENT event!");
                            }
                            this.mRootElem = event.asStartElement().getName();
                        } else if (event != null && event.isEndElement() && this.mRootElem.equals(event.asEndElement().getName()) && this.mLevelInToShredder == 1) break;
                    }
                    assert (event != null);
                    switch (event.getEventType()) {
                        case 1: {
                            this.processStartTag(event.asStartElement());
                            continue block9;
                        }
                        case 4: {
                            sBuilder.append(event.asCharacters().getData());
                            while (this.mReader.peek().getEventType() == 4) {
                                sBuilder.append(this.mReader.nextEvent().asCharacters().getData());
                            }
                            Characters text = fac.createCharacters(sBuilder.toString().trim());
                            this.processCharacters(text);
                            sBuilder = new StringBuilder();
                            continue block9;
                        }
                        case 2: {
                            this.processEndTag();
                            continue block9;
                        }
                    }
                }
                this.mReader.close();
            }
        }
        catch (XMLStreamException e) {
            throw new SirixIOException(e);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private void processStartTag(StartElement paramElem) throws IOException, XMLStreamException, SirixException {
        assert (paramElem != null);
        this.initializeVars();
        this.algorithm(paramElem);
        if (this.mFound && this.mIsRightSibling) {
            this.mDelete = EDelete.ATSTARTMIDDLE;
            this.deleteNode();
        } else if (!this.mFound) {
            ++this.mLevelInToShredder;
            this.insertElementNode(paramElem);
        } else if (this.mFound) {
            ++this.mLevelInToShredder;
            this.sameElementNode();
        }
    }

    private void processCharacters(Characters paramText) throws IOException, XMLStreamException, SirixException {
        assert (paramText != null);
        this.initializeVars();
        String text = paramText.getData().toString();
        if (!text.isEmpty()) {
            this.algorithm(paramText);
            if (this.mFound && this.mIsRightSibling) {
                throw new AssertionError((Object)"");
            }
            if (!this.mFound) {
                this.insertTextNode(paramText);
            } else if (this.mFound) {
                this.sameTextNode();
            }
        }
    }

    private void processEndTag() throws XMLStreamException, SirixException {
        --this.mLevelInToShredder;
        if (this.mInserted) {
            this.mInsertedEndTag = true;
        }
        if (this.mRemovedNode) {
            this.mRemovedNode = false;
        } else {
            if (this.mWtx.getNodeKey() == this.mLastNodeKey) {
                assert (this.mWtx.hasParent() && this.mWtx.getKind() == NodeKind.ELEMENT);
                this.mWtx.moveToParent();
            } else if (this.mWtx.getKind() == NodeKind.ELEMENT) {
                if (this.mWtx.hasFirstChild() && this.mWtx.hasParent()) {
                    this.mWtx.moveToParent();
                }
            } else if (this.mWtx.hasParent()) {
                if (this.mWtx.hasRightSibling()) {
                    this.mWtx.moveToRightSibling();
                    this.mKeyMatches = -1L;
                    this.mDelete = EDelete.ATBOTTOM;
                    this.deleteNode();
                }
                this.mWtx.moveToParent();
            }
            this.mLastNodeKey = this.mWtx.getNodeKey();
            if (this.mWtx.hasRightSibling()) {
                this.mWtx.moveToRightSibling();
                this.mMovedToRightSibling = true;
                this.skipWhitespaces(this.mReader);
                if (this.mReader.peek().getEventType() == 2) {
                    this.mKeyMatches = -1L;
                    this.mDelete = EDelete.ATBOTTOM;
                    this.deleteNode();
                }
            } else {
                this.mMovedToRightSibling = false;
            }
        }
    }

    private void algorithm(XMLEvent paramEvent) throws IOException, XMLStreamException {
        assert (paramEvent != null);
        do {
            if (paramEvent.isStartElement()) {
                this.mFound = this.checkElement(paramEvent.asStartElement());
            } else if (paramEvent.isCharacters()) {
                this.mFound = this.checkText(paramEvent.asCharacters());
            }
            if (this.mWtx.getNodeKey() != this.mNodeKey) {
                this.mIsRightSibling = true;
            }
            this.mKeyMatches = this.mWtx.getNodeKey();
        } while (!this.mFound && this.mWtx.moveToRightSibling());
        this.mWtx.moveTo(this.mNodeKey);
    }

    private boolean checkText(Characters paramEvent) {
        assert (paramEvent != null);
        String text = paramEvent.getData().trim();
        return this.mWtx.getKind() == NodeKind.TEXT && this.mWtx.getValue().equals(text);
    }

    private void sameTextNode() throws SirixIOException, XMLStreamException {
        this.mInternalInsert = EInternalInsert.NOINSERT;
        this.mDelete = EDelete.NODELETE;
        this.mInserted = false;
        this.mInsertedEndTag = false;
        this.mRemovedNode = false;
        this.skipWhitespaces(this.mReader);
        if (this.mReader.peek().getEventType() != 2) {
            this.mMovedToRightSibling = this.mWtx.moveToRightSibling();
        }
        this.mInternalInsert = EInternalInsert.ATMIDDLEBOTTOM;
    }

    private void sameElementNode() throws XMLStreamException, SirixException {
        this.mInternalInsert = EInternalInsert.NOINSERT;
        this.mDelete = EDelete.NODELETE;
        this.mInserted = false;
        this.mInsertedEndTag = false;
        this.mRemovedNode = false;
        this.skipWhitespaces(this.mReader);
        if (this.mWtx.hasFirstChild()) {
            this.mInternalInsert = EInternalInsert.ATTOP;
            this.mWtx.moveToFirstChild();
            if (this.mReader.peek().getEventType() == 2) {
                this.mKeyMatches = -1L;
                this.mDelete = EDelete.ATBOTTOM;
                this.deleteNode();
            }
        } else if (this.mReader.peek().getEventType() != 2) {
            this.mInternalInsert = EInternalInsert.ATTOP;
            this.mEmptyElement = true;
        } else {
            this.mInternalInsert = EInternalInsert.ATMIDDLEBOTTOM;
        }
    }

    private void skipWhitespaces(XMLEventReader paramReader) throws XMLStreamException {
        while (paramReader.peek().getEventType() == 4 && paramReader.peek().asCharacters().isWhiteSpace()) {
            paramReader.nextEvent();
        }
    }

    private void insertElementNode(StartElement paramElement) throws SirixException, XMLStreamException {
        assert (paramElement != null);
        this.mDelete = EDelete.NODELETE;
        this.mRemovedNode = false;
        switch (this.mInternalInsert.ordinal()) {
            case 0: {
                if (!this.mEmptyElement) {
                    this.mWtx.moveToParent();
                }
                this.addNewElement(EAdd.ASFIRSTCHILD, paramElement);
                this.mInternalInsert = EInternalInsert.INTERMEDIATE;
                break;
            }
            case 2: {
                EAdd insertNode = EAdd.ASFIRSTCHILD;
                if (this.mInsertedEndTag) {
                    this.mInsertedEndTag = false;
                    insertNode = EAdd.ASRIGHTSIBLING;
                }
                if (this.mMovedToRightSibling) {
                    this.mWtx.moveToLeftSibling();
                }
                if (this.mWtx.getKind() == NodeKind.TEXT) {
                    insertNode = EAdd.ASRIGHTSIBLING;
                }
                this.addNewElement(insertNode, paramElement);
                break;
            }
            case 1: {
                if (this.mMovedToRightSibling) {
                    this.mMovedToRightSibling = false;
                    this.mWtx.moveToLeftSibling();
                }
                this.addNewElement(EAdd.ASRIGHTSIBLING, paramElement);
                this.mInternalInsert = EInternalInsert.INTERMEDIATE;
                break;
            }
            default: {
                throw new AssertionError((Object)"Enum value not known!");
            }
        }
        this.mInserted = true;
    }

    private void insertTextNode(Characters paramText) throws SirixException, XMLStreamException {
        assert (paramText != null);
        this.mDelete = EDelete.NODELETE;
        this.mRemovedNode = false;
        switch (this.mInternalInsert.ordinal()) {
            case 0: {
                this.mWtx.moveToParent();
                this.addNewText(EAdd.ASFIRSTCHILD, paramText);
                if (this.mReader.peek().getEventType() != 2) {
                    this.mMovedToRightSibling = this.mWtx.moveToRightSibling();
                } else if (this.mWtx.hasRightSibling()) {
                    this.mMovedToRightSibling = false;
                    this.mInserted = true;
                    this.mKeyMatches = -1L;
                    this.mDelete = EDelete.ATBOTTOM;
                    this.deleteNode();
                }
                this.mInternalInsert = EInternalInsert.INTERMEDIATE;
                break;
            }
            case 2: {
                EAdd addNode = EAdd.ASFIRSTCHILD;
                if (this.mInsertedEndTag) {
                    if (this.mMovedToRightSibling) {
                        this.mWtx.moveToLeftSibling();
                    }
                    addNode = EAdd.ASRIGHTSIBLING;
                    this.mInsertedEndTag = false;
                }
                this.addNewText(addNode, paramText);
                if (this.mReader.peek().getEventType() == 2) break;
                if (this.mWtx.moveToRightSibling()) {
                    this.mMovedToRightSibling = true;
                    break;
                }
                this.mMovedToRightSibling = false;
                break;
            }
            case 1: {
                if (this.mMovedToRightSibling) {
                    this.mWtx.moveToLeftSibling();
                }
                this.addNewText(EAdd.ASRIGHTSIBLING, paramText);
                this.mWtx.moveToRightSibling();
                this.mInternalInsert = EInternalInsert.INTERMEDIATE;
                break;
            }
            default: {
                throw new AssertionError((Object)"Enum value not known!");
            }
        }
        this.mInserted = true;
    }

    private void deleteNode() throws SirixException {
        if (this.mInserted && !this.mMovedToRightSibling) {
            this.mInserted = false;
            if (this.mWtx.hasRightSibling()) {
                this.mWtx.moveToRightSibling();
            }
        }
        boolean movedToParent = false;
        boolean isLast = false;
        do {
            if (this.mWtx.getNodeKey() == this.mKeyMatches) continue;
            if (!this.mWtx.hasRightSibling() && !this.mWtx.hasLeftSibling()) {
                if (this.mDelete == EDelete.ATSTARTMIDDLE) {
                    // empty if block
                }
                movedToParent = true;
            } else if (!this.mWtx.hasRightSibling()) {
                isLast = true;
            }
            this.mWtx.remove();
        } while (this.mWtx.getNodeKey() != this.mKeyMatches && !movedToParent && !isLast);
        if (movedToParent) {
            if (this.mDelete == EDelete.ATBOTTOM) {
                this.mRemovedNode = true;
            }
            this.mWtx.moveToRightSibling();
        } else if (this.mWtx.hasFirstChild()) {
            if (this.mDelete == EDelete.ATBOTTOM && isLast) {
                this.mRemovedNode = true;
            }
            if (isLast) {
                this.mWtx.moveToParent();
                this.mWtx.moveToRightSibling();
                if (this.mDelete == EDelete.ATSTARTMIDDLE) {
                    // empty if block
                }
            }
        }
        this.mInternalInsert = EInternalInsert.NOINSERT;
    }

    private void initializeVars() {
        this.mNodeKey = this.mWtx.getNodeKey();
        this.mFound = false;
        this.mIsRightSibling = false;
        this.mKeyMatches = -1L;
    }

    private void addNewText(EAdd paramAdd, Characters paramTextEvent) throws SirixException {
        assert (paramTextEvent != null);
        String text = paramTextEvent.getData().trim();
        ByteBuffer textByteBuffer = ByteBuffer.wrap(TypedValue.getBytes(text));
        if (textByteBuffer.array().length > 0) {
            if (paramAdd == EAdd.ASFIRSTCHILD) {
                this.mWtx.insertTextAsFirstChild(new String(textByteBuffer.array()));
            } else {
                this.mWtx.insertTextAsRightSibling(new String(textByteBuffer.array()));
            }
        }
    }

    private void addNewElement(EAdd paramAdd, StartElement paramStartElement) throws SirixException {
        assert (paramStartElement != null);
        QName name = paramStartElement.getName();
        QNm qName = new QNm(name.getNamespaceURI(), name.getPrefix(), name.getLocalPart());
        long key = this.mInsert == InsertPosition.AS_RIGHT_SIBLING ? this.mWtx.insertElementAsRightSibling(qName).getNodeKey() : (paramAdd == EAdd.ASFIRSTCHILD ? this.mWtx.insertElementAsFirstChild(qName).getNodeKey() : this.mWtx.insertElementAsRightSibling(qName).getNodeKey());
        Iterator<Attribute> it = paramStartElement.getNamespaces();
        while (it.hasNext()) {
            Namespace namespace = it.next();
            this.mWtx.insertNamespace(new QNm(namespace.getNamespaceURI(), namespace.getPrefix(), ""));
            this.mWtx.moveTo(key);
        }
        it = paramStartElement.getAttributes();
        while (it.hasNext()) {
            Attribute attribute = it.next();
            QName attName = attribute.getName();
            this.mWtx.insertAttribute(new QNm(attName.getNamespaceURI(), attName.getPrefix(), attName.getLocalPart()), attribute.getValue());
            this.mWtx.moveTo(key);
        }
    }

    private boolean checkElement(StartElement mEvent) {
        assert (mEvent != null);
        boolean retVal = false;
        QName name = mEvent.getName();
        QNm currName = this.mWtx.getName();
        if (this.mWtx.getKind() == NodeKind.ELEMENT && currName.getNamespaceURI().equals(name.getNamespaceURI()) && currName.getLocalName().equals(name.getLocalPart())) {
            long nodeKey = this.mWtx.getNodeKey();
            boolean foundAtts = false;
            boolean hasAtts = false;
            Iterator<Attribute> it = mEvent.getAttributes();
            while (it.hasNext()) {
                hasAtts = true;
                Attribute attribute = it.next();
                int attCount = this.mWtx.getAttributeCount();
                for (int i = 0; i < attCount; ++i) {
                    this.mWtx.moveToAttribute(i);
                    QName attName = attribute.getName();
                    QNm currAttName = this.mWtx.getName();
                    if (attName.getNamespaceURI().equals(currAttName.getNamespaceURI()) && attName.getLocalPart().equals(currAttName.getLocalName()) && attribute.getValue().equals(this.mWtx.getValue())) {
                        foundAtts = true;
                        this.mWtx.moveTo(nodeKey);
                        break;
                    }
                    this.mWtx.moveTo(nodeKey);
                }
                if (foundAtts) continue;
                break;
            }
            if (!hasAtts && this.mWtx.getAttributeCount() == 0) {
                foundAtts = true;
            }
            boolean foundNamesps = false;
            boolean hasNamesps = false;
            Iterator<Namespace> namespIt = mEvent.getNamespaces();
            while (namespIt.hasNext()) {
                hasNamesps = true;
                Namespace namespace = namespIt.next();
                int namespCount = this.mWtx.getNamespaceCount();
                for (int i = 0; i < namespCount; ++i) {
                    this.mWtx.moveToNamespace(i);
                    if (namespace.getNamespaceURI().equals(this.mWtx.nameForKey(this.mWtx.getURIKey()))) {
                        String prefix = namespace.getPrefix();
                        if (prefix.isEmpty()) {
                            foundNamesps = true;
                            this.mWtx.moveTo(nodeKey);
                            break;
                        }
                        if (prefix.equals(this.mWtx.nameForKey(this.mWtx.getPrefixKey()))) {
                            foundNamesps = true;
                            this.mWtx.moveTo(nodeKey);
                            break;
                        }
                    }
                    this.mWtx.moveTo(nodeKey);
                }
                if (foundNamesps) continue;
                break;
            }
            if (!hasNamesps && this.mWtx.getNamespaceCount() == 0) {
                foundNamesps = true;
            }
            retVal = foundAtts && foundNamesps;
        }
        return retVal;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: XMLShredder input.xml output.tnk");
        }
        LOGWRAPPER.info("Shredding '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.currentTimeMillis();
        Path target = Paths.get(args[1], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(target);
        Databases.createXmlDatabase(config);
        Database<XmlResourceSession> db = Databases.openXmlDatabase(target);
        db.createResource(new ResourceConfiguration.Builder("shredded").build());
        try (XmlResourceSession resMgr = db.beginResourceSession("shredded");
             XmlNodeTrx wtx = (XmlNodeTrx)resMgr.beginNodeTrx();
             FileInputStream fis = new FileInputStream(Paths.get(args[0], new String[0]).toFile());){
            XMLEventReader reader = XmlShredder.createFileReader(fis);
            XMLUpdateShredder shredder = new XMLUpdateShredder(wtx, reader, InsertPosition.AS_FIRST_CHILD, new File(args[0]), ShredderCommit.COMMIT);
            shredder.call();
        }
        catch (SirixException | IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        LOGWRAPPER.info(" done [" + (System.currentTimeMillis() - time) + "ms].", new Object[0]);
    }

    private static enum EDelete {
        ATSTARTMIDDLE,
        ATBOTTOM,
        NODELETE;

    }

    private static enum EInternalInsert {
        ATTOP,
        ATMIDDLEBOTTOM,
        INTERMEDIATE,
        NOINSERT;

    }

    private static enum EAdd {
        ASFIRSTCHILD,
        ASRIGHTSIBLING;

    }
}

