/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.shredder;

import io.brackit.query.atomic.QNm;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.Database;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixIOException;
import io.sirix.service.InsertPosition;
import io.sirix.service.ShredderCommit;
import io.sirix.service.xml.shredder.AbstractShredder;
import io.sirix.service.xml.shredder.QueueEventReader;
import io.sirix.settings.Constants;
import io.sirix.utils.LogWrapper;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.LoggerFactory;

public final class XmlShredder
extends AbstractShredder
implements Callable<Long> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(XmlShredder.class));
    private final XmlNodeTrx wtx;
    private final XMLEventReader reader;
    private final ShredderCommit commit;
    private final InsertPosition insert;
    private final boolean includeComments;
    private final boolean includePIs;

    private XmlShredder(Builder builder) {
        super(builder.wtx, builder.insert);
        this.wtx = builder.wtx;
        this.reader = builder.reader;
        this.insert = builder.insert;
        this.includeComments = builder.includeComments;
        this.includePIs = builder.includePIs;
        this.commit = builder.commit;
    }

    @Override
    public Long call() {
        long revision = this.wtx.getRevisionNumber();
        this.insertNewContent();
        this.commit.commit(this.wtx);
        return revision;
    }

    private void insertNewContent() {
        try {
            boolean firstElement = true;
            int level = 0;
            QName rootElement = null;
            boolean endElemReached = false;
            StringBuilder sBuilder = new StringBuilder();
            long insertedRootNodeKey = -1L;
            while (this.reader.hasNext() && !endElemReached) {
                XMLEvent event = this.reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        ++level;
                        this.addNewElement(event.asStartElement());
                        if (!firstElement) break;
                        firstElement = false;
                        insertedRootNodeKey = this.wtx.getNodeKey();
                        rootElement = event.asStartElement().getName();
                        break;
                    }
                    case 2: {
                        if (--level == 0 && rootElement != null && rootElement.equals(event.asEndElement().getName())) {
                            endElemReached = true;
                        }
                        QName name = event.asEndElement().getName();
                        this.processEndTag(new QNm(name.getNamespaceURI(), name.getPrefix(), name.getLocalPart()));
                        break;
                    }
                    case 4: {
                        if (this.reader.peek().getEventType() == 4) {
                            sBuilder.append(event.asCharacters().getData().trim());
                            break;
                        }
                        sBuilder.append(event.asCharacters().getData().trim());
                        this.processText(sBuilder.toString());
                        sBuilder.setLength(0);
                        break;
                    }
                    case 5: {
                        if (!this.includeComments) break;
                        this.processComment(((Comment)event).getText());
                        break;
                    }
                    case 3: {
                        if (!this.includePIs) break;
                        ProcessingInstruction pi = (ProcessingInstruction)event;
                        this.processPI(pi.getData(), pi.getTarget());
                        break;
                    }
                }
            }
            this.wtx.moveTo(insertedRootNodeKey);
        }
        catch (XMLStreamException e) {
            throw new SirixIOException(e);
        }
    }

    private void addNewElement(StartElement event) throws SirixException {
        assert (event != null);
        QName qName = event.getName();
        QNm name = new QNm(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart());
        this.processStartTag(name);
        Iterator<Attribute> it = event.getNamespaces();
        while (it.hasNext()) {
            Namespace namespace = it.next();
            this.wtx.insertNamespace(new QNm(namespace.getNamespaceURI(), namespace.getPrefix(), ""));
            this.wtx.moveToParent();
        }
        it = event.getAttributes();
        while (it.hasNext()) {
            Attribute attribute = it.next();
            QName attName = attribute.getName();
            this.wtx.insertAttribute(new QNm(attName.getNamespaceURI(), attName.getPrefix(), attName.getLocalPart()), attribute.getValue());
            this.wtx.moveToParent();
        }
    }

    public static void main(String ... args) throws SirixException, IOException, XMLStreamException {
        if (args.length != 2 && args.length != 3) {
            throw new IllegalArgumentException("Usage: XMLShredder XMLFile Database [true/false] (shredder comment|PI)");
        }
        LOGWRAPPER.info("Shredding '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path target = Paths.get(args[1], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(target);
        Databases.removeDatabase(target);
        Databases.createXmlDatabase(config);
        try (Database<XmlResourceSession> db = Databases.openXmlDatabase(target);){
            db.createResource(new ResourceConfiguration.Builder("shredded").build());
            try (XmlResourceSession resMgr = db.beginResourceSession("shredded");
                 XmlNodeTrx wtx = (XmlNodeTrx)resMgr.beginNodeTrx();
                 FileInputStream fis = new FileInputStream(Paths.get(args[0], new String[0]).toFile());){
                XMLEventReader reader = XmlShredder.createFileReader(fis);
                boolean includeCoPI = args.length == 3 && Boolean.parseBoolean(args[2]);
                XmlShredder shredder = new Builder(wtx, reader, InsertPosition.AS_FIRST_CHILD).commitAfterwards().includeComments(includeCoPI).includePIs(includeCoPI).build();
                shredder.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + " ms].", new Object[0]);
    }

    public static XMLEventReader createFileReader(FileInputStream fis) {
        Objects.requireNonNull(fis);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XmlShredder.setProperties(factory);
        try {
            return factory.createXMLEventReader(fis);
        }
        catch (XMLStreamException e) {
            throw new SirixException(e.getMessage(), e);
        }
    }

    private static void setProperties(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
    }

    public static XMLEventReader createStringReader(String xmlString) {
        Objects.requireNonNull(xmlString);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XmlShredder.setProperties(factory);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes(Constants.DEFAULT_ENCODING));
            return factory.createXMLEventReader(in);
        }
        catch (XMLStreamException e) {
            throw new SirixException(e.getMessage(), e);
        }
    }

    public static XMLEventReader createQueueReader(Queue<XMLEvent> events) throws IOException, XMLStreamException {
        return new QueueEventReader(Objects.requireNonNull(events));
    }

    public static class Builder {
        private final XmlNodeTrx wtx;
        private final XMLEventReader reader;
        private final InsertPosition insert;
        private boolean includeComments = true;
        private boolean includePIs = true;
        private ShredderCommit commit = ShredderCommit.NOCOMMIT;

        public Builder(XmlNodeTrx wtx, XMLEventReader reader, InsertPosition insert) {
            this.wtx = Objects.requireNonNull(wtx);
            this.reader = Objects.requireNonNull(reader);
            this.insert = Objects.requireNonNull(insert);
        }

        public Builder includeComments(boolean include) {
            this.includeComments = include;
            return this;
        }

        public Builder includePIs(boolean include) {
            this.includePIs = include;
            return this;
        }

        public Builder commitAfterwards() {
            this.commit = ShredderCommit.COMMIT;
            return this;
        }

        public XmlShredder build() {
            return new XmlShredder(this);
        }
    }
}

