/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath;

import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.IncludeSelf;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractAxis
implements Axis {
    private final NodeCursor rtx;
    protected long key;
    private boolean next;
    private long startKey;
    private final IncludeSelf includeSelf;
    private boolean hasNext;

    public AbstractAxis(NodeCursor rtx) {
        this.rtx = Objects.requireNonNull(rtx);
        this.includeSelf = IncludeSelf.NO;
        this.hasNext = true;
        this.reset(rtx.getNodeKey());
    }

    public AbstractAxis(NodeCursor pRtx, IncludeSelf pIncludeSelf) {
        this.rtx = Objects.requireNonNull(pRtx);
        this.includeSelf = Objects.requireNonNull(pIncludeSelf);
        this.hasNext = true;
        this.reset(pRtx.getNodeKey());
    }

    public final LongIterator iterator() {
        return this;
    }

    protected long done() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public boolean hasNext() {
        if (!this.isHasNext()) {
            return false;
        }
        if (this.isNext()) {
            return true;
        }
        this.resetToLastKey();
        this.key = this.nextKey();
        if (this.key == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            this.resetToStartKey();
            return false;
        }
        return true;
    }

    protected long nextKey() {
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long nextLong() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more nodes in the axis!");
        }
        if (!this.next && !this.hasNext()) {
            throw new NoSuchElementException("No more nodes in the axis!");
        }
        if (this.key >= 0L) {
            if (!this.rtx.hasNode(this.key)) throw new IllegalStateException("Failed to move to nodeKey: " + this.key);
            this.rtx.moveTo(this.key);
        } else {
            this.rtx.moveTo(this.key);
        }
        this.next = false;
        return this.key;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset(@NonNegative long pNodeKey) {
        this.startKey = pNodeKey;
        this.key = pNodeKey;
        this.next = false;
        this.hasNext = true;
    }

    @Override
    public XmlNodeReadOnlyTrx asXmlNodeReadTrx() {
        NodeCursor nodeCursor = this.rtx;
        if (nodeCursor instanceof XmlNodeReadOnlyTrx) {
            XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)nodeCursor;
            return rtx;
        }
        throw new ClassCastException("Node cursor is no XML node transaction.");
    }

    @Override
    public JsonNodeReadOnlyTrx asJsonNodeReadTrx() {
        NodeCursor nodeCursor = this.rtx;
        if (nodeCursor instanceof JsonNodeReadOnlyTrx) {
            JsonNodeReadOnlyTrx rtx = (JsonNodeReadOnlyTrx)nodeCursor;
            return rtx;
        }
        throw new ClassCastException("Node cursor is no JSON node transaction.");
    }

    public NodeReadOnlyTrx getTrx() {
        if (this.rtx instanceof NodeReadOnlyTrx) {
            return (XmlNodeReadOnlyTrx)this.rtx;
        }
        throw new IllegalStateException("Node cursor is no transaction cursor.");
    }

    @Override
    public PathSummaryReader asPathSummary() {
        if (this.rtx instanceof PathSummaryReader) {
            return (PathSummaryReader)this.rtx;
        }
        throw new ClassCastException("Node cursor is no path summary reader.");
    }

    @Override
    public NodeCursor getCursor() {
        return this.rtx;
    }

    public boolean isHasNext() {
        return this.hasNext;
    }

    protected final long resetToStartKey() {
        this.rtx.moveTo(this.startKey);
        this.next = false;
        this.hasNext = false;
        return this.startKey;
    }

    protected final long resetToLastKey() {
        this.rtx.moveTo(this.key);
        this.next = true;
        return this.key;
    }

    @Override
    public final long getStartKey() {
        return this.startKey;
    }

    @Override
    public final IncludeSelf includeSelf() {
        return this.includeSelf;
    }

    @Override
    public long peek() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public final boolean isNext() {
        return this.next;
    }

    @Override
    public final void foreach(XmlNodeVisitor pVisitor) {
        Objects.requireNonNull(pVisitor);
        while (this.hasNext()) {
            ((XmlNodeReadOnlyTrx)this.rtx).acceptVisitor(pVisitor);
            this.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized long nextNode() {
        NodeCursor nodeCursor = this.rtx;
        synchronized (nodeCursor) {
            long retVal = Fixed.NULL_NODE_KEY.getStandardProperty();
            if (this.hasNext()) {
                retVal = this.nextLong();
            }
            return retVal;
        }
    }
}

