/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath;

import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.service.xml.xpath.types.Type;
import io.sirix.settings.Constants;
import io.sirix.settings.Fixed;
import io.sirix.utils.NamePageHash;
import io.sirix.utils.TypedValue;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AtomicValue
implements Node,
ValueNode,
ImmutableXmlNode {
    private byte[] value;
    private final int type;
    private long itemKey;

    public AtomicValue(byte[] value, int type) {
        this.value = Objects.requireNonNull(value);
        this.type = type;
    }

    public AtomicValue(boolean pValue) {
        this.value = TypedValue.getBytes(Boolean.toString(pValue));
        this.type = NamePageHash.generateHashForString("xs:boolean");
    }

    public AtomicValue(Number pValue, Type pType) {
        this.value = TypedValue.getBytes(pValue.toString());
        this.type = NamePageHash.generateHashForString(pType.getStringRepr());
    }

    public AtomicValue(String pValue, @NonNull Type pType) {
        this.value = TypedValue.getBytes(pValue);
        this.type = NamePageHash.generateHashForString(pType.getStringRepr());
    }

    public void setNodeKey(long pItemKey) {
        this.itemKey = pItemKey;
    }

    @Override
    public long getParentKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public long getNodeKey() {
        return this.itemKey;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ATOMIC;
    }

    public boolean isFullText() {
        return false;
    }

    public boolean isFullTextLeaf() {
        return false;
    }

    public boolean isFullTextRoot() {
        return false;
    }

    @Override
    public int getTypeKey() {
        return this.type;
    }

    public String getType() {
        return Type.getType(this.type).getStringRepr();
    }

    public int getInt() {
        return (int)this.getDBL();
    }

    public boolean getBool() {
        return Boolean.parseBoolean(new String(this.value));
    }

    public float getFLT() {
        return Float.parseFloat(new String(this.value));
    }

    public double getDBL() {
        return Double.parseDouble(new String(this.value));
    }

    public String toString() {
        return "Atomic Value: " + new String(this.value, Constants.DEFAULT_ENCODING) + "\nKey: " + this.itemKey;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHash(long hash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    public AtomicValue clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParentKey(long pKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreviousRevision(int revision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastModifiedRevision(int revision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeKey(int pType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getRawValue() {
        return this.value;
    }

    @Override
    public void setRawValue(byte[] pVal) {
        this.value = Objects.requireNonNull(pVal);
    }

    @Override
    public boolean isSameItem(@Nullable Node pOther) {
        return false;
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLastModifiedRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDeweyID(SirixDeweyID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue() {
        return new String(this.value, Constants.DEFAULT_ENCODING);
    }

    @Override
    public SirixDeweyID getDeweyID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        throw new UnsupportedOperationException();
    }
}

