/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath;

import io.sirix.api.Axis;
import io.sirix.api.Filter;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.ForAxis;
import io.sirix.axis.filter.FilterAxis;
import io.sirix.axis.filter.PredicateFilterAxis;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.AbstractAxis;
import io.sirix.service.xml.xpath.EXPathError;
import io.sirix.service.xml.xpath.ExpressionSingle;
import io.sirix.service.xml.xpath.SequenceType;
import io.sirix.service.xml.xpath.SingleType;
import io.sirix.service.xml.xpath.comparators.AbstractComparator;
import io.sirix.service.xml.xpath.comparators.CompKind;
import io.sirix.service.xml.xpath.expr.AbstractExpression;
import io.sirix.service.xml.xpath.expr.AndExpr;
import io.sirix.service.xml.xpath.expr.CastExpr;
import io.sirix.service.xml.xpath.expr.CastableExpr;
import io.sirix.service.xml.xpath.expr.EveryExpr;
import io.sirix.service.xml.xpath.expr.ExceptAxis;
import io.sirix.service.xml.xpath.expr.IfAxis;
import io.sirix.service.xml.xpath.expr.InstanceOfExpr;
import io.sirix.service.xml.xpath.expr.IntersectAxis;
import io.sirix.service.xml.xpath.expr.LiteralExpr;
import io.sirix.service.xml.xpath.expr.OrExpr;
import io.sirix.service.xml.xpath.expr.RangeAxis;
import io.sirix.service.xml.xpath.expr.SequenceAxis;
import io.sirix.service.xml.xpath.expr.SomeExpr;
import io.sirix.service.xml.xpath.expr.UnionAxis;
import io.sirix.service.xml.xpath.expr.VarRefExpr;
import io.sirix.service.xml.xpath.expr.VariableAxis;
import io.sirix.service.xml.xpath.filter.DupFilterAxis;
import io.sirix.service.xml.xpath.functions.AbstractFunction;
import io.sirix.service.xml.xpath.functions.FuncDef;
import io.sirix.service.xml.xpath.operators.AbstractObAxis;
import io.sirix.service.xml.xpath.operators.AddOpAxis;
import io.sirix.service.xml.xpath.operators.DivOpAxis;
import io.sirix.service.xml.xpath.operators.IDivOpAxis;
import io.sirix.service.xml.xpath.operators.ModOpAxis;
import io.sirix.service.xml.xpath.operators.MulOpAxis;
import io.sirix.service.xml.xpath.operators.SubOpAxis;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class PipelineBuilder {
    private final Stack<Stack<ExpressionSingle>> mExprStack = new Stack();
    private final Map<String, Axis> mVarRefMap = new HashMap<String, Axis>();

    public Stack<ExpressionSingle> getPipeStack() {
        if (this.mExprStack.size() == 0) {
            throw new IllegalStateException("No pipe on the stack");
        }
        return this.mExprStack.peek();
    }

    public void addExpr() {
        this.mExprStack.push(new Stack());
    }

    public void finishExpr(XmlNodeReadOnlyTrx mTransaction, int mNum) {
        if (this.getPipeStack().size() != mNum) {
            throw new IllegalStateException("The query has not been processed correctly");
        }
        int no = mNum;
        if (no > 1) {
            Axis[] axis = new Axis[no];
            while (no-- > 0) {
                axis[no] = this.getPipeStack().pop().getExpr();
            }
            if (this.mExprStack.size() > 1) {
                assert (this.mExprStack.peek().empty());
                this.mExprStack.pop();
            }
            if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
                this.addExpressionSingle();
            }
            this.getExpression().add(new SequenceAxis(mTransaction, axis));
        } else if (no == 1) {
            Axis[] axis = new Axis[]{this.getPipeStack().pop().getExpr()};
            if (this.mExprStack.size() > 1) {
                assert (this.mExprStack.peek().empty());
                this.mExprStack.pop();
            }
            if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
                this.addExpressionSingle();
            }
            Axis iAxis = this.mExprStack.size() == 1 && this.getPipeStack().size() == 1 && this.getExpression().getSize() == 0 ? new SequenceAxis(mTransaction, axis) : axis[0];
            this.getExpression().add(iAxis);
        } else {
            this.mExprStack.pop();
        }
    }

    public void addExpressionSingle() {
        this.getPipeStack().push(new ExpressionSingle());
    }

    public ExpressionSingle getExpression() {
        return this.getPipeStack().peek();
    }

    public void addForExpression(int mForConditionNum) {
        assert (this.getPipeStack().size() >= mForConditionNum + 1);
        Axis forAxis = this.getPipeStack().pop().getExpr();
        int num = mForConditionNum;
        while (num-- > 0) {
            forAxis = new ForAxis(this.getPipeStack().pop().getExpr(), forAxis);
        }
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(forAxis);
    }

    public void addIfExpression(XmlNodeReadOnlyTrx mTransaction) {
        assert (this.getPipeStack().size() >= 3);
        XmlNodeReadOnlyTrx rtx = mTransaction;
        Axis elseExpr = this.getPipeStack().pop().getExpr();
        Axis thenExpr = this.getPipeStack().pop().getExpr();
        Axis ifExpr = this.getPipeStack().pop().getExpr();
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(new IfAxis(rtx, ifExpr, thenExpr, elseExpr));
    }

    public void addCompExpression(XmlNodeReadOnlyTrx mTransaction, String mComp) {
        assert (this.getPipeStack().size() >= 2);
        XmlNodeReadOnlyTrx rtx = mTransaction;
        Axis paramOperandTwo = this.getPipeStack().pop().getExpr();
        Axis paramOperandOne = this.getPipeStack().pop().getExpr();
        CompKind kind = CompKind.fromString(mComp);
        AbstractComparator axis = AbstractComparator.getComparator(rtx, paramOperandOne, paramOperandTwo, kind, mComp);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addOperatorExpression(XmlNodeReadOnlyTrx mTransaction, String mOperator) {
        AbstractObAxis axis;
        assert (this.getPipeStack().size() >= 1);
        XmlNodeReadOnlyTrx rtx = mTransaction;
        Axis mOperand2 = this.getPipeStack().pop().getExpr();
        Axis mOperand1 = this.getPipeStack().pop().getExpr();
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        if (mOperator.equals("+")) {
            axis = new AddOpAxis(rtx, mOperand1, mOperand2);
        } else if (mOperator.equals("-")) {
            axis = new SubOpAxis(rtx, mOperand1, mOperand2);
        } else if (mOperator.equals("*")) {
            axis = new MulOpAxis(rtx, mOperand1, mOperand2);
        } else if (mOperator.equals("div")) {
            axis = new DivOpAxis(rtx, mOperand1, mOperand2);
        } else if (mOperator.equals("idiv")) {
            axis = new IDivOpAxis(rtx, mOperand1, mOperand2);
        } else if (mOperator.equals("mod")) {
            axis = new ModOpAxis(rtx, mOperand1, mOperand2);
        } else {
            throw new IllegalStateException(mOperator + " is not a valid operator.");
        }
        this.getExpression().add(axis);
    }

    public void addUnionExpression(XmlNodeReadOnlyTrx mTransaction) {
        assert (this.getPipeStack().size() >= 2);
        Axis mOperand2 = this.getPipeStack().pop().getExpr();
        Axis mOperand1 = this.getPipeStack().pop().getExpr();
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(new DupFilterAxis(mTransaction, new UnionAxis(mTransaction, mOperand1, mOperand2)));
    }

    public void addAndExpression(XmlNodeReadOnlyTrx mTransaction) {
        assert (this.getPipeStack().size() >= 2);
        Axis mOperand2 = this.getPipeStack().pop().getExpr();
        Axis operand1 = this.getPipeStack().pop().getExpr();
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(new AndExpr(mTransaction, operand1, mOperand2));
    }

    public void addOrExpression(XmlNodeReadOnlyTrx mTransaction) {
        assert (this.getPipeStack().size() >= 2);
        Axis mOperand2 = this.getPipeStack().pop().getExpr();
        Axis mOperand1 = this.getPipeStack().pop().getExpr();
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(new OrExpr(mTransaction, mOperand1, mOperand2));
    }

    public void addIntExcExpression(XmlNodeReadOnlyTrx mTransaction, boolean mIsIntersect) {
        AbstractAxis axis;
        assert (this.getPipeStack().size() >= 2);
        XmlNodeReadOnlyTrx rtx = mTransaction;
        Axis mOperand2 = this.getPipeStack().pop().getExpr();
        Axis mOperand1 = this.getPipeStack().pop().getExpr();
        AbstractAxis abstractAxis = axis = mIsIntersect ? new IntersectAxis(rtx, mOperand1, mOperand2) : new ExceptAxis(rtx, mOperand1, mOperand2);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addLiteral(XmlNodeReadOnlyTrx mTransaction, int mItemKey) {
        this.getExpression().add(new LiteralExpr(mTransaction, mItemKey));
    }

    public void addStep(Axis axis) {
        this.getExpression().add(axis);
    }

    public void addStep(Axis axis, Filter mFilter) {
        this.getExpression().add(new FilterAxis(axis, mFilter, new Filter[0]));
    }

    public Axis getPipeline() {
        assert (this.getPipeStack().size() <= 1);
        if (this.getPipeStack().size() == 1 && this.mExprStack.size() == 1) {
            return this.getPipeStack().pop().getExpr();
        }
        throw new IllegalStateException("Query was not build correctly.");
    }

    public void addPredicate(XmlNodeReadOnlyTrx pRtx) {
        assert (this.getPipeStack().size() >= 2);
        Axis predicate = this.getPipeStack().pop().getExpr();
        if (predicate instanceof LiteralExpr) {
            predicate.hasNext();
            int type = pRtx.getTypeKey();
            if (type == pRtx.keyForName("xs:integer") || type == pRtx.keyForName("xs:double") || type == pRtx.keyForName("xs:float") || type == pRtx.keyForName("xs:decimal")) {
                throw new IllegalStateException("function fn:position() is not implemented yet.");
            }
        }
        this.getExpression().add(new PredicateFilterAxis((NodeCursor)pRtx, predicate));
    }

    public void addQuantifierExpr(XmlNodeReadOnlyTrx mTransaction, boolean mIsSome, int mVarNum) {
        AbstractExpression mAxis;
        assert (this.getPipeStack().size() >= mVarNum + 1);
        Axis satisfy = this.getPipeStack().pop().getExpr();
        ArrayList<Axis> vars = new ArrayList<Axis>();
        int num = mVarNum;
        while (num-- > 0) {
            vars.add(num, this.getPipeStack().pop().getExpr());
        }
        AbstractExpression abstractExpression = mAxis = mIsSome ? new SomeExpr(mTransaction, vars, satisfy) : new EveryExpr(mTransaction, vars, satisfy);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(mAxis);
    }

    public void addCastableExpr(XmlNodeReadOnlyTrx mTransaction, SingleType mSingleType) {
        assert (this.getPipeStack().size() >= 1);
        Axis candidate = this.getPipeStack().pop().getExpr();
        CastableExpr axis = new CastableExpr(mTransaction, candidate, mSingleType);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addRangeExpr(XmlNodeReadOnlyTrx mTransaction) {
        assert (this.getPipeStack().size() >= 2);
        Axis mOperand2 = this.getPipeStack().pop().getExpr();
        Axis mOperand1 = this.getPipeStack().pop().getExpr();
        RangeAxis axis = new RangeAxis(mTransaction, mOperand1, mOperand2);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addCastExpr(XmlNodeReadOnlyTrx mTransaction, SingleType mSingleType) {
        assert (this.getPipeStack().size() >= 1);
        Axis candidate = this.getPipeStack().pop().getExpr();
        CastExpr axis = new CastExpr(mTransaction, candidate, mSingleType);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addInstanceOfExpr(XmlNodeReadOnlyTrx mTransaction, SequenceType mSequenceType) {
        assert (this.getPipeStack().size() >= 1);
        Axis candidate = this.getPipeStack().pop().getExpr();
        InstanceOfExpr axis = new InstanceOfExpr(mTransaction, candidate, mSequenceType);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addTreatExpr(NodeReadOnlyTrx mTransaction, SequenceType mSequenceType) {
        throw new IllegalStateException("the Treat expression is not supported yet");
    }

    public void addVariableExpr(XmlNodeReadOnlyTrx mTransaction, String mVarName) {
        assert (this.getPipeStack().size() >= 1);
        Axis bindingSeq = this.getPipeStack().pop().getExpr();
        VariableAxis axis = new VariableAxis(mTransaction, bindingSeq);
        this.mVarRefMap.put(mVarName, axis);
        if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
            this.addExpressionSingle();
        }
        this.getExpression().add(axis);
    }

    public void addFunction(XmlNodeReadOnlyTrx mTransaction, String mFuncName, int mNum) throws SirixXPathException {
        FuncDef func;
        assert (this.getPipeStack().size() >= mNum);
        ArrayList<Axis> args = new ArrayList<Axis>(mNum);
        for (int i = 0; i < mNum; ++i) {
            args.add(this.getPipeStack().pop().getExpr());
        }
        try {
            func = FuncDef.fromString(mFuncName);
        }
        catch (NullPointerException e) {
            throw EXPathError.XPST0017.getEncapsulatedException();
        }
        Class<? extends AbstractFunction> function = func.getFunc();
        Integer min = func.getMin();
        Integer max = func.getMax();
        Integer returnType = mTransaction.keyForName(func.getReturnType());
        Class[] paramTypes = new Class[]{XmlNodeReadOnlyTrx.class, List.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        try {
            Constructor<? extends AbstractFunction> cons = function.getConstructor(paramTypes);
            Axis axis = cons.newInstance(mTransaction, args, min, max, returnType);
            if (this.getPipeStack().empty() || this.getExpression().getSize() != 0) {
                this.addExpressionSingle();
            }
            this.getExpression().add(axis);
        }
        catch (NoSuchMethodException e) {
            throw EXPathError.XPST0017.getEncapsulatedException();
        }
        catch (IllegalArgumentException e) {
            throw EXPathError.XPST0017.getEncapsulatedException();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Function not implemented yet.");
        }
        catch (IllegalAccessException e) {
            throw EXPathError.XPST0017.getEncapsulatedException();
        }
        catch (InvocationTargetException e) {
            throw EXPathError.XPST0017.getEncapsulatedException();
        }
    }

    public void addVarRefExpr(XmlNodeReadOnlyTrx mTransaction, String mVarName) {
        VariableAxis axis = (VariableAxis)this.mVarRefMap.get(mVarName);
        if (axis == null) {
            throw new IllegalStateException("Variable " + mVarName + " unkown.");
        }
        this.getExpression().add(new VarRefExpr(mTransaction, axis));
    }

    public String toString() {
        return "Expression Stack: " + this.mExprStack + "\nHashMap: " + this.mVarRefMap;
    }
}

