/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.comparators;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.EXPathError;
import io.sirix.service.xml.xpath.comparators.AbstractComparator;
import io.sirix.service.xml.xpath.comparators.CompKind;
import io.sirix.service.xml.xpath.types.Type;

public class ValueComp
extends AbstractComparator {
    public ValueComp(XmlNodeReadOnlyTrx rtx, Axis mOperand1, Axis mOperand2, CompKind mComp) {
        super(rtx, mOperand1, mOperand2, mComp);
    }

    @Override
    protected boolean compare(AtomicValue[] mOperand1, AtomicValue[] mOperand2) throws SirixXPathException {
        Type type = this.getType(mOperand1[0].getTypeKey(), mOperand2[0].getTypeKey());
        String op1 = new String(mOperand1[0].getRawValue());
        String op2 = new String(mOperand2[0].getRawValue());
        return this.getCompKind().compare(op1, op2, type);
    }

    @Override
    protected AtomicValue[] atomize(Axis mOperand) throws SirixXPathException {
        XmlNodeReadOnlyTrx trx = this.asXmlNodeReadTrx();
        int type = trx.getTypeKey();
        if (type == trx.keyForName("xs:unytpedAtomic")) {
            type = trx.keyForName("xs:string");
        }
        AtomicValue atomized = new AtomicValue(mOperand.asXmlNodeReadTrx().getValue().getBytes(), type);
        AtomicValue[] op = new AtomicValue[]{atomized};
        if (mOperand.hasNext()) {
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
        return op;
    }

    @Override
    protected Type getType(int mKey1, int mKey2) throws SirixXPathException {
        Type type1 = Type.getType(mKey1).getPrimitiveBaseType();
        Type type2 = Type.getType(mKey2).getPrimitiveBaseType();
        return Type.getLeastCommonType(type1, type2);
    }
}

