/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.expr;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.SingleType;
import io.sirix.service.xml.xpath.XPathError;
import io.sirix.service.xml.xpath.expr.AbstractExpression;
import io.sirix.service.xml.xpath.types.Type;
import io.sirix.utils.TypedValue;

public class CastableExpr
extends AbstractExpression {
    private final Axis mSourceExpr;
    private final Type mTargetType;
    private final boolean mPermitEmptySeq;

    public CastableExpr(XmlNodeReadOnlyTrx rtx, Axis inputExpr, SingleType mTarget) {
        super(rtx);
        this.mSourceExpr = inputExpr;
        this.mTargetType = mTarget.getAtomic();
        this.mPermitEmptySeq = mTarget.hasInterogation();
    }

    @Override
    public void reset(long mNodeKey) {
        super.reset(mNodeKey);
        if (this.mSourceExpr != null) {
            this.mSourceExpr.reset(mNodeKey);
        }
    }

    @Override
    public void evaluate() throws SirixXPathException {
        boolean isCastable;
        if (this.mTargetType == Type.ANY_ATOMIC_TYPE || this.mTargetType == Type.NOTATION) {
            throw new XPathError(XPathError.ErrorType.XPST0080);
        }
        if (this.mSourceExpr.hasNext()) {
            this.key = this.mSourceExpr.next();
            Type sourceType = Type.getType(this.asXmlNodeReadTrx().getTypeKey());
            String sourceValue = this.asXmlNodeReadTrx().getValue();
            isCastable = sourceType.isCastableTo(this.mTargetType, sourceValue);
            if (this.mSourceExpr.hasNext()) {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
        } else {
            isCastable = this.mPermitEmptySeq;
        }
        int mItemKey = this.asXmlNodeReadTrx().getItemList().addItem(new AtomicValue(TypedValue.getBytes(Boolean.toString(isCastable)), this.asXmlNodeReadTrx().keyForName("xs:boolean")));
        this.key = mItemKey;
    }
}

