/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.expr;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.AbstractAxis;
import io.sirix.service.xml.xpath.functions.Function;

public class IfAxis
extends AbstractAxis {
    private final Axis mIf;
    private final Axis mThen;
    private final Axis mElse;
    private boolean mFirst;
    private Axis mResult;

    public IfAxis(XmlNodeReadOnlyTrx rtx, Axis mIfAxis, Axis mThenAxis, Axis mElseAxis) {
        super(rtx);
        this.mIf = mIfAxis;
        this.mThen = mThenAxis;
        this.mElse = mElseAxis;
        this.mFirst = true;
    }

    @Override
    public void reset(long mNodeKey) {
        super.reset(mNodeKey);
        this.mFirst = true;
        if (this.mIf != null) {
            this.mIf.reset(mNodeKey);
        }
        if (this.mThen != null) {
            this.mThen.reset(mNodeKey);
        }
        if (this.mElse != null) {
            this.mElse.reset(mNodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        this.resetToLastKey();
        if (this.mFirst) {
            this.mFirst = false;
            try {
                this.mResult = Function.ebv(this.mIf) ? this.mThen : this.mElse;
            }
            catch (SirixXPathException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.mResult.hasNext()) {
            this.key = this.mResult.next();
            return true;
        }
        this.resetToStartKey();
        return false;
    }
}

