/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.expr;

import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.service.xml.xpath.AbstractAxis;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnionAxis
extends AbstractAxis {
    private final Axis op1;
    private final Axis op2;

    public UnionAxis(NodeCursor cursor, @NonNull Axis operand1, @NonNull Axis operand2) {
        super(cursor);
        this.op1 = Objects.requireNonNull(operand1);
        this.op2 = Objects.requireNonNull(operand2);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.op1 != null) {
            this.op1.reset(nodeKey);
        }
        if (this.op2 != null) {
            this.op2.reset(nodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        this.resetToLastKey();
        if (this.op1.hasNext()) {
            this.key = this.op1.next();
            return true;
        }
        if (this.op2.hasNext()) {
            this.key = this.op2.next();
            return true;
        }
        return false;
    }
}

