/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.functions;

import io.sirix.api.Axis;
import io.sirix.api.Filter;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.filter.FilterAxis;
import io.sirix.axis.filter.xml.TextFilter;
import io.sirix.exception.SirixXPathException;
import io.sirix.node.NodeKind;
import io.sirix.service.xml.xpath.functions.AbstractFunction;
import io.sirix.utils.TypedValue;
import java.util.List;

public class FNString
extends AbstractFunction {
    public FNString(XmlNodeReadOnlyTrx rtx, List<Axis> args, int min, int max, int returnType) throws SirixXPathException {
        super(rtx, args, min, max, returnType);
    }

    @Override
    protected byte[] computeResult() {
        String value;
        if (this.getArgs().size() == 0) {
            value = this.getStrValue();
        } else {
            Axis axis = this.getArgs().get(0);
            StringBuilder val = new StringBuilder();
            while (axis.hasNext()) {
                axis.next();
                String nodeValue = this.getStrValue();
                if (nodeValue.equals("")) continue;
                if (val.length() > 0) {
                    val.append(" ");
                }
                val.append(nodeValue);
            }
            value = val.toString();
        }
        return TypedValue.getBytes(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getStrValue() {
        StringBuilder value = new StringBuilder();
        if (this.asXmlNodeReadTrx().getNodeKey() >= 0L) {
            if (this.asXmlNodeReadTrx().getKind() == NodeKind.ATTRIBUTE || this.asXmlNodeReadTrx().getKind() == NodeKind.TEXT) {
                value.append(this.asXmlNodeReadTrx().getValue());
                return value.toString();
            } else {
                if (this.asXmlNodeReadTrx().getKind() != NodeKind.XML_DOCUMENT && this.asXmlNodeReadTrx().getKind() != NodeKind.ELEMENT) throw new IllegalStateException();
                FilterAxis<XmlNodeReadOnlyTrx> axis = new FilterAxis<XmlNodeReadOnlyTrx>(new DescendantAxis(this.asXmlNodeReadTrx()), new TextFilter(this.asXmlNodeReadTrx()), new Filter[0]);
                while (axis.hasNext()) {
                    axis.next();
                    if (value.length() > 0) {
                        value.append(" ");
                    }
                    value.append(this.asXmlNodeReadTrx().getValue());
                }
            }
            return value.toString();
        } else {
            value.append(this.asXmlNodeReadTrx().getValue());
        }
        return value.toString();
    }
}

