/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.operators;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.node.interfaces.Node;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.XPathError;
import io.sirix.service.xml.xpath.operators.AbstractObAxis;
import io.sirix.service.xml.xpath.types.Type;
import io.sirix.utils.TypedValue;

public class IDivOpAxis
extends AbstractObAxis {
    public IDivOpAxis(XmlNodeReadOnlyTrx rtx, Axis mOp1, Axis mOp2) {
        super(rtx, mOp1, mOp2);
    }

    @Override
    public Node operate(AtomicValue mOperand1, AtomicValue mOperand2) throws SirixXPathException {
        Type returnType = this.getReturnType(mOperand1.getTypeKey(), mOperand2.getTypeKey());
        int typeKey = this.asXmlNodeReadTrx().keyForName(returnType.getStringRepr());
        try {
            int op1 = (int)Double.parseDouble(new String(mOperand1.getRawValue()));
            int op2 = (int)Double.parseDouble(new String(mOperand2.getRawValue()));
            int iValue = op1 / op2;
            byte[] value = TypedValue.getBytes(iValue);
            return new AtomicValue(value, typeKey);
        }
        catch (ArithmeticException e) {
            throw new XPathError(XPathError.ErrorType.FOAR0001);
        }
    }

    @Override
    protected Type getReturnType(int mOp1, int mOp2) throws SirixXPathException {
        Type type2;
        Type type1;
        try {
            type1 = Type.getType(mOp1).getPrimitiveBaseType();
            type2 = Type.getType(mOp2).getPrimitiveBaseType();
        }
        catch (IllegalStateException e) {
            throw new XPathError(XPathError.ErrorType.XPTY0004);
        }
        if (type1.isNumericType() && type2.isNumericType()) {
            return Type.INTEGER;
        }
        throw new XPathError(XPathError.ErrorType.XPTY0004);
    }
}

