/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.parser;

import io.sirix.service.xml.xpath.parser.TokenType;
import io.sirix.service.xml.xpath.parser.VariableXPathToken;
import io.sirix.service.xml.xpath.parser.XPathToken;

public final class XPathScanner {
    private final String mQuery;
    private int mPos;
    private int mLastPos;
    private State mState;
    private StringBuilder mOutput;
    private boolean mFinnished;
    private TokenType mType;
    private char mInput;
    private State mStartState;
    private int mCommentCount;

    public XPathScanner(String paramQuery) {
        this.mQuery = paramQuery + "#";
        this.mLastPos = this.mPos = 0;
        this.mStartState = State.START;
        this.mCommentCount = 0;
    }

    public XPathToken nextToken() {
        this.mState = this.mStartState;
        this.mStartState = State.START;
        this.mOutput = new StringBuilder();
        this.mFinnished = false;
        this.mType = TokenType.INVALID;
        this.mLastPos = this.mPos;
        do {
            this.mInput = this.mQuery.charAt(this.mPos);
            switch (this.mState.ordinal()) {
                case 0: {
                    this.scanStart();
                    break;
                }
                case 1: {
                    this.scanNumber();
                    break;
                }
                case 2: {
                    this.scanText();
                    break;
                }
                case 4: {
                    this.scanTwoDigitSpecial();
                    break;
                }
                case 5: {
                    this.scanComment();
                    break;
                }
                case 6: {
                    this.scanENum();
                    break;
                }
                default: {
                    ++this.mPos;
                    this.mFinnished = true;
                }
            }
        } while (!this.mFinnished || this.mPos >= this.mQuery.length());
        if (this.mCommentCount > 0) {
            throw new IllegalStateException("Error in Query. Comment does not end.");
        }
        return new VariableXPathToken(this.mOutput.toString(), this.mType);
    }

    private void scanStart() {
        if (this.isNumber(this.mInput)) {
            this.mState = State.NUMBER;
            this.mOutput.append(this.mInput);
            this.mType = TokenType.VALUE;
        } else if (this.isFirstLetter(this.mInput)) {
            this.mState = State.TEXT;
            this.mOutput.append(this.mInput);
            this.mType = TokenType.TEXT;
        } else if (this.isSpecial(this.mInput)) {
            this.mState = State.SPECIAL;
            this.mOutput.append(this.mInput);
            this.mType = this.retrieveType(this.mInput);
            this.mFinnished = true;
        } else if (this.isTwoDigistSpecial(this.mInput)) {
            this.mState = State.SPECIAL2;
            this.mOutput.append(this.mInput);
            this.mType = this.retrieveType(this.mInput);
        } else if (this.mInput == ' ' || this.mInput == '\n') {
            this.mState = State.START;
            this.mOutput.append(this.mInput);
            this.mFinnished = true;
            this.mType = TokenType.SPACE;
        } else if (this.mInput == '#') {
            this.mType = TokenType.END;
            this.mFinnished = true;
            --this.mPos;
        } else {
            this.mState = State.UNKNOWN;
            this.mOutput.append(this.mInput);
            this.mFinnished = true;
        }
        ++this.mPos;
    }

    private TokenType retrieveType(char paramInput) {
        return switch (paramInput) {
            case ',' -> TokenType.COMMA;
            case '(' -> TokenType.OPEN_BR;
            case ')' -> TokenType.CLOSE_BR;
            case '[' -> TokenType.OPEN_SQP;
            case ']' -> TokenType.CLOSE_SQP;
            case '@' -> TokenType.AT;
            case '=' -> TokenType.EQ;
            case '<', '>' -> TokenType.COMP;
            case '!' -> TokenType.N_EQ;
            case '/' -> TokenType.SLASH;
            case ':' -> TokenType.COLON;
            case '.' -> TokenType.POINT;
            case '+' -> TokenType.PLUS;
            case '-' -> TokenType.MINUS;
            case '\'' -> TokenType.SINGLE_QUOTE;
            case '\"' -> TokenType.DBL_QUOTE;
            case '$' -> TokenType.DOLLAR;
            case '?' -> TokenType.INTERROGATION;
            case '*' -> TokenType.STAR;
            case '|' -> TokenType.OR;
            default -> TokenType.INVALID;
        };
    }

    private boolean isFirstLetter(char paramInput) {
        return paramInput >= 'a' && paramInput <= 'z' || paramInput >= 'A' && paramInput <= 'Z' || paramInput == '_';
    }

    private boolean isNumber(char paramInput) {
        return paramInput >= '0' && paramInput <= '9';
    }

    private boolean isTwoDigistSpecial(char paramInput) {
        return paramInput == '<' || paramInput == '>' || paramInput == '(' || paramInput == '!' || paramInput == '/' || paramInput == '.';
    }

    private boolean isSpecial(char paramInput) {
        return paramInput == ')' || paramInput == ';' || paramInput == ',' || paramInput == '@' || paramInput == '[' || paramInput == ']' || paramInput == '=' || paramInput == '\"' || paramInput == '\'' || paramInput == '$' || paramInput == ':' || paramInput == '|' || paramInput == '+' || paramInput == '-' || paramInput == '?' || paramInput == '*';
    }

    private void scanNumber() {
        if (this.mInput >= '0' && this.mInput <= '9') {
            this.mOutput.append(this.mInput);
            ++this.mPos;
        } else {
            if (this.mInput == 'E' || this.mInput == 'e') {
                this.mStartState = State.E_NUM;
            }
            this.mFinnished = true;
        }
    }

    private void scanText() {
        if (this.isLetter(this.mInput)) {
            this.mOutput.append(this.mInput);
            ++this.mPos;
        } else {
            this.mType = TokenType.TEXT;
            this.mFinnished = true;
        }
    }

    private void scanTwoDigitSpecial() {
        if (this.mInput == '=' && (this.mType == TokenType.COMP || this.mType == TokenType.EQ || this.mType == TokenType.N_EQ)) {
            this.mOutput.append(this.mInput);
            ++this.mPos;
        } else if (this.mInput == '/' && this.mType == TokenType.SLASH) {
            this.mOutput.append(this.mInput);
            this.mType = TokenType.DESC_STEP;
            ++this.mPos;
        } else if (this.mInput == '.' && this.mType == TokenType.POINT) {
            this.mOutput.append(this.mInput);
            this.mType = TokenType.PARENT;
            ++this.mPos;
        } else if (this.mInput == '<' && this.mOutput.toString().equals("<")) {
            this.mOutput.append(this.mInput);
            this.mType = TokenType.L_SHIFT;
            ++this.mPos;
        } else if (this.mInput == '>' && this.mOutput.toString().equals(">")) {
            this.mOutput.append(this.mInput);
            this.mType = TokenType.R_SHIFT;
            ++this.mPos;
        } else if (this.mInput == ':' && this.mType == TokenType.OPEN_BR) {
            this.mOutput = new StringBuilder();
            this.mType = TokenType.COMMENT;
            ++this.mCommentCount;
            this.mState = State.COMMENT;
            ++this.mPos;
        } else {
            this.mFinnished = true;
        }
    }

    private void scanENum() {
        if (this.mInput == 'E' || this.mInput == 'e') {
            this.mOutput.append(this.mInput);
            this.mState = State.START;
            this.mType = TokenType.E_NUMBER;
            this.mFinnished = true;
            ++this.mPos;
        } else {
            this.mFinnished = true;
            this.mState = State.START;
            this.mType = TokenType.INVALID;
        }
    }

    private void scanComment() {
        char input = this.mQuery.charAt(this.mPos + 1);
        if (this.mInput == ':') {
            if (input == ')') {
                --this.mCommentCount;
                if (this.mCommentCount == 0) {
                    this.mState = State.START;
                    ++this.mPos;
                }
            }
        } else if (this.mInput == '(' && input == ':') {
            ++this.mCommentCount;
        }
        ++this.mPos;
    }

    private boolean isLetter(char paramInput) {
        return paramInput >= '0' && paramInput <= '9' || paramInput >= 'a' && paramInput <= 'z' || paramInput >= 'A' && paramInput <= 'Z' || paramInput == '_' || paramInput == '-' || paramInput == '.';
    }

    public XPathToken lookUpTokens(int paramNext) {
        int nextCount = paramNext;
        int lastPos = this.mPos;
        XPathToken token = this.nextToken();
        while (--nextCount > 0) {
            token = this.nextToken();
            if (token.getType() != TokenType.SPACE) continue;
            ++nextCount;
        }
        this.mPos = lastPos;
        return token;
    }

    public String begin() {
        return this.mQuery.substring(0, this.mLastPos);
    }

    public int getPos() {
        return this.mPos;
    }

    public String toString() {
        return this.mQuery;
    }

    private static enum State {
        START,
        NUMBER,
        TEXT,
        SPECIAL,
        SPECIAL2,
        COMMENT,
        E_NUM,
        UNKNOWN;

    }
}

