/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.types;

import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.EXPathError;
import io.sirix.utils.NamePageHash;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public sealed class Type
extends Enum<Type> {
    public static final /* enum */ Type ANY_TYPE = new Type(null, "xs:anyType", 1, false);
    public static final /* enum */ Type ANY_SIMPLE_TYPE = new Type(ANY_TYPE, "xs:anySimpleType", 2, false);
    public static final /* enum */ Type ANY_ATOMIC_TYPE = new Type(ANY_SIMPLE_TYPE, "xs:anyAtomicType", 3, false);
    public static final /* enum */ Type UNTYPED_ATOMIC = new Type(ANY_ATOMIC_TYPE, "xs:untypedAtomic", 4, false){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type UNTYPED = new Type(ANY_TYPE, "xs:untyped", 2, false);
    public static final /* enum */ Type STRING = new Type(ANY_ATOMIC_TYPE, "xs:string", 4, true){

        @Override
        public String getFacet() {
            return ".*";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type DURATION = new Type(ANY_ATOMIC_TYPE, "xs:duration", 4, true){

        @Override
        public String getFacet() {
            return "-?P(((([0-9]+Y([0-9]+M)?)|(([0-9]+M)))(([0-9]+D(T(([0-9]+H([0-9]+M)?([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+M) ([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+(\\.[0-9]+)?S))))?)|((T(([0-9]+H([0-9]+M)?([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+M) ([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+(\\.[0-9]+)?S))))))?)|((([0-9]+D(T(([0-9]+H([0-9]+M)?([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+M)([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+(\\.[0-9]+)?S))))?)|((T(([0-9]+H([0-9]+M)?([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+M)([0-9]+(\\.[0-9]+)?S)?)|(([0-9]+(\\.[0-9]+)?S))))))))";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || YEAR_MONTH_DURATION == mTargetType || DAY_TIME_DURATION == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type YEAR_MONTH_DURATION = new Type(DURATION, "xs:yearMonthDuration", 5, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || DAY_TIME_DURATION == mTargetType || DURATION == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type DAY_TIME_DURATION = new Type(DURATION, "xs:dayTimeDuration", 5, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || YEAR_MONTH_DURATION == mTargetType || DURATION == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type DATE_TIME = new Type(ANY_ATOMIC_TYPE, "xs:dateTime", 4, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || TIME == mTargetType || DATE == mTargetType || G_DAY == mTargetType || G_MONTH == mTargetType || G_MONTH_DAY == mTargetType || G_YEAR == mTargetType || G_YEAR_MONTH == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type TIME = new Type(ANY_ATOMIC_TYPE, "xs:time", 4, true){

        @Override
        public String getFacet() {
            return "(((([01][0-9])|(2[0-3])):([0-5][0-9]):(([0-5][0-9])(\\.[0-9]+)?))|(24:00:00(\\.0+)?))(Z|((\\+|-)(0[0-9]|1[0-4]):[0-5][0-9]))?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType;
        }
    };
    public static final /* enum */ Type DATE = new Type(ANY_ATOMIC_TYPE, "xs:date", 4, true){

        @Override
        public String getFacet() {
            return "-?(([1-9][0-9][0-9][0-9]+)|(0[0-9][0-9][0-9]))-((0[1-9])|(1[0-2]))-(([0-2][0-9])|(3[01]))((\\+|-)(0[0-9]|1[0-4]):[0-5][0-9])?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || DATE_TIME == mTargetType || G_DAY == mTargetType || G_MONTH == mTargetType || G_MONTH_DAY == mTargetType || G_YEAR == mTargetType || G_YEAR_MONTH == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType;
        }
    };
    public static final /* enum */ Type G_YEAR_MONTH = new Type(ANY_ATOMIC_TYPE, "xs:gYearMonth", 4, true){

        @Override
        public String getFacet() {
            return "-?(([1-9][0-9][0-9][0-9]+)|(0[0-9][0-9][0-9]))-((0[1-9])|(1[0-2]))((\\+|-)(0[0-9]|1[0-4]):[0-5][0-9])?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type G_YEAR = new Type(ANY_ATOMIC_TYPE, "xs:gYear", 4, true){

        @Override
        public String getFacet() {
            return "-?(([1-9][0-9][0-9][0-9]+)|(0[0-9][0-9][0-9]))((\\+|\\-)(0[0-9]|1[0-4]):[0-5][0-9])?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type G_MONTH_DAY = new Type(ANY_ATOMIC_TYPE, "xs:gMonthDay", 4, true){

        @Override
        public String getFacet() {
            return "--((0[1-9])|(1[0-2]))-(([0-2][0-9])|(3[01]))((\\+|-)(0[0-9]|1[0-4]):[0-5][0-9])?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type G_DAY = new Type(ANY_ATOMIC_TYPE, "xs:gDay", 4, true){

        @Override
        public String getFacet() {
            return "---(([0-2][0-9]|3[01]))((\\+|-)(0[0-9]|1[0-4]):[0-5][0-9])?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type G_MONTH = new Type(ANY_ATOMIC_TYPE, "xs:gMonth", 4, true){

        @Override
        public String getFacet() {
            return "--((0[1-9])|(1[0-2]))((\\+|-)(0[0-9]|1[0-4]):[0-5][0-9])?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type BOOLEAN = new Type(ANY_ATOMIC_TYPE, "xs:boolean", 4, true){

        @Override
        public String getFacet() {
            return "0|1|true|false";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || FLOAT == mTargetType || DOUBLE == mTargetType || DECIMAL == mTargetType || INTEGER == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type BASE_64_BINARY = new Type(ANY_ATOMIC_TYPE, "xs:base64Binary", 4, true){

        @Override
        public String getFacet() {
            return "((([A-Za-z0-9+/] ?){4})*(([A-Za-z0-9+/] ?){3}[A-Za-z0-9+/]|([A-Za-z0-9+/] ?){2}[AEIMQUYcgkosw048] ?=|[A-Za-z0-9+/] ?[AQgw] ?= ?=))?";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || HEX_BINARY == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type HEX_BINARY = new Type(ANY_ATOMIC_TYPE, "xs:hexBinary", 4, true){

        @Override
        public String getFacet() {
            return "([0-9a-fA-F]{2})*";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || BASE_64_BINARY == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type ANY_URI = new Type(ANY_ATOMIC_TYPE, "xs:anyURI", 4, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type QNAME = new Type(ANY_ATOMIC_TYPE, "xs:QName", 4, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type NOTATION = new Type(ANY_ATOMIC_TYPE, "xs:NOTATION", 4, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType;
        }
    };
    public static final /* enum */ Type FLOAT = new Type(ANY_ATOMIC_TYPE, "xs:float", 4, true){

        @Override
        public String getFacet() {
            return "(-|\\+)?(([0-9]+(.[0-9]*)?)|(.[0-9]+))((e|E)(-|\\+)?[0-9]+)?|-?INF|NaN|\\+INF";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || DOUBLE == mTargetType || DECIMAL == mTargetType || INTEGER == mTargetType || BOOLEAN == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type DOUBLE = new Type(ANY_ATOMIC_TYPE, "xs:double", 4, true){

        @Override
        public String getFacet() {
            return "(-|\\+)?(([0-9]+(.[0-9]*)?)|(.[0-9]+))((e|E)(-|\\+)?[0-9]+)?|-?INF|NaN";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || FLOAT == mTargetType || DECIMAL == mTargetType || INTEGER == mTargetType || BOOLEAN == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type PDECIMAL = new Type(ANY_ATOMIC_TYPE, "xs:pDecimal", 4, true){

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type DECIMAL = new Type(ANY_ATOMIC_TYPE, "xs:decimal", 4, true){

        @Override
        public String getFacet() {
            return "-?(([0-9]+(.[0-9]*)?)|(.[0-9]+))";
        }

        @Override
        public boolean castsTo(Type targetType) {
            return this == targetType || FLOAT == targetType || DOUBLE == targetType || INTEGER == targetType || BOOLEAN == targetType || UNTYPED_ATOMIC == targetType || STRING == targetType || this.derivesFrom(targetType);
        }
    };
    public static final /* enum */ Type INTEGER = new Type(DECIMAL, "xs:integer", 5, false){

        @Override
        public String getFacet() {
            return "-?[0-9]+";
        }

        @Override
        public boolean castsTo(Type mTargetType) {
            return this == mTargetType || FLOAT == mTargetType || DOUBLE == mTargetType || DECIMAL == mTargetType || BOOLEAN == mTargetType || UNTYPED_ATOMIC == mTargetType || STRING == mTargetType || this.derivesFrom(mTargetType);
        }
    };
    public static final /* enum */ Type LONG = new Type(INTEGER, "xs:long", 6, false);
    public static final /* enum */ Type INT = new Type(LONG, "xs:int", 7, false);
    public static final /* enum */ Type SHORT = new Type(INT, "xs:short", 8, false);
    public static final /* enum */ Type BYTE = new Type(SHORT, "xs:byte", 9, false);
    public static final /* enum */ Type NON_POSITIVE_INTEGER = new Type(INTEGER, "xs:nonPositiveInteger", 6, false);
    public static final /* enum */ Type NEGATIVE_INTEGER = new Type(NON_POSITIVE_INTEGER, "xs:negativeInteger", 7, false);
    public static final /* enum */ Type NON_NEGATIVE_INTERGER = new Type(INTEGER, "xs:nonNegativeInteger", 6, false);
    public static final /* enum */ Type POSITIVE_INTEGER = new Type(NON_NEGATIVE_INTERGER, "xs:positiveInteger", 7, false);
    public static final /* enum */ Type UNSIGNED_LONG = new Type(NON_NEGATIVE_INTERGER, "xs:unsignedLong", 7, false);
    public static final /* enum */ Type UNSIGNED_INT = new Type(UNSIGNED_LONG, "xs:unsignedInt", 8, false);
    public static final /* enum */ Type UNSIGNED_SHORT = new Type(UNSIGNED_INT, "xs:unsignedShort", 9, false);
    public static final /* enum */ Type UNSIGNED_BYTE = new Type(UNSIGNED_SHORT, "xs:unsignedByte", 10, false);
    public static final /* enum */ Type NORMALIZED_STRING = new Type(STRING, "xs:normalizedString", 5, false);
    public static final /* enum */ Type TOKEN = new Type(NORMALIZED_STRING, "xs:token", 6, false);
    public static final /* enum */ Type LANGUAGE = new Type(TOKEN, "xs:language", 7, false);
    public static final /* enum */ Type NAME = new Type(TOKEN, "xs:name", 7, false);
    public static final /* enum */ Type NCNAME = new Type(NAME, "xs:NCName", 8, false);
    public static final /* enum */ Type ID = new Type(NCNAME, "xs:ID", 9, false);
    public static final /* enum */ Type IDREF = new Type(NCNAME, "xs:IDREF", 9, false);
    public static final /* enum */ Type ENTITY = new Type(NCNAME, "xs:ENTITY", 9, false);
    public static final /* enum */ Type IDFRES = new Type(ANY_SIMPLE_TYPE, "xs:IDREFS", 3, false);
    public static final /* enum */ Type NMTOKEN = new Type(TOKEN, "xs:NMTOKEN", 7, false);
    public static final /* enum */ Type NMTOKENS = new Type(ANY_SIMPLE_TYPE, "xs:NMTOKENS", 3, false);
    private static Map<Integer, Type> keyToType;
    private static Map<String, Type> nameToType;
    private final Type mDerivedFrom;
    private final String mStringRepr;
    private final int mPrecedence;
    private final boolean mIsPrimitive;
    private static final /* synthetic */ Type[] $VALUES;

    public static Type[] values() {
        return (Type[])$VALUES.clone();
    }

    public static Type valueOf(String name) {
        return Enum.valueOf(Type.class, name);
    }

    public static Type getType(int paramKey) {
        return keyToType.get(paramKey);
    }

    public static Type getType(String paramRepr) {
        return nameToType.get(paramRepr);
    }

    private Type(Type mBaseType, String mRepresentation, int mPrec, boolean mPrimitive) {
        this.mDerivedFrom = mBaseType;
        this.mStringRepr = mRepresentation;
        this.mPrecedence = mPrec;
        this.mIsPrimitive = mPrimitive;
    }

    public boolean isPrimitive() {
        return this.mIsPrimitive;
    }

    public String getStringRepr() {
        return this.mStringRepr;
    }

    public static Type getLeastCommonType(int mType1, int mType2) {
        return Type.getLeastCommonType(Type.getType(mType1), Type.getType(mType2));
    }

    public static Type getLeastCommonType(Type mType1, Type mType2) {
        Type a = mType1;
        Type b = mType2;
        if (a.mDerivedFrom != null && b.mDerivedFrom != null) {
            if (a.mPrecedence != b.mPrecedence) {
                while (a.mPrecedence > b.mPrecedence) {
                    a = a.mDerivedFrom;
                }
                while (a.mPrecedence < b.mPrecedence) {
                    b = b.mDerivedFrom;
                }
            }
            while (a != b) {
                assert (a.mPrecedence == b.mPrecedence);
                a = a.mDerivedFrom;
                b = b.mDerivedFrom;
            }
            assert (a == b);
        } else {
            assert (a == ANY_TYPE || b == ANY_TYPE);
            a = ANY_TYPE;
        }
        return a;
    }

    public boolean derivesFrom(Type mExpectedType) {
        if (this == mExpectedType) {
            return true;
        }
        if (this.mPrecedence > mExpectedType.mPrecedence) {
            Type baseType = this.mDerivedFrom;
            while (baseType.mPrecedence > mExpectedType.mPrecedence) {
                baseType = baseType.mDerivedFrom;
            }
            assert (baseType.mPrecedence == mExpectedType.mPrecedence);
            return baseType == mExpectedType;
        }
        return false;
    }

    public boolean isNumericType() {
        return this.derivesFrom(DOUBLE) || this.derivesFrom(FLOAT) || this.derivesFrom(DECIMAL);
    }

    public boolean isCastableTo(Type mTargetType, String mValue) throws SirixXPathException {
        if (mTargetType == NOTATION || this == NOTATION || mTargetType == ANY_SIMPLE_TYPE || this == ANY_SIMPLE_TYPE) {
            throw EXPathError.XPST0080.getEncapsulatedException();
        }
        if (this == mTargetType || this.derivesFrom(mTargetType)) {
            return true;
        }
        if (this.isPrimitive() && mTargetType.isPrimitive()) {
            if (mTargetType == UNTYPED_ATOMIC || mTargetType == STRING || this.castsTo(mTargetType) || mTargetType.facetIsSatisfiedBy(mValue)) {
                return true;
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
        if (!mTargetType.isPrimitive() && mTargetType.derivesFrom(this)) {
            return mTargetType.facetIsSatisfiedBy(mValue);
        }
        return this.getPrimitiveBaseType().isCastableTo(mTargetType.getPrimitiveBaseType(), mValue) && mTargetType.facetIsSatisfiedBy(mValue);
    }

    public Type getPrimitiveBaseType() throws SirixXPathException {
        Type type = this;
        if (type == UNTYPED || type == UNTYPED_ATOMIC) {
            return type;
        }
        if (type.mPrecedence <= 3 && type != ANY_ATOMIC_TYPE) {
            throw new SirixXPathException("Type " + type.mStringRepr + " has no primitive base type.");
        }
        while (!type.mIsPrimitive) {
            type = type.mDerivedFrom;
        }
        assert (type.mIsPrimitive);
        return type;
    }

    boolean facetIsSatisfiedBy(String mValue) {
        if (this.getFacet().equals("")) {
            return false;
        }
        Pattern pattern = Pattern.compile(this.getFacet());
        Matcher matcher = pattern.matcher(mValue);
        return matcher.matches();
    }

    public String getFacet() {
        return "";
    }

    public boolean castsTo(Type mTargetType) {
        return false;
    }

    private static /* synthetic */ Type[] $values() {
        return new Type[]{ANY_TYPE, ANY_SIMPLE_TYPE, ANY_ATOMIC_TYPE, UNTYPED_ATOMIC, UNTYPED, STRING, DURATION, YEAR_MONTH_DURATION, DAY_TIME_DURATION, DATE_TIME, TIME, DATE, G_YEAR_MONTH, G_YEAR, G_MONTH_DAY, G_DAY, G_MONTH, BOOLEAN, BASE_64_BINARY, HEX_BINARY, ANY_URI, QNAME, NOTATION, FLOAT, DOUBLE, PDECIMAL, DECIMAL, INTEGER, LONG, INT, SHORT, BYTE, NON_POSITIVE_INTEGER, NEGATIVE_INTEGER, NON_NEGATIVE_INTERGER, POSITIVE_INTEGER, UNSIGNED_LONG, UNSIGNED_INT, UNSIGNED_SHORT, UNSIGNED_BYTE, NORMALIZED_STRING, TOKEN, LANGUAGE, NAME, NCNAME, ID, IDREF, ENTITY, IDFRES, NMTOKEN, NMTOKENS};
    }

    static {
        $VALUES = Type.$values();
        keyToType = new HashMap<Integer, Type>();
        nameToType = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            nameToType.put(type.getStringRepr(), type);
            keyToType.put(NamePageHash.generateHashForString(type.getStringRepr()), type);
        }
    }
}

