/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.settings;

import io.sirix.api.PageReadOnlyTrx;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.page.PageFragmentKeyImpl;
import io.sirix.page.PageReference;
import io.sirix.page.interfaces.KeyValuePage;
import io.sirix.page.interfaces.PageFragmentKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.index.qual.NonNegative;

public enum VersioningType {
    FULL{

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> T combineRecordPages(List<T> pages, @NonNegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            assert (pages.size() == 1) : "Only one version of the page!";
            return (T)((KeyValuePage)pages.get(0));
        }

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> PageContainer combineRecordPagesForModification(List<T> pages, @NonNegative int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference, TransactionIntentLog log) {
            assert (pages.size() == 1);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object completePage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            Object modifiedPage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            byte[][] slots = firstPage.slots();
            byte[][] deweyIds = firstPage.deweyIds();
            for (int i = 0; i < firstPage.size(); ++i) {
                byte[] slot = slots[i];
                if (slot == null) continue;
                completePage.setSlot(slot, i);
                completePage.setDeweyId(deweyIds[i], i);
                modifiedPage.setSlot(slot, i);
                modifiedPage.setDeweyId(deweyIds[i], i);
            }
            return PageContainer.getInstance(completePage, modifiedPage);
        }

        @Override
        public int[] getRevisionRoots(@NonNegative int previousRevision, @NonNegative int revsToRestore) {
            return new int[]{previousRevision};
        }
    }
    ,
    DIFFERENTIAL{

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> T combineRecordPages(List<T> pages, @NonNegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            KeyValuePage fullDump;
            assert (pages.size() <= 2);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object pageToReturn = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            KeyValuePage latest = (KeyValuePage)pages.get(0);
            KeyValuePage keyValuePage = fullDump = pages.size() == 1 ? (KeyValuePage)pages.get(0) : (KeyValuePage)pages.get(1);
            assert (latest.getPageKey() == recordPageKey);
            assert (fullDump.getPageKey() == recordPageKey);
            byte[][] slots = firstPage.slots();
            byte[][] deweyIds = firstPage.deweyIds();
            for (int offset = 0; offset < slots.length; ++offset) {
                pageToReturn.setSlot(slots[offset], offset);
                pageToReturn.setDeweyId(deweyIds[offset], offset);
            }
            for (Map.Entry<Long, PageReference> entry : latest.referenceEntrySet()) {
                pageToReturn.setPageReference(entry.getKey(), entry.getValue());
            }
            if (pages.size() == 2) {
                slots = firstPage.slots();
                deweyIds = firstPage.deweyIds();
                for (int offset = 0; offset < slots.length; ++offset) {
                    byte[] deweyId;
                    byte[] recordData = firstPage.getSlot(offset);
                    if (recordData == null) continue;
                    if (pageToReturn.getSlot(offset) == null) {
                        pageToReturn.setSlot(slots[offset], offset);
                    }
                    if ((deweyId = deweyIds[offset]) == null || pageToReturn.getDeweyId(offset) != null) continue;
                    pageToReturn.setDeweyId(deweyId, offset);
                }
                for (Map.Entry<Long, PageReference> entry : fullDump.referenceEntrySet()) {
                    if (pageToReturn.getPageReference(entry.getKey()) != null) continue;
                    pageToReturn.setPageReference(entry.getKey(), entry.getValue());
                    if (pageToReturn.size() != 1024) continue;
                    break;
                }
            }
            return (T)pageToReturn;
        }

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> PageContainer combineRecordPagesForModification(List<T> pages, @NonNegative int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference, TransactionIntentLog log) {
            assert (pages.size() <= 2);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            int revision = pageReadTrx.getUberPage().getRevisionNumber();
            reference.setPageFragments(List.of(new PageFragmentKeyImpl(firstPage.getRevision(), reference.getKey())));
            Object completePage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            Object modifiedPage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            KeyValuePage latest = firstPage;
            KeyValuePage fullDump = pages.size() == 1 ? firstPage : (KeyValuePage)pages.get(1);
            boolean isFullDump = revision % revToRestore == 0;
            byte[][] slots = firstPage.slots();
            byte[][] deweyIds = firstPage.deweyIds();
            for (int offset = 0; offset < slots.length; ++offset) {
                completePage.setSlot(slots[offset], offset);
                completePage.setDeweyId(deweyIds[offset], offset);
                modifiedPage.setSlot(slots[offset], offset);
                modifiedPage.setDeweyId(deweyIds[offset], offset);
            }
            for (Map.Entry<Long, PageReference> entry : latest.referenceEntrySet()) {
                completePage.setPageReference(entry.getKey(), entry.getValue());
                modifiedPage.setPageReference(entry.getKey(), entry.getValue());
            }
            if (latest.size() != 1024) {
                slots = firstPage.slots();
                deweyIds = firstPage.deweyIds();
                for (int offset = 0; offset < slots.length; ++offset) {
                    byte[] recordData = slots[offset];
                    if (completePage.getSlot(offset) == null) {
                        completePage.setSlot(slots[offset], offset);
                    }
                    if (isFullDump && modifiedPage.getSlot(offset) == null) {
                        modifiedPage.setSlot(recordData, offset);
                    }
                    byte[] deweyId = deweyIds[offset];
                    if (completePage.getDeweyId(offset) == null) {
                        completePage.setDeweyId(deweyId, offset);
                    }
                    if (isFullDump && modifiedPage.getDeweyId(offset) == null) {
                        modifiedPage.setDeweyId(deweyId, offset);
                    }
                    if (completePage.size() == 1024) break;
                }
            }
            if (latest.size() != 1024) {
                for (Map.Entry<Long, PageReference> entry : fullDump.referenceEntrySet()) {
                    if (completePage.getPageReference(entry.getKey()) == null) {
                        completePage.setPageReference(entry.getKey(), entry.getValue());
                    }
                    if (isFullDump && modifiedPage.getPageReference(entry.getKey()) == null) {
                        modifiedPage.setPageReference(entry.getKey(), entry.getValue());
                    }
                    if (completePage.size() != 1024) continue;
                    break;
                }
            }
            PageContainer pageContainer = PageContainer.getInstance(completePage, modifiedPage);
            log.put(reference, pageContainer);
            return pageContainer;
        }

        @Override
        public int[] getRevisionRoots(@NonNegative int previousRevision, @NonNegative int revsToRestore) {
            int revisionsToRestore = previousRevision % revsToRestore;
            int lastFullDump = previousRevision - revisionsToRestore;
            if (lastFullDump == previousRevision) {
                return new int[]{lastFullDump};
            }
            return new int[]{previousRevision, lastFullDump};
        }
    }
    ,
    INCREMENTAL{

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> T combineRecordPages(List<T> pages, @NonNegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            assert (pages.size() <= revToRestore);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object pageToReturn = firstPage.newInstance(firstPage.getPageKey(), firstPage.getIndexType(), pageReadTrx);
            boolean filledPage = false;
            block0: for (KeyValuePage page : pages) {
                assert (page.getPageKey() == recordPageKey);
                if (filledPage) break;
                byte[][] slots = page.slots();
                byte[][] deweyIds = page.deweyIds();
                for (int offset = 0; offset < slots.length; ++offset) {
                    byte[] recordData = slots[offset];
                    if (recordData == null) continue;
                    if (pageToReturn.getSlot(offset) == null) {
                        pageToReturn.setSlot(recordData, offset);
                    }
                    byte[] deweyId = deweyIds[offset];
                    if (pageToReturn.getDeweyId(offset) == null) {
                        pageToReturn.setDeweyId(deweyId, offset);
                    }
                    if (pageToReturn.size() != 1024) continue;
                    filledPage = true;
                    break;
                }
                if (filledPage) continue;
                for (Map.Entry<Long, PageReference> entry : page.referenceEntrySet()) {
                    Long recordKey = entry.getKey();
                    if (pageToReturn.getPageReference(recordKey) != null) continue;
                    pageToReturn.setPageReference(recordKey, entry.getValue());
                    if (pageToReturn.size() != 1024) continue;
                    filledPage = true;
                    continue block0;
                }
            }
            return (T)pageToReturn;
        }

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> PageContainer combineRecordPagesForModification(List<T> pages, int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference, TransactionIntentLog log) {
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            ArrayList<PageFragmentKey> previousPageFragmentKeys = new ArrayList<PageFragmentKey>(reference.getPageFragments().size() + 1);
            previousPageFragmentKeys.add(new PageFragmentKeyImpl(firstPage.getRevision(), reference.getKey()));
            int previousRefKeysSize = reference.getPageFragments().size();
            for (int i = 0; i < previousRefKeysSize && previousPageFragmentKeys.size() < revToRestore - 1; ++i) {
                previousPageFragmentKeys.add(reference.getPageFragments().get(i));
            }
            reference.setPageFragments(previousPageFragmentKeys);
            Object completePage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            Object modifiedPage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            boolean isFullDump = pages.size() == revToRestore;
            boolean filledPage = false;
            block1: for (KeyValuePage page : pages) {
                assert (page.getPageKey() == recordPageKey);
                if (filledPage) break;
                DataRecord[] records = page.records();
                byte[][] slots = page.slots();
                byte[][] deweyIds = page.deweyIds();
                for (int offset = 0; offset < records.length; ++offset) {
                    byte[] recordData = slots[offset];
                    if (recordData == null) continue;
                    if (completePage.getSlot(offset) == null) {
                        completePage.setSlot(recordData, offset);
                        if (modifiedPage.getSlot(offset) == null && isFullDump) {
                            modifiedPage.setSlot(recordData, offset);
                        }
                    }
                    byte[] deweyId = deweyIds[offset];
                    if (completePage.getDeweyId(offset) == null) {
                        completePage.setDeweyId(deweyId, offset);
                        if (modifiedPage.getDeweyId(offset) == null && isFullDump) {
                            modifiedPage.setDeweyId(deweyId, offset);
                        }
                    }
                    if (completePage.size() != 1024) continue;
                    filledPage = true;
                    break;
                }
                if (filledPage) continue;
                for (Map.Entry<Long, PageReference> entry : page.referenceEntrySet()) {
                    Long key = entry.getKey();
                    assert (key != null);
                    if (completePage.getPageReference(key) != null) continue;
                    completePage.setPageReference(key, entry.getValue());
                    if (modifiedPage.getPageReference(entry.getKey()) == null && isFullDump) {
                        modifiedPage.setPageReference(key, entry.getValue());
                    }
                    if (completePage.size() != 1024) continue;
                    filledPage = true;
                    continue block1;
                }
            }
            PageContainer pageContainer = PageContainer.getInstance(completePage, modifiedPage);
            log.put(reference, pageContainer);
            return pageContainer;
        }

        @Override
        public int[] getRevisionRoots(@NonNegative int previousRevision, @NonNegative int revsToRestore) {
            ArrayList<Integer> retVal = new ArrayList<Integer>(revsToRestore);
            int until = previousRevision - revsToRestore;
            for (int i = previousRevision; i > until && i >= 0; --i) {
                retVal.add(i);
            }
            assert (retVal.size() <= revsToRestore);
            return this.convertIntegers(retVal);
        }

        private int[] convertIntegers(List<Integer> integers) {
            int[] retVal = new int[integers.size()];
            Iterator<Integer> iterator = integers.iterator();
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = iterator.next();
            }
            return retVal;
        }
    }
    ,
    SLIDING_SNAPSHOT{

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> T combineRecordPages(List<T> pages, @NonNegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            assert (pages.size() <= revToRestore);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object returnVal = firstPage.newInstance(firstPage.getPageKey(), firstPage.getIndexType(), pageReadTrx);
            boolean filledPage = false;
            block0: for (KeyValuePage page : pages) {
                assert (page.getPageKey() == recordPageKey);
                if (filledPage) break;
                byte[][] slots = page.slots();
                byte[][] deweyIds = page.deweyIds();
                for (int offset = 0; offset < slots.length; ++offset) {
                    byte[] recordData = slots[offset];
                    if (recordData == null) continue;
                    if (returnVal.getSlot(offset) == null) {
                        returnVal.setSlot(recordData, offset);
                    }
                    byte[] deweyId = deweyIds[offset];
                    if (returnVal.getDeweyId(offset) != null) continue;
                    returnVal.setDeweyId(deweyId, offset);
                }
                if (returnVal.size() == 1024) {
                    filledPage = true;
                }
                if (filledPage) continue;
                for (Map.Entry<Long, PageReference> entry : page.referenceEntrySet()) {
                    Long recordKey = entry.getKey();
                    if (returnVal.getPageReference(recordKey) != null) continue;
                    returnVal.setPageReference(recordKey, entry.getValue());
                    if (returnVal.size() != 1024) continue;
                    filledPage = true;
                    continue block0;
                }
            }
            return (T)returnVal;
        }

        @Override
        public <V extends DataRecord, T extends KeyValuePage<V>> PageContainer combineRecordPagesForModification(List<T> pages, int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference, TransactionIntentLog log) {
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            ArrayList<PageFragmentKey> previousPageFragmentKeys = new ArrayList<PageFragmentKey>(reference.getPageFragments().size() + 1);
            previousPageFragmentKeys.add(new PageFragmentKeyImpl(firstPage.getRevision(), reference.getKey()));
            int previousRefKeysSize = reference.getPageFragments().size();
            for (int i = 0; i < previousRefKeysSize && previousPageFragmentKeys.size() < revToRestore - 1; ++i) {
                previousPageFragmentKeys.add(reference.getPageFragments().get(i));
            }
            reference.setPageFragments(previousPageFragmentKeys);
            Object completePage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            Object modifyingPage = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            Object pageWithRecordsInSlidingWindow = firstPage.newInstance(recordPageKey, firstPage.getIndexType(), pageReadTrx);
            boolean filledPage = false;
            block1: for (int i = 0; i < pages.size() && !filledPage; ++i) {
                KeyValuePage page = (KeyValuePage)pages.get(i);
                assert (page.getPageKey() == recordPageKey);
                boolean isPageOutOfSlidingWindow = i == pages.size() - 1 && revToRestore == pages.size();
                byte[][] slots = page.slots();
                byte[][] deweyIds = page.deweyIds();
                for (int offset = 0; offset < slots.length; ++offset) {
                    byte[] recordData = slots[offset];
                    byte[] deweyId = deweyIds[offset];
                    if (recordData == null) continue;
                    if (!isPageOutOfSlidingWindow) {
                        pageWithRecordsInSlidingWindow.setSlot(recordData, offset);
                        pageWithRecordsInSlidingWindow.setDeweyId(deweyId, offset);
                    }
                    if (completePage.getSlot(offset) == null) {
                        completePage.setSlot(recordData, offset);
                    }
                    if (isPageOutOfSlidingWindow && pageWithRecordsInSlidingWindow.getSlot(offset) == null) {
                        modifyingPage.setSlot(recordData, offset);
                    }
                    if (completePage.getDeweyId(offset) == null) {
                        completePage.setDeweyId(deweyId, offset);
                    }
                    if (!isPageOutOfSlidingWindow || pageWithRecordsInSlidingWindow.getDeweyId(offset) != null) continue;
                    modifyingPage.setDeweyId(deweyId, offset);
                }
                if (completePage.size() == 1024) {
                    filledPage = true;
                }
                if (filledPage) continue;
                for (Map.Entry<Long, PageReference> entry : page.referenceEntrySet()) {
                    Long key = entry.getKey();
                    assert (key != null);
                    if (!isPageOutOfSlidingWindow) {
                        pageWithRecordsInSlidingWindow.setPageReference(key, entry.getValue());
                    }
                    if (completePage.getPageReference(key) == null) {
                        completePage.setPageReference(key, entry.getValue());
                    }
                    if (isPageOutOfSlidingWindow && pageWithRecordsInSlidingWindow.getPageReference(key) == null) {
                        modifyingPage.setPageReference(key, entry.getValue());
                    }
                    if (completePage.size() != 1024) continue;
                    filledPage = true;
                    continue block1;
                }
            }
            PageContainer pageContainer = PageContainer.getInstance(completePage, modifyingPage);
            log.put(reference, pageContainer);
            return pageContainer;
        }

        @Override
        public int[] getRevisionRoots(@NonNegative int previousRevision, @NonNegative int revsToRestore) {
            ArrayList<Integer> retVal = new ArrayList<Integer>(revsToRestore);
            int until = previousRevision - revsToRestore;
            for (int i = previousRevision; i > until && i >= 0; --i) {
                retVal.add(i);
            }
            assert (retVal.size() <= revsToRestore);
            return this.convertIntegers(retVal);
        }

        private int[] convertIntegers(List<Integer> integers) {
            int[] retVal = new int[integers.size()];
            Iterator<Integer> iterator = integers.iterator();
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = iterator.next();
            }
            return retVal;
        }
    };


    private static <V extends DataRecord, T extends KeyValuePage<V>> void setSlots(T pageToReadFrom, T ... pagesToSetSlots) {
        byte[][] slots = pageToReadFrom.slots();
        for (int offset = 0; offset < slots.length; ++offset) {
            byte[] recordData = slots[offset];
            for (T page : pagesToSetSlots) {
                page.setSlot(recordData, offset);
            }
        }
    }

    private static <V extends DataRecord, T extends KeyValuePage<V>> void setDeweyIds(T pageToReadFrom, T ... pagesToSetDeweyIds) {
        byte[][] deweyIds = pageToReadFrom.deweyIds();
        for (int offset = 0; offset < deweyIds.length; ++offset) {
            byte[] deweyId = deweyIds[offset];
            for (T page : pagesToSetDeweyIds) {
                page.setDeweyId(deweyId, offset);
            }
        }
    }

    public abstract <V extends DataRecord, T extends KeyValuePage<V>> T combineRecordPages(List<T> var1, @NonNegative int var2, PageReadOnlyTrx var3);

    public abstract <V extends DataRecord, T extends KeyValuePage<V>> PageContainer combineRecordPagesForModification(List<T> var1, @NonNegative int var2, PageReadOnlyTrx var3, PageReference var4, TransactionIntentLog var5);

    public abstract int[] getRevisionRoots(@NonNegative int var1, @NonNegative int var2);
}

