/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import io.sirix.utils.Array;
import java.util.Arrays;

public abstract class ASet {
    protected int[] buckets;
    protected int[] next;
    protected int size = 1;

    protected ASet() {
    }

    protected ASet(long capacity) {
        long c;
        for (c = 1L; c < capacity; c <<= 1) {
        }
        int s = Array.checkCapacity(c);
        this.buckets = new int[s];
        this.next = new int[s];
    }

    protected void clear() {
        Arrays.fill(this.buckets, 0);
        this.size = 1;
    }

    public final int size() {
        return this.size - 1;
    }

    public final boolean isEmpty() {
        return this.size == 1;
    }

    protected final void checkSize() {
        if (this.size < this.capacity()) {
            return;
        }
        int newSize = this.size << 1;
        int[] tmp = new int[newSize];
        int[] nArray = this.buckets;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int id = b = nArray[i];
            while (id != 0) {
                int p = this.hash(id) & newSize - 1;
                int nx = this.next[id];
                this.next[id] = tmp[p];
                tmp[p] = id;
                id = nx;
            }
        }
        this.buckets = tmp;
        this.next = Arrays.copyOf(this.next, newSize);
        this.rehash(newSize);
    }

    protected final int capacity() {
        return this.next.length;
    }

    protected abstract int hash(int var1);

    protected abstract void rehash(int var1);

    public String toString(Object[] keys) {
        return this.toString(keys, null);
    }

    public String toString(Object[] keys, Object[] values) {
        StringBuilder sb = new StringBuilder().append(this.getClass().toString()).append('[');
        boolean more = false;
        for (int i = 1; i < this.size; ++i) {
            Object key = keys[i];
            if (key == null) continue;
            if (more) {
                sb.append(',');
            }
            sb.append(key);
            if (values != null) {
                sb.append('=').append(values[i]);
            }
            more = true;
        }
        return sb.append(']').toString();
    }
}

