/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import io.sirix.utils.ASet;
import java.util.ArrayList;
import java.util.Arrays;

public class IntSet
extends ASet {
    int[] keys = new int[this.capacity()];

    public IntSet() {
        this(8L);
    }

    public IntSet(long capacity) {
        super(capacity);
    }

    public final boolean add(int key) {
        return this.index(key) > 0;
    }

    final int put(int key) {
        int id = this.index(key);
        return Math.abs(id);
    }

    public final boolean contains(int key) {
        return this.id(key) > 0;
    }

    final int id(int key) {
        int b = key & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (key == this.keys[id]) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final int key(int id) {
        return this.keys[id];
    }

    private int index(int key) {
        this.checkSize();
        int b = key & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (key == this.keys[id]) {
                return -id;
            }
            id = this.next[id];
        }
        int s = this.size++;
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected int hash(int id) {
        return this.keys[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Arrays.copyOf(this.keys, newSize);
    }

    public final int[] toArray() {
        return Arrays.copyOfRange(this.keys, 1, this.size);
    }

    public String toString() {
        ArrayList<Integer> k = new ArrayList<Integer>(this.keys.length);
        for (int key : this.keys) {
            k.add(key);
        }
        return this.toString(k.toArray());
    }
}

