/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;

public final class SirixFiles {
    private SirixFiles() {
        throw new AssertionError((Object)"May not be instantiated!");
    }

    public static void recursiveRemove(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static boolean isDirectoryEmpty(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> entries = Files.list(path);
                try {
                    bl = entries.findFirst().isEmpty();
                    if (entries == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (entries != null) {
                            try {
                                entries.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                entries.close();
            }
            return bl;
        }
        return false;
    }
}

