/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.DatabaseManager;
import io.sirix.access.DatabaseModule_DatabaseSessionsFactory;
import io.sirix.access.DatabaseModule_ResourceManagersFactory;
import io.sirix.access.DatabaseType;
import io.sirix.access.LocalDatabaseFactory;
import io.sirix.access.LocalDatabaseModule_DatabaseNameFactory;
import io.sirix.access.LocalDatabaseModule_DatabaseTypeFactory;
import io.sirix.access.PathBasedPool;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.ResourceSessionFactory;
import io.sirix.access.ResourceSessionModule_IoStorageFactory;
import io.sirix.access.ResourceSessionModule_RootPageFactory;
import io.sirix.access.ResourceSessionModule_WriteLockFactory;
import io.sirix.access.ResourceStore;
import io.sirix.access.User;
import io.sirix.access.WriteLocksRegistry;
import io.sirix.access.WriteLocksRegistry_Factory;
import io.sirix.access.json.JsonLocalDatabaseComponent;
import io.sirix.access.json.JsonLocalDatabaseModule_JsonDatabaseFactory;
import io.sirix.access.json.JsonLocalDatabaseModule_JsonResourceManagerFactory;
import io.sirix.access.json.JsonLocalDatabaseModule_ResourceManagerFactoryFactory;
import io.sirix.access.json.JsonResourceSessionComponent;
import io.sirix.access.json.LocalJsonDatabaseFactory;
import io.sirix.access.json.LocalJsonDatabaseFactory_Factory;
import io.sirix.access.trx.TransactionManagerImpl_Factory;
import io.sirix.access.trx.node.json.JsonResourceSessionImpl;
import io.sirix.access.trx.node.json.JsonResourceSessionImpl_Factory;
import io.sirix.access.trx.node.xml.XmlResourceSessionImpl;
import io.sirix.access.trx.node.xml.XmlResourceSessionImpl_Factory;
import io.sirix.access.trx.page.PageTrxFactory;
import io.sirix.access.trx.page.PageTrxFactory_Factory;
import io.sirix.access.xml.LocalXmlDatabaseFactory;
import io.sirix.access.xml.LocalXmlDatabaseFactory_Factory;
import io.sirix.access.xml.XmlLocalDatabaseComponent;
import io.sirix.access.xml.XmlLocalDatabaseModule_ResourceManagerFactoryFactory;
import io.sirix.access.xml.XmlLocalDatabaseModule_XmlDatabaseFactory;
import io.sirix.access.xml.XmlLocalDatabaseModule_XmlResourceManagerFactory;
import io.sirix.access.xml.XmlResourceManagerComponent;
import io.sirix.api.Database;
import io.sirix.api.ResourceSession;
import io.sirix.api.TransactionManager;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.cache.BufferManager;
import io.sirix.io.IOStorage;
import io.sirix.page.UberPage;
import java.nio.file.Path;
import java.util.concurrent.Semaphore;
import javax.inject.Provider;

public final class DaggerDatabaseManager
implements DatabaseManager {
    private Provider<JsonLocalDatabaseComponent.Builder> jsonLocalDatabaseComponentBuilderProvider;
    private Provider<LocalJsonDatabaseFactory> localJsonDatabaseFactoryProvider;
    private Provider<XmlLocalDatabaseComponent.Builder> xmlLocalDatabaseComponentBuilderProvider;
    private Provider<LocalXmlDatabaseFactory> localXmlDatabaseFactoryProvider;
    private Provider<PathBasedPool<Database<?>>> databaseSessionsProvider;
    private Provider<PathBasedPool<ResourceSession<?, ?>>> resourceManagersProvider;
    private Provider<WriteLocksRegistry> writeLocksRegistryProvider;

    private DaggerDatabaseManager() {
        this.initialize();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DatabaseManager create() {
        return new Builder().build();
    }

    private void initialize() {
        this.jsonLocalDatabaseComponentBuilderProvider = new Provider<JsonLocalDatabaseComponent.Builder>(){

            public JsonLocalDatabaseComponent.Builder get() {
                return new JsonLocalDatabaseComponentBuilder();
            }
        };
        this.localJsonDatabaseFactoryProvider = DoubleCheck.provider((Provider)LocalJsonDatabaseFactory_Factory.create(this.jsonLocalDatabaseComponentBuilderProvider));
        this.xmlLocalDatabaseComponentBuilderProvider = new Provider<XmlLocalDatabaseComponent.Builder>(){

            public XmlLocalDatabaseComponent.Builder get() {
                return new XmlLocalDatabaseComponentBuilder();
            }
        };
        this.localXmlDatabaseFactoryProvider = DoubleCheck.provider((Provider)LocalXmlDatabaseFactory_Factory.create(this.xmlLocalDatabaseComponentBuilderProvider));
        this.databaseSessionsProvider = DoubleCheck.provider((Provider)DatabaseModule_DatabaseSessionsFactory.create());
        this.resourceManagersProvider = DoubleCheck.provider((Provider)DatabaseModule_ResourceManagersFactory.create());
        this.writeLocksRegistryProvider = DoubleCheck.provider((Provider)WriteLocksRegistry_Factory.create());
    }

    @Override
    public JsonLocalDatabaseComponent.Builder jsonDatabaseBuilder() {
        return new JsonLocalDatabaseComponentBuilder();
    }

    @Override
    public XmlLocalDatabaseComponent.Builder xmlDatabaseBuilder() {
        return new XmlLocalDatabaseComponentBuilder();
    }

    @Override
    public LocalDatabaseFactory<JsonResourceSession> jsonDatabaseFactory() {
        return (LocalDatabaseFactory)this.localJsonDatabaseFactoryProvider.get();
    }

    @Override
    public LocalDatabaseFactory<XmlResourceSession> xmlDatabaseFactory() {
        return (LocalDatabaseFactory)this.localXmlDatabaseFactoryProvider.get();
    }

    @Override
    public PathBasedPool<Database<?>> sessions() {
        return (PathBasedPool)this.databaseSessionsProvider.get();
    }

    public static final class Builder {
        private Builder() {
        }

        public DatabaseManager build() {
            return new DaggerDatabaseManager();
        }
    }

    private final class JsonLocalDatabaseComponentBuilder
    implements JsonLocalDatabaseComponent.Builder {
        private DatabaseConfiguration databaseConfiguration;
        private User user;

        private JsonLocalDatabaseComponentBuilder() {
        }

        @Override
        public JsonLocalDatabaseComponentBuilder databaseConfiguration(DatabaseConfiguration configuration) {
            this.databaseConfiguration = (DatabaseConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public JsonLocalDatabaseComponentBuilder user(User user) {
            this.user = (User)Preconditions.checkNotNull((Object)user);
            return this;
        }

        @Override
        public JsonLocalDatabaseComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.databaseConfiguration, DatabaseConfiguration.class);
            Preconditions.checkBuilderRequirement((Object)this.user, User.class);
            return new JsonLocalDatabaseComponentImpl(this.databaseConfiguration, this.user);
        }
    }

    private final class XmlLocalDatabaseComponentBuilder
    implements XmlLocalDatabaseComponent.Builder {
        private DatabaseConfiguration databaseConfiguration;
        private User user;

        private XmlLocalDatabaseComponentBuilder() {
        }

        @Override
        public XmlLocalDatabaseComponentBuilder databaseConfiguration(DatabaseConfiguration configuration) {
            this.databaseConfiguration = (DatabaseConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public XmlLocalDatabaseComponentBuilder user(User user) {
            this.user = (User)Preconditions.checkNotNull((Object)user);
            return this;
        }

        @Override
        public XmlLocalDatabaseComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.databaseConfiguration, DatabaseConfiguration.class);
            Preconditions.checkBuilderRequirement((Object)this.user, User.class);
            return new XmlLocalDatabaseComponentImpl(this.databaseConfiguration, this.user);
        }
    }

    private final class XmlLocalDatabaseComponentImpl
    implements XmlLocalDatabaseComponent {
        private Provider<TransactionManager> transactionManagerProvider;
        private Provider<DatabaseConfiguration> databaseConfigurationProvider;
        private Provider<XmlResourceManagerComponent.Builder> resourceManagerBuilderProvider;
        private Provider<ResourceSessionFactory<XmlResourceSession>> resourceManagerFactoryProvider;
        private Provider<ResourceStore<XmlResourceSession>> xmlResourceManagerProvider;
        private Provider<Database<XmlResourceSession>> xmlDatabaseProvider;
        private Provider<User> userProvider;
        private Provider<DatabaseType> databaseTypeProvider;

        private XmlLocalDatabaseComponentImpl(DatabaseConfiguration databaseConfigurationParam, User userParam) {
            this.initialize(databaseConfigurationParam, userParam);
        }

        private void initialize(DatabaseConfiguration databaseConfigurationParam, User userParam) {
            this.transactionManagerProvider = DoubleCheck.provider((Provider)TransactionManagerImpl_Factory.create());
            this.databaseConfigurationProvider = InstanceFactory.create((Object)databaseConfigurationParam);
            this.resourceManagerBuilderProvider = new Provider<XmlResourceManagerComponent.Builder>(){

                public XmlResourceManagerComponent.Builder get() {
                    return new XmlResourceManagerComponentBuilder();
                }
            };
            this.resourceManagerFactoryProvider = DoubleCheck.provider((Provider)XmlLocalDatabaseModule_ResourceManagerFactoryFactory.create(this.resourceManagerBuilderProvider));
            this.xmlResourceManagerProvider = DoubleCheck.provider((Provider)XmlLocalDatabaseModule_XmlResourceManagerFactory.create(DaggerDatabaseManager.this.resourceManagersProvider, this.resourceManagerFactoryProvider));
            this.xmlDatabaseProvider = DoubleCheck.provider((Provider)XmlLocalDatabaseModule_XmlDatabaseFactory.create(this.transactionManagerProvider, this.databaseConfigurationProvider, DaggerDatabaseManager.this.databaseSessionsProvider, this.xmlResourceManagerProvider, DaggerDatabaseManager.this.writeLocksRegistryProvider, DaggerDatabaseManager.this.resourceManagersProvider));
            this.userProvider = InstanceFactory.create((Object)userParam);
            this.databaseTypeProvider = DoubleCheck.provider((Provider)LocalDatabaseModule_DatabaseTypeFactory.create(this.databaseConfigurationProvider));
        }

        @Override
        public Database<XmlResourceSession> database() {
            return (Database)this.xmlDatabaseProvider.get();
        }

        @Override
        public XmlResourceManagerComponent.Builder resourceManagerBuilder() {
            return new XmlResourceManagerComponentBuilder();
        }

        private final class XmlResourceManagerComponentBuilder
        implements XmlResourceManagerComponent.Builder {
            private ResourceConfiguration resourceConfig;
            private BufferManager bufferManager;
            private Path resourceFile;

            private XmlResourceManagerComponentBuilder() {
            }

            @Override
            public XmlResourceManagerComponentBuilder resourceConfig(ResourceConfiguration resourceConfiguration) {
                this.resourceConfig = (ResourceConfiguration)Preconditions.checkNotNull((Object)resourceConfiguration);
                return this;
            }

            @Override
            public XmlResourceManagerComponentBuilder bufferManager(BufferManager bufferManager) {
                this.bufferManager = (BufferManager)Preconditions.checkNotNull((Object)bufferManager);
                return this;
            }

            @Override
            public XmlResourceManagerComponentBuilder resourceFile(Path resourceFile) {
                this.resourceFile = (Path)Preconditions.checkNotNull((Object)resourceFile);
                return this;
            }

            @Override
            public XmlResourceManagerComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.resourceConfig, ResourceConfiguration.class);
                Preconditions.checkBuilderRequirement((Object)this.bufferManager, BufferManager.class);
                Preconditions.checkBuilderRequirement((Object)this.resourceFile, Path.class);
                return new XmlResourceManagerComponentImpl(this.resourceConfig, this.bufferManager, this.resourceFile);
            }
        }

        private final class XmlResourceManagerComponentImpl
        implements XmlResourceManagerComponent {
            private Provider<ResourceConfiguration> resourceConfigProvider;
            private Provider<BufferManager> bufferManagerProvider;
            private Provider<IOStorage> ioStorageProvider;
            private Provider<UberPage> rootPageProvider;
            private Provider<Semaphore> writeLockProvider;
            private Provider<PageTrxFactory> pageTrxFactoryProvider;
            private Provider<XmlResourceSessionImpl> xmlResourceSessionImplProvider;
            private Provider<XmlResourceSession> resourceSessionProvider;

            private XmlResourceManagerComponentImpl(ResourceConfiguration resourceConfigParam, BufferManager bufferManagerParam, Path resourceFile) {
                this.initialize(resourceConfigParam, bufferManagerParam, resourceFile);
            }

            private void initialize(ResourceConfiguration resourceConfigParam, BufferManager bufferManagerParam, Path resourceFile) {
                this.resourceConfigProvider = InstanceFactory.create((Object)resourceConfigParam);
                this.bufferManagerProvider = InstanceFactory.create((Object)bufferManagerParam);
                this.ioStorageProvider = DoubleCheck.provider((Provider)ResourceSessionModule_IoStorageFactory.create(this.resourceConfigProvider));
                this.rootPageProvider = DoubleCheck.provider((Provider)ResourceSessionModule_RootPageFactory.create(this.ioStorageProvider));
                this.writeLockProvider = DoubleCheck.provider((Provider)ResourceSessionModule_WriteLockFactory.create(DaggerDatabaseManager.this.writeLocksRegistryProvider, this.resourceConfigProvider));
                this.pageTrxFactoryProvider = PageTrxFactory_Factory.create(XmlLocalDatabaseComponentImpl.this.databaseTypeProvider);
                this.xmlResourceSessionImplProvider = XmlResourceSessionImpl_Factory.create(XmlLocalDatabaseComponentImpl.this.xmlResourceManagerProvider, this.resourceConfigProvider, this.bufferManagerProvider, this.ioStorageProvider, this.rootPageProvider, this.writeLockProvider, XmlLocalDatabaseComponentImpl.this.userProvider, this.pageTrxFactoryProvider);
                this.resourceSessionProvider = DoubleCheck.provider(this.xmlResourceSessionImplProvider);
            }

            @Override
            public XmlResourceSession resourceManager() {
                return (XmlResourceSession)this.resourceSessionProvider.get();
            }
        }
    }

    private final class JsonLocalDatabaseComponentImpl
    implements JsonLocalDatabaseComponent {
        private Provider<TransactionManager> transactionManagerProvider;
        private Provider<DatabaseConfiguration> databaseConfigurationProvider;
        private Provider<JsonResourceSessionComponent.Builder> resourceManagerBuilderProvider;
        private Provider<ResourceSessionFactory<JsonResourceSession>> resourceManagerFactoryProvider;
        private Provider<ResourceStore<JsonResourceSession>> jsonResourceManagerProvider;
        private Provider<Database<JsonResourceSession>> jsonDatabaseProvider;
        private Provider<User> userProvider;
        private Provider<String> databaseNameProvider;
        private Provider<DatabaseType> databaseTypeProvider;

        private JsonLocalDatabaseComponentImpl(DatabaseConfiguration databaseConfigurationParam, User userParam) {
            this.initialize(databaseConfigurationParam, userParam);
        }

        private void initialize(DatabaseConfiguration databaseConfigurationParam, User userParam) {
            this.transactionManagerProvider = DoubleCheck.provider((Provider)TransactionManagerImpl_Factory.create());
            this.databaseConfigurationProvider = InstanceFactory.create((Object)databaseConfigurationParam);
            this.resourceManagerBuilderProvider = new Provider<JsonResourceSessionComponent.Builder>(){

                public JsonResourceSessionComponent.Builder get() {
                    return new JsonResourceSessionComponentBuilder();
                }
            };
            this.resourceManagerFactoryProvider = DoubleCheck.provider((Provider)JsonLocalDatabaseModule_ResourceManagerFactoryFactory.create(this.resourceManagerBuilderProvider));
            this.jsonResourceManagerProvider = DoubleCheck.provider((Provider)JsonLocalDatabaseModule_JsonResourceManagerFactory.create(DaggerDatabaseManager.this.resourceManagersProvider, this.resourceManagerFactoryProvider));
            this.jsonDatabaseProvider = DoubleCheck.provider((Provider)JsonLocalDatabaseModule_JsonDatabaseFactory.create(this.transactionManagerProvider, this.databaseConfigurationProvider, DaggerDatabaseManager.this.databaseSessionsProvider, this.jsonResourceManagerProvider, DaggerDatabaseManager.this.writeLocksRegistryProvider, DaggerDatabaseManager.this.resourceManagersProvider));
            this.userProvider = InstanceFactory.create((Object)userParam);
            this.databaseNameProvider = DoubleCheck.provider((Provider)LocalDatabaseModule_DatabaseNameFactory.create(this.databaseConfigurationProvider));
            this.databaseTypeProvider = DoubleCheck.provider((Provider)LocalDatabaseModule_DatabaseTypeFactory.create(this.databaseConfigurationProvider));
        }

        @Override
        public Database<JsonResourceSession> database() {
            return (Database)this.jsonDatabaseProvider.get();
        }

        @Override
        public JsonResourceSessionComponent.Builder resourceManagerBuilder() {
            return new JsonResourceSessionComponentBuilder();
        }

        private final class JsonResourceSessionComponentBuilder
        implements JsonResourceSessionComponent.Builder {
            private ResourceConfiguration resourceConfig;
            private BufferManager bufferManager;
            private Path resourceFile;

            private JsonResourceSessionComponentBuilder() {
            }

            @Override
            public JsonResourceSessionComponentBuilder resourceConfig(ResourceConfiguration resourceConfiguration) {
                this.resourceConfig = (ResourceConfiguration)Preconditions.checkNotNull((Object)resourceConfiguration);
                return this;
            }

            @Override
            public JsonResourceSessionComponentBuilder bufferManager(BufferManager bufferManager) {
                this.bufferManager = (BufferManager)Preconditions.checkNotNull((Object)bufferManager);
                return this;
            }

            @Override
            public JsonResourceSessionComponentBuilder resourceFile(Path resourceFile) {
                this.resourceFile = (Path)Preconditions.checkNotNull((Object)resourceFile);
                return this;
            }

            @Override
            public JsonResourceSessionComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.resourceConfig, ResourceConfiguration.class);
                Preconditions.checkBuilderRequirement((Object)this.bufferManager, BufferManager.class);
                Preconditions.checkBuilderRequirement((Object)this.resourceFile, Path.class);
                return new JsonResourceSessionComponentImpl(this.resourceConfig, this.bufferManager, this.resourceFile);
            }
        }

        private final class JsonResourceSessionComponentImpl
        implements JsonResourceSessionComponent {
            private Provider<ResourceConfiguration> resourceConfigProvider;
            private Provider<BufferManager> bufferManagerProvider;
            private Provider<IOStorage> ioStorageProvider;
            private Provider<UberPage> rootPageProvider;
            private Provider<Semaphore> writeLockProvider;
            private Provider<PageTrxFactory> pageTrxFactoryProvider;
            private Provider<JsonResourceSessionImpl> jsonResourceSessionImplProvider;
            private Provider<JsonResourceSession> resourceSessionProvider;

            private JsonResourceSessionComponentImpl(ResourceConfiguration resourceConfigParam, BufferManager bufferManagerParam, Path resourceFile) {
                this.initialize(resourceConfigParam, bufferManagerParam, resourceFile);
            }

            private void initialize(ResourceConfiguration resourceConfigParam, BufferManager bufferManagerParam, Path resourceFile) {
                this.resourceConfigProvider = InstanceFactory.create((Object)resourceConfigParam);
                this.bufferManagerProvider = InstanceFactory.create((Object)bufferManagerParam);
                this.ioStorageProvider = DoubleCheck.provider((Provider)ResourceSessionModule_IoStorageFactory.create(this.resourceConfigProvider));
                this.rootPageProvider = DoubleCheck.provider((Provider)ResourceSessionModule_RootPageFactory.create(this.ioStorageProvider));
                this.writeLockProvider = DoubleCheck.provider((Provider)ResourceSessionModule_WriteLockFactory.create(DaggerDatabaseManager.this.writeLocksRegistryProvider, this.resourceConfigProvider));
                this.pageTrxFactoryProvider = PageTrxFactory_Factory.create(JsonLocalDatabaseComponentImpl.this.databaseTypeProvider);
                this.jsonResourceSessionImplProvider = JsonResourceSessionImpl_Factory.create(JsonLocalDatabaseComponentImpl.this.jsonResourceManagerProvider, this.resourceConfigProvider, this.bufferManagerProvider, this.ioStorageProvider, this.rootPageProvider, this.writeLockProvider, JsonLocalDatabaseComponentImpl.this.userProvider, JsonLocalDatabaseComponentImpl.this.databaseNameProvider, this.pageTrxFactoryProvider);
                this.resourceSessionProvider = DoubleCheck.provider(this.jsonResourceSessionImplProvider);
            }

            @Override
            public JsonResourceSession resourceManager() {
                return (JsonResourceSession)this.resourceSessionProvider.get();
            }
        }
    }
}

