/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.sirix.access.DatabaseType;
import io.sirix.exception.SirixIOException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DatabaseConfiguration {
    private final Path file;
    private long maxResourceID;
    private DatabaseType databaseType;

    public DatabaseConfiguration(Path file) {
        this.file = file;
    }

    public DatabaseConfiguration setDatabaseType(DatabaseType type) {
        this.databaseType = Objects.requireNonNull(type);
        return this;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseConfiguration setMaximumResourceID(long id) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"ID must be >= 0!");
        this.maxResourceID = id;
        return this;
    }

    public long getMaxResourceID() {
        return this.maxResourceID;
    }

    public Path getDatabaseFile() {
        return this.file;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("File", (Object)this.file).toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DatabaseConfiguration)) {
            return false;
        }
        DatabaseConfiguration other = (DatabaseConfiguration)obj;
        return com.google.common.base.Objects.equal((Object)this.file, (Object)other.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public Path getConfigFile() {
        return this.file.resolve(DatabasePaths.CONFIG_BINARY.getFile());
    }

    public String getDatabaseName() {
        return this.file.getFileName().toString();
    }

    public static void serialize(DatabaseConfiguration config) throws SirixIOException {
        try (FileWriter fileWriter = new FileWriter(config.getConfigFile().toFile());
             JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
            jsonWriter.beginObject();
            String filePath = config.file.toAbsolutePath().toString();
            jsonWriter.name("file").value(filePath);
            jsonWriter.name("ID").value(config.maxResourceID);
            jsonWriter.name("databaseType").value(config.databaseType.toString());
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static DatabaseConfiguration deserialize(Path file) {
        try (FileReader fileReader = new FileReader(file.toAbsolutePath().resolve(DatabasePaths.CONFIG_BINARY.getFile()).toFile());){
            DatabaseConfiguration databaseConfiguration;
            try (JsonReader jsonReader = new JsonReader((Reader)fileReader);){
                jsonReader.beginObject();
                String fileName = jsonReader.nextName();
                assert (fileName.equals("file"));
                Path dbFile = Paths.get(jsonReader.nextString(), new String[0]);
                String IDName = jsonReader.nextName();
                assert (IDName.equals("ID"));
                int ID = jsonReader.nextInt();
                String databaseType = jsonReader.nextName();
                assert (databaseType.equals("databaseType"));
                String type = jsonReader.nextString();
                jsonReader.endObject();
                DatabaseType dbType = DatabaseType.fromString(type).orElseThrow(() -> new IllegalStateException("Type can not be unknown."));
                databaseConfiguration = new DatabaseConfiguration(dbFile).setMaximumResourceID(ID).setDatabaseType(dbType);
            }
            return databaseConfiguration;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    public static enum DatabasePaths {
        CONFIG_BINARY(Paths.get("dbsetting.obj", new String[0]), false),
        KEY_SELECTOR(Paths.get("keyselector", new String[0]), true),
        DATA(Paths.get("resources", new String[0]), true),
        LOCK(Paths.get(".lock", new String[0]), false);

        private final Path mFile;
        private final boolean mIsFolder;

        private DatabasePaths(Path file, boolean isFolder) {
            this.mFile = Objects.requireNonNull(file);
            this.mIsFolder = isFolder;
        }

        public Path getFile() {
            return this.mFile;
        }

        public boolean isFolder() {
            return this.mIsFolder;
        }

        public static int compareStructure(Path file) {
            Objects.requireNonNull(file);
            int existing = 0;
            for (DatabasePaths paths : DatabasePaths.values()) {
                Path currentFile = file.resolve(paths.getFile());
                if (!Files.exists(currentFile, new LinkOption[0]) || LOCK.getFile().equals(currentFile)) continue;
                ++existing;
            }
            return existing - DatabasePaths.values().length + 1;
        }
    }
}

