/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.User;
import io.sirix.api.Database;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.interfaces.Node;
import io.sirix.node.json.JsonDocumentRootNode;
import io.sirix.node.xml.XmlDocumentRootNode;
import io.sirix.settings.Fixed;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DatabaseType {
    XML("xml"){

        @Override
        public <R extends ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx>> Database<R> createDatabase(DatabaseConfiguration dbConfig, User user) {
            return Databases.MANAGER.xmlDatabaseFactory().createDatabase(dbConfig, user);
        }

        @Override
        public Node getDocumentNode(SirixDeweyID id) {
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), null, 0, 0, id == null ? null : id.toBytes());
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new XmlDocumentRootNode(nodeDel, structDel);
        }
    }
    ,
    JSON("json"){

        @Override
        public <R extends ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx>> Database<R> createDatabase(DatabaseConfiguration dbConfig, User user) {
            return Databases.MANAGER.jsonDatabaseFactory().createDatabase(dbConfig, user);
        }

        @Override
        public Node getDocumentNode(SirixDeweyID id) {
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), null, 0, 0, id == null ? null : id.toBytes());
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new JsonDocumentRootNode(nodeDel, structDel);
        }
    };

    private final String stringType;
    private static final Map<String, DatabaseType> stringToEnum;

    private DatabaseType(String stringType) {
        this.stringType = stringType;
    }

    public String getStringType() {
        return this.stringType;
    }

    public static Optional<DatabaseType> fromString(String symbol) {
        return Optional.ofNullable(stringToEnum.get(symbol));
    }

    public abstract <R extends ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx>> Database<R> createDatabase(DatabaseConfiguration var1, User var2);

    public abstract Node getDocumentNode(SirixDeweyID var1);

    static {
        stringToEnum = Stream.of(DatabaseType.values()).collect(Collectors.toMap(Object::toString, e -> e));
    }
}

