/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PathBasedPool<E> {
    private static final Logger logger = LoggerFactory.getLogger(PathBasedPool.class);
    private final Map<Path, Set<E>> sessions = new ConcurrentHashMap<Path, Set<E>>();

    public void putObject(Path file, E object) {
        this.sessions.compute(file, (key, value) -> this.append((Path)key, (Set<E>)value, object));
    }

    public boolean containsAnyEntry(Path file) {
        return this.sessions.containsKey(file);
    }

    public void removeObject(Path file, E object) {
        this.sessions.computeIfPresent(file, (key, value) -> this.remove((Path)key, (Set<E>)value, object));
    }

    private @Nullable Set<E> remove(Path path, Set<E> objects, E object) {
        logger.trace("Removing session in path {}", (Object)path);
        objects.remove(object);
        return objects.isEmpty() ? null : objects;
    }

    private Set<E> append(Path path, @Nullable Set<E> objects, E object) {
        HashSet<E> coalescedSessions = objects == null ? new HashSet<E>() : objects;
        logger.trace("Registering new session in path {}", (Object)path);
        coalescedSessions.add(object);
        return coalescedSessions;
    }

    public Map<Path, Set<E>> asMap() {
        return Collections.unmodifiableMap(this.sessions);
    }
}

