/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import dagger.Module;
import dagger.Provides;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.WriteLocksRegistry;
import io.sirix.dagger.ResourceSessionScope;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.StorageType;
import io.sirix.page.PageReference;
import io.sirix.page.UberPage;
import java.util.concurrent.Semaphore;

@Module
public interface ResourceSessionModule {
    @Provides
    @ResourceSessionScope
    public static IOStorage ioStorage(ResourceConfiguration resourceConfiguration) {
        return StorageType.getStorage(resourceConfiguration);
    }

    @Provides
    @ResourceSessionScope
    public static Semaphore writeLock(WriteLocksRegistry registry, ResourceConfiguration resourceConfiguration) {
        return registry.getWriteLock(resourceConfiguration.getResource());
    }

    @Provides
    @ResourceSessionScope
    public static UberPage rootPage(IOStorage storage) {
        UberPage uberPage;
        if (storage.exists()) {
            try (Reader reader = storage.createReader();){
                PageReference firstRef = reader.readUberPageReference();
                if (firstRef.getPage() == null) {
                    uberPage = (UberPage)reader.read(firstRef, null);
                }
                uberPage = (UberPage)firstRef.getPage();
            }
        } else {
            uberPage = new UberPage();
        }
        return uberPage;
    }
}

