/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import io.sirix.access.PathBasedPool;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.ResourceSessionFactory;
import io.sirix.access.ResourceStore;
import io.sirix.access.trx.node.AbstractResourceSession;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.cache.BufferManager;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ResourceStoreImpl<R extends ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx>>
implements ResourceStore<R> {
    private final Map<Path, R> resourceSessions = new ConcurrentHashMap<Path, R>();
    private final PathBasedPool<ResourceSession<?, ?>> allResourceSessions;
    private final ResourceSessionFactory<R> resourceSessionFactory;

    public ResourceStoreImpl(PathBasedPool<ResourceSession<?, ?>> allResourceSessions, ResourceSessionFactory<R> resourceSessionFactory) {
        this.allResourceSessions = allResourceSessions;
        this.resourceSessionFactory = resourceSessionFactory;
    }

    @Override
    public R beginResourceSession(@NonNull ResourceConfiguration resourceConfig, @NonNull BufferManager bufferManager, @NonNull Path resourceFile) {
        return (R)this.resourceSessions.computeIfAbsent(resourceFile, k -> {
            R resourceSession = this.resourceSessionFactory.create(resourceConfig, bufferManager, resourceFile);
            this.allResourceSessions.putObject(resourceFile, (ResourceSession<?, ?>)resourceSession);
            if (resourceSession.getMostRecentRevisionNumber() > 0) {
                ((AbstractResourceSession)resourceSession).createPageTrxPool();
            }
            return resourceSession;
        });
    }

    @Override
    public boolean hasOpenResourceSession(Path resourceFile) {
        Objects.requireNonNull(resourceFile);
        return this.resourceSessions.containsKey(resourceFile);
    }

    @Override
    public R getOpenResourceSession(Path resourceFile) {
        Objects.requireNonNull(resourceFile);
        return (R)((ResourceSession)this.resourceSessions.get(resourceFile));
    }

    @Override
    public void close() {
        this.resourceSessions.forEach((resourceName, resourceMgr) -> resourceMgr.close());
        this.resourceSessions.clear();
    }

    @Override
    public boolean closeResourceSession(Path resourceFile) {
        ResourceSession session = (ResourceSession)this.resourceSessions.remove(resourceFile);
        this.allResourceSessions.removeObject(resourceFile, session);
        return session != null;
    }
}

