/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ThreadSafe
public class WriteLocksRegistry {
    private static final Logger logger = LoggerFactory.getLogger(WriteLocksRegistry.class);
    private final Map<Path, Semaphore> locks = new ConcurrentHashMap<Path, Semaphore>();

    @Inject
    WriteLocksRegistry() {
    }

    public Semaphore getWriteLock(Path resourcePath) {
        logger.trace("Getting lock for resource with path {}", (Object)resourcePath);
        return this.locks.computeIfAbsent(resourcePath, res -> new Semaphore(1));
    }

    public void removeWriteLock(Path resourcePath) {
        logger.trace("Removing lock for resource with path {}", (Object)resourcePath);
        this.locks.remove(resourcePath);
    }
}

