/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx;

import io.sirix.api.NodeTrx;
import io.sirix.api.Transaction;
import io.sirix.api.TransactionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TransactionImpl
implements Transaction {
    private final List<NodeTrx> resourceTrxs = new ArrayList<NodeTrx>();
    private final TransactionManager trxMgr;

    public TransactionImpl(TransactionManager trxMgr) {
        this.trxMgr = Objects.requireNonNull(trxMgr);
    }

    @Override
    public Transaction commit() {
        NodeTrx trx;
        int i;
        boolean failure = false;
        for (i = 0; i < this.resourceTrxs.size() && !failure; ++i) {
            trx = this.resourceTrxs.get(i);
            try {
                trx.commit();
                continue;
            }
            catch (Exception e) {
                trx.rollback();
                failure = true;
            }
        }
        if (i < this.resourceTrxs.size()) {
            for (int j = 0; j < i; ++j) {
                trx = this.resourceTrxs.get(i);
                trx.truncateTo(trx.getRevisionNumber() - 1);
            }
            while (i < this.resourceTrxs.size()) {
                NodeTrx trx2 = this.resourceTrxs.get(i);
                trx2.rollback();
                ++i;
            }
        }
        this.resourceTrxs.clear();
        this.trxMgr.closeTransaction(this);
        return this;
    }

    @Override
    public Transaction rollback() {
        this.resourceTrxs.forEach(NodeTrx::rollback);
        this.resourceTrxs.clear();
        this.trxMgr.closeTransaction(this);
        return this;
    }

    @Override
    public void close() {
        this.rollback();
    }

    @Override
    public Transaction add(NodeTrx writer) {
        this.resourceTrxs.add(Objects.requireNonNull(writer));
        return this;
    }

    @Override
    public long getId() {
        return 0L;
    }
}

