/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.brackit.query.util.serialize.SubtreePrinter;
import io.sirix.access.trx.node.IndexController;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.exception.SirixRuntimeException;
import io.sirix.index.ChangeListener;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexType;
import io.sirix.index.Indexes;
import io.sirix.index.SearchMode;
import io.sirix.index.cas.CASFilter;
import io.sirix.index.cas.CASFilterRange;
import io.sirix.index.cas.CASIndex;
import io.sirix.index.name.NameFilter;
import io.sirix.index.name.NameIndex;
import io.sirix.index.path.PCRCollector;
import io.sirix.index.path.PathFilter;
import io.sirix.index.path.PathIndex;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractIndexController<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
implements IndexController<R, W> {
    protected final Indexes indexes;
    private final Set<ChangeListener> listeners;
    protected final PathIndex<?, ?> pathIndex;
    protected final CASIndex<?, ?, R> casIndex;
    protected final NameIndex<?, ?> nameIndex;

    public AbstractIndexController(Indexes indexes, Set<ChangeListener> listeners, PathIndex<?, ?> pathIndex, CASIndex<?, ?, R> casIndex, NameIndex<?, ?> nameIndex) {
        this.indexes = indexes;
        this.listeners = listeners;
        this.pathIndex = pathIndex;
        this.casIndex = casIndex;
        this.nameIndex = nameIndex;
    }

    @Override
    public boolean containsIndex(IndexType type) {
        for (IndexDef indexDef : this.indexes.getIndexDefs()) {
            if (indexDef.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public Indexes getIndexes() {
        return this.indexes;
    }

    @Override
    public void serialize(OutputStream out) {
        try {
            SubtreePrinter serializer = new SubtreePrinter(new PrintStream(Objects.requireNonNull(out)));
            serializer.print(this.indexes.materialize());
            serializer.end();
        }
        catch (DocumentException e) {
            throw new SirixRuntimeException(e);
        }
    }

    @Override
    public void notifyChange(IndexController.ChangeType type, @NonNull ImmutableNode node, long pathNodeKey) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ChangeListener listener : this.listeners) {
            listener.listen(type, node, pathNodeKey);
        }
    }

    @Override
    public IndexController<R, W> createIndexListeners(Set<IndexDef> indexDefs, W nodeWriteTrx) {
        Objects.requireNonNull(nodeWriteTrx);
        for (IndexDef indexDef : indexDefs) {
            this.indexes.add(indexDef);
            switch (indexDef.getType()) {
                case PATH: {
                    this.listeners.add(this.createPathIndexListener(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case CAS: {
                    this.listeners.add(this.createCASIndexListener(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case NAME: {
                    this.listeners.add(this.createNameIndexListener(nodeWriteTrx.getPageWtx(), indexDef));
                    break;
                }
            }
        }
        return this;
    }

    private ChangeListener createPathIndexListener(PageTrx pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return this.pathIndex.createListener(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private ChangeListener createCASIndexListener(PageTrx pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return this.casIndex.createListener(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private ChangeListener createNameIndexListener(PageTrx pageWriteTrx, IndexDef indexDef) {
        return this.nameIndex.createListener(pageWriteTrx, indexDef);
    }

    @Override
    public NameFilter createNameFilter(Set<String> names) {
        HashSet<QNm> includes = new HashSet<QNm>(names.size());
        for (String name : names) {
            includes.add(new QNm(name));
        }
        return new NameFilter(includes, Collections.emptySet());
    }

    @Override
    public CASFilter createCASFilter(Set<String> stringPaths, Atomic key, SearchMode mode, PCRCollector pcrCollector) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(stringPaths.size());
        if (!stringPaths.isEmpty()) {
            for (String path : stringPaths) {
                paths.add(this.parsePath(path));
            }
        }
        return new CASFilter(paths, key, mode, pcrCollector);
    }

    protected abstract Path<QNm> parsePath(String var1);

    @Override
    public CASFilterRange createCASFilterRange(Set<String> thePaths, Atomic min, Atomic max, boolean incMin, boolean incMax, PCRCollector pcrCollector) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(thePaths.size());
        if (!thePaths.isEmpty()) {
            for (String path : thePaths) {
                paths.add(this.parsePath(path));
            }
        }
        return new CASFilterRange(paths, min, max, incMin, incMax, pcrCollector);
    }

    @Override
    public Iterator<NodeReferences> openPathIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, PathFilter filter) {
        if (this.pathIndex == null) {
            throw new IllegalStateException("This document does not support path indexes.");
        }
        return this.pathIndex.openIndex(pageRtx, indexDef, filter);
    }

    @Override
    public Iterator<NodeReferences> openNameIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, NameFilter filter) {
        if (this.nameIndex == null) {
            throw new IllegalStateException("This document does not support name indexes.");
        }
        return this.nameIndex.openIndex(pageRtx, indexDef, filter);
    }

    @Override
    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, CASFilter filter) {
        if (this.casIndex == null) {
            throw new IllegalStateException("This document does not support CAS indexes.");
        }
        return this.casIndex.openIndex(pageRtx, indexDef, filter);
    }

    @Override
    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, CASFilterRange filter) {
        if (this.casIndex == null) {
            throw new IllegalStateException("This document does not support path indexes.");
        }
        return this.casIndex.openIndex(pageRtx, indexDef, filter);
    }
}

