/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.HashType;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexType;
import io.sirix.node.NodeKind;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.xml.ElementNode;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractNodeHashing<N extends ImmutableNode, T extends NodeCursor & NodeReadOnlyTrx> {
    private static final long PRIME = 77081L;
    private final HashType hashType;
    protected final T nodeReadOnlyTrx;
    private final PageTrx pageTrx;
    private boolean bulkInsert;
    private boolean autoCommit;
    private final Bytes<ByteBuffer> bytes = Bytes.elasticHeapByteBuffer();

    protected AbstractNodeHashing(ResourceConfiguration resourceConfig, T nodeReadOnlyTrx, PageTrx pageTrx) {
        this.hashType = resourceConfig.hashType;
        this.nodeReadOnlyTrx = nodeReadOnlyTrx;
        this.pageTrx = pageTrx;
    }

    public void setBulkInsert(boolean value) {
        this.bulkInsert = value;
    }

    public void setAutoCommit(boolean value) {
        this.autoCommit = value;
    }

    public void adaptHashesWithAdd() {
        if (!this.bulkInsert || this.autoCommit) {
            switch (this.hashType) {
                case ROLLING: {
                    this.rollingAdd();
                    break;
                }
                case POSTORDER: {
                    this.postorderAdd();
                    break;
                }
            }
        }
    }

    public void adaptHashesWithRemove() {
        if (!this.bulkInsert || this.autoCommit) {
            switch (this.hashType) {
                case ROLLING: {
                    this.rollingRemove();
                    break;
                }
                case POSTORDER: {
                    this.postorderRemove();
                    break;
                }
            }
        }
    }

    public void adaptHashedWithUpdate(long oldHash) {
        if (!this.bulkInsert || this.autoCommit) {
            switch (this.hashType) {
                case ROLLING: {
                    this.rollingUpdate(oldHash);
                    break;
                }
                case POSTORDER: {
                    this.postorderAdd();
                    break;
                }
            }
        }
    }

    private void postorderRemove() {
        ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getCurrentNode().getParentKey());
        this.postorderAdd();
    }

    private void postorderAdd() {
        StructNode cursorToRoot;
        N startNode = this.getCurrentNode();
        if (!(startNode instanceof StructNode)) {
            Node node = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
            node.setHash(this.getCurrentNode().computeHash(this.bytes));
            ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getCurrentNode().getParentKey());
        }
        do {
            cursorToRoot = (StructNode)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
            long hashCodeForParent = this.getCurrentNode().computeHash(this.bytes);
            if (cursorToRoot.getKind() == NodeKind.ELEMENT) {
                ElementNode currentElement = (ElementNode)cursorToRoot;
                int attCount = ((ElementNode)cursorToRoot).getAttributeCount();
                for (int i = 0; i < attCount; ++i) {
                    ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(currentElement.getAttributeKey(i));
                    hashCodeForParent = this.getCurrentNode().computeHash(this.bytes) + hashCodeForParent * 77081L;
                }
                int nspCount = ((ElementNode)cursorToRoot).getNamespaceCount();
                for (int i = 0; i < nspCount; ++i) {
                    ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(currentElement.getNamespaceKey(i));
                    hashCodeForParent = this.getCurrentNode().computeHash(this.bytes) + hashCodeForParent * 77081L;
                }
                ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(cursorToRoot.getNodeKey());
            }
            if (((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getStructuralNode().getFirstChildKey())) {
                do {
                    hashCodeForParent = this.getCurrentNode().getHash() + hashCodeForParent * 77081L;
                } while (((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getStructuralNode().getRightSiblingKey()));
                ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getStructuralNode().getParentKey());
            }
            cursorToRoot.setHash(hashCodeForParent);
        } while (((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(cursorToRoot.getParentKey()));
        this.setCurrentNode(startNode);
    }

    protected abstract StructNode getStructuralNode();

    protected abstract N getCurrentNode();

    protected abstract void setCurrentNode(N var1);

    private void rollingUpdate(long oldHash) {
        N newNode = this.getCurrentNode();
        long newHash = newNode.computeHash(this.bytes);
        do {
            long resultNew;
            Node node;
            if ((node = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1)).getNodeKey() == newNode.getNodeKey()) {
                resultNew = newHash;
            } else {
                resultNew = node.getHash() - oldHash * 77081L;
                resultNew += newHash * 77081L;
            }
            node.setHash(resultNew);
        } while (((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getCurrentNode().getParentKey()));
        this.setCurrentNode(newNode);
    }

    private void rollingRemove() {
        N startNode = this.getCurrentNode();
        long hashToRemove = startNode.getHash() == 0L ? startNode.computeHash(this.bytes) : startNode.getHash();
        long hashToAdd = 0L;
        do {
            long newHash;
            Node node;
            if ((node = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1)).getNodeKey() == startNode.getNodeKey()) {
                newHash = 0L;
            } else if (node.getNodeKey() == startNode.getParentKey()) {
                newHash = node.getHash() - hashToRemove * 77081L;
                hashToRemove = node.getHash();
                this.setRemoveDescendants((ImmutableNode)startNode);
            } else {
                newHash = node.getHash() - hashToRemove * 77081L;
                newHash += hashToAdd * 77081L;
                hashToRemove = node.getHash();
                this.setRemoveDescendants((ImmutableNode)startNode);
            }
            node.setHash(newHash);
            hashToAdd = newHash;
        } while (((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(this.getCurrentNode().getParentKey()));
        this.setCurrentNode(startNode);
    }

    private void setRemoveDescendants(ImmutableNode startNode) {
        assert (startNode != null);
        if (startNode instanceof StructNode) {
            StructNode startNodeAsStructNode = (StructNode)startNode;
            StructNode node = this.getStructuralNode();
            node.setDescendantCount(node.getDescendantCount() - startNodeAsStructNode.getDescendantCount() - 1L);
        }
    }

    private void rollingAdd() {
        Node node;
        long hashToAdd;
        N startNode = this.getCurrentNode();
        long oldDescendantCount = this.getStructuralNode().getDescendantCount();
        long descendantCount = oldDescendantCount == 0L ? 1L : oldDescendantCount + 1L;
        this.bytes.clear();
        long possibleOldHash = 0L;
        if (this.isValueNode(startNode)) {
            ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(startNode.getParentKey());
            hashToAdd = startNode.computeHash(this.bytes);
        } else if (startNode.getHash() == 0L) {
            hashToAdd = startNode.computeHash(this.bytes);
            ((Node)startNode).setHash(hashToAdd);
        } else {
            hashToAdd = startNode.getHash();
        }
        do {
            long newHash;
            if ((node = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1)).getNodeKey() == startNode.getNodeKey()) {
                newHash = hashToAdd;
            } else if (node.getNodeKey() == startNode.getParentKey()) {
                long newMultipliedHash = hashToAdd * 77081L;
                possibleOldHash = node.getHash();
                hashToAdd = newHash = possibleOldHash + newMultipliedHash;
                AbstractNodeHashing.setAddDescendants(startNode, node, descendantCount);
            } else {
                long oldMultipliedHash = possibleOldHash * 77081L;
                long newMultipliedHash = hashToAdd * 77081L;
                hashToAdd = newHash = node.getHash() - oldMultipliedHash + newMultipliedHash;
                possibleOldHash = node.getHash();
                AbstractNodeHashing.setAddDescendants(startNode, node, descendantCount);
            }
            node.setHash(newHash);
        } while (((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(node.getParentKey()));
        this.setCurrentNode(startNode);
    }

    private boolean isValueNode(N startNode) {
        return startNode.getKind() == NodeKind.STRING_VALUE || startNode.getKind() == NodeKind.OBJECT_STRING_VALUE || startNode.getKind() == NodeKind.BOOLEAN_VALUE || startNode.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE || startNode.getKind() == NodeKind.NUMBER_VALUE || startNode.getKind() == NodeKind.OBJECT_NUMBER_VALUE || startNode.getKind() == NodeKind.NULL_VALUE || startNode.getKind() == NodeKind.OBJECT_NULL_VALUE || startNode.getKind() == NodeKind.ATTRIBUTE || startNode.getKind() == NodeKind.TEXT || startNode.getKind() == NodeKind.COMMENT || startNode.getKind() == NodeKind.PROCESSING_INSTRUCTION;
    }

    public void addParentHash(ImmutableNode startNode) {
        switch (this.hashType) {
            case ROLLING: {
                long hashToAdd = startNode.computeHash(this.bytes);
                Node parentNode = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
                long hash = parentNode.getHash();
                parentNode.setHash(hash + hashToAdd * 77081L);
                if (!(startNode instanceof StructNode)) break;
                StructNode startAsStructNode = (StructNode)startNode;
                StructNode parentNodeAsStructNode = (StructNode)parentNode;
                parentNodeAsStructNode.setDescendantCount(parentNodeAsStructNode.getDescendantCount() + startAsStructNode.getDescendantCount() + 1L);
                break;
            }
            case POSTORDER: {
                break;
            }
        }
    }

    public void addHashAndDescendantCount() {
        switch (this.hashType) {
            case ROLLING: {
                N startNode = this.getCurrentNode();
                long oldDescendantCount = this.getStructuralNode().getDescendantCount();
                long descendantCount = oldDescendantCount == 0L ? 1L : oldDescendantCount + 1L;
                long hashToAdd = startNode.getHash() == 0L ? startNode.computeHash(this.bytes) : startNode.getHash() + startNode.computeHash(this.bytes);
                Node node = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
                node.setHash(hashToAdd);
                if (startNode.hasParent()) {
                    ((NodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(startNode.getParentKey());
                    node = (Node)this.pageTrx.prepareRecordForModification(this.getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
                    long currentNodeHash = node.getHash();
                    long hash = currentNodeHash == 0L ? node.computeHash(this.bytes) : currentNodeHash;
                    node.setHash(hash + hashToAdd * 77081L);
                    AbstractNodeHashing.setAddDescendants(startNode, node, descendantCount);
                }
                this.setCurrentNode(startNode);
                break;
            }
            case POSTORDER: {
                this.postorderAdd();
                break;
            }
        }
    }

    private static void setAddDescendants(ImmutableNode startNode, Node nodeToModify, @NonNegative long descendantCount) {
        assert (startNode != null);
        assert (nodeToModify != null);
        if (startNode instanceof StructNode) {
            StructNode node = (StructNode)nodeToModify;
            long oldDescendantCount = node.getDescendantCount();
            node.setDescendantCount(oldDescendantCount + descendantCount);
        }
    }

    public boolean isBulkInsert() {
        return this.bulkInsert;
    }
}

