/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import io.sirix.access.User;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.access.trx.node.InternalNodeReadOnlyTrx;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.api.ItemList;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.ResourceSession;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexType;
import io.sirix.node.NodeKind;
import io.sirix.node.NullNode;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.json.ArrayNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.settings.Fixed;
import io.sirix.utils.NamePageHash;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractNodeReadOnlyTrx<T extends NodeCursor & NodeReadOnlyTrx, W extends NodeTrx & NodeCursor, N extends ImmutableNode>
implements InternalNodeReadOnlyTrx<N>,
NodeCursor,
NodeReadOnlyTrx {
    protected final long id;
    protected PageReadOnlyTrx pageReadOnlyTrx;
    private N currentNode;
    protected final InternalResourceSession<T, W> resourceSession;
    private volatile boolean isClosed;
    protected final ItemList<AtomicValue> itemList;

    protected AbstractNodeReadOnlyTrx(@NonNegative long trxId, @NonNull PageReadOnlyTrx pageReadTransaction, @NonNull N documentNode, InternalResourceSession<T, W> resourceSession, ItemList<AtomicValue> itemList) {
        this.itemList = itemList;
        this.resourceSession = Objects.requireNonNull(resourceSession);
        this.id = trxId;
        this.pageReadOnlyTrx = Objects.requireNonNull(pageReadTransaction);
        this.currentNode = (ImmutableNode)Objects.requireNonNull(documentNode);
        this.isClosed = false;
    }

    @Override
    public N getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(@Nullable N currentNode) {
        this.assertNotClosed();
        this.currentNode = currentNode;
    }

    @Override
    public boolean storeDeweyIDs() {
        return this.resourceSession.getResourceConfig().areDeweyIDsStored;
    }

    @Override
    public ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> getResourceSession() {
        return this.resourceSession;
    }

    @Override
    public Optional<User> getUser() {
        return this.pageReadOnlyTrx.getActualRevisionRootPage().getUser();
    }

    @Override
    public boolean moveToPrevious() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasLeftSibling()) {
            boolean leftSiblMove = this.moveTo(node.getLeftSiblingKey());
            while (this.hasFirstChild()) {
                leftSiblMove = this.moveToLastChild();
            }
            return leftSiblMove;
        }
        return this.moveTo(node.getParentKey());
    }

    @Override
    public NodeKind getLeftSiblingKind() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node instanceof StructNode && this.hasLeftSibling()) {
            this.moveToLeftSibling();
            NodeKind leftSiblingKind = this.currentNode.getKind();
            this.setCurrentNode(node);
            return leftSiblingKind;
        }
        return NodeKind.UNKNOWN;
    }

    @Override
    public long getLeftSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getLeftSiblingKey();
    }

    @Override
    public boolean hasLeftSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLeftSibling();
    }

    @Override
    public boolean moveToLeftSibling() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (!node.hasLeftSibling()) {
            return false;
        }
        return this.moveTo(node.getLeftSiblingKey());
    }

    @Override
    public int keyForName(String name) {
        this.assertNotClosed();
        return NamePageHash.generateHashForString(name);
    }

    @Override
    public String nameForKey(int key) {
        this.assertNotClosed();
        return this.pageReadOnlyTrx.getName(key, this.currentNode.getKind());
    }

    @Override
    public long getPathNodeKey() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node instanceof NameNode) {
            return ((NameNode)node).getPathNodeKey();
        }
        if (node instanceof ObjectKeyNode) {
            ObjectKeyNode objectKeyNode = (ObjectKeyNode)node;
            return objectKeyNode.getPathNodeKey();
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            return arrayNode.getPathNodeKey();
        }
        if (node.getKind() == NodeKind.XML_DOCUMENT || node.getKind() == NodeKind.JSON_DOCUMENT) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public long getId() {
        this.assertNotClosed();
        return this.id;
    }

    @Override
    public int getRevisionNumber() {
        this.assertNotClosed();
        return this.pageReadOnlyTrx.getActualRevisionRootPage().getRevision();
    }

    @Override
    public Instant getRevisionTimestamp() {
        this.assertNotClosed();
        return Instant.ofEpochMilli(this.pageReadOnlyTrx.getActualRevisionRootPage().getRevisionTimestamp());
    }

    @Override
    public boolean moveToDocumentRoot() {
        this.assertNotClosed();
        return this.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
    }

    @Override
    public boolean moveToParent() {
        this.assertNotClosed();
        return this.moveTo(this.currentNode.getParentKey());
    }

    @Override
    public boolean moveToFirstChild() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (!node.hasFirstChild()) {
            return false;
        }
        return this.moveTo(node.getFirstChildKey());
    }

    @Override
    public boolean moveTo(long nodeKey) {
        AtomicValue newNode;
        this.assertNotClosed();
        N oldNode = this.currentNode;
        try {
            newNode = nodeKey < 0L ? (this.itemList.size() > 0 ? this.itemList.getItem(nodeKey) : null) : (AtomicValue)this.pageReadOnlyTrx.getRecord(nodeKey, IndexType.DOCUMENT, -1);
        }
        catch (SirixIOException | UncheckedIOException | IllegalArgumentException e) {
            newNode = null;
        }
        if (newNode == null) {
            this.setCurrentNode(oldNode);
            return false;
        }
        this.setCurrentNode((ImmutableNode)newNode);
        return true;
    }

    @Override
    public boolean moveToRightSibling() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (!node.hasRightSibling()) {
            return false;
        }
        return this.moveTo(node.getRightSiblingKey());
    }

    @Override
    public long getNodeKey() {
        this.assertNotClosed();
        return this.currentNode.getNodeKey();
    }

    @Override
    public long getHash() {
        this.assertNotClosed();
        return this.currentNode.getHash();
    }

    @Override
    public NodeKind getKind() {
        this.assertNotClosed();
        return this.currentNode.getKind();
    }

    @Override
    public void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Transaction is already closed.");
        }
    }

    public PageReadOnlyTrx getPageTransaction() {
        this.assertNotClosed();
        return this.pageReadOnlyTrx;
    }

    @Override
    public final void setPageReadTransaction(@Nullable PageReadOnlyTrx pageReadTransaction) {
        this.assertNotClosed();
        this.pageReadOnlyTrx = pageReadTransaction;
    }

    @Override
    public final long getMaxNodeKey() {
        this.assertNotClosed();
        return this.pageReadOnlyTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex();
    }

    @Override
    public final StructNode getStructuralNode() {
        N node = this.getCurrentNode();
        if (node instanceof StructNode) {
            return (StructNode)node;
        }
        return new NullNode((ImmutableNode)node);
    }

    @Override
    public boolean moveToNextFollowing() {
        this.assertNotClosed();
        while (!this.getStructuralNode().hasRightSibling() && this.currentNode.hasParent()) {
            this.moveToParent();
        }
        return this.moveToRightSibling();
    }

    @Override
    public boolean hasNode(@NonNegative long key) {
        this.assertNotClosed();
        N node = this.currentNode;
        boolean retVal = this.moveTo(key);
        this.setCurrentNode(node);
        return retVal;
    }

    @Override
    public boolean hasParent() {
        this.assertNotClosed();
        return this.currentNode.hasParent();
    }

    @Override
    public boolean hasFirstChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasRightSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasRightSibling();
    }

    @Override
    public long getRightSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getRightSiblingKey();
    }

    @Override
    public long getFirstChildKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getFirstChildKey();
    }

    @Override
    public long getParentKey() {
        this.assertNotClosed();
        return this.currentNode.getParentKey();
    }

    @Override
    public NodeKind getParentKind() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node.getParentKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return NodeKind.UNKNOWN;
        }
        this.moveToParent();
        NodeKind parentKind = this.currentNode.getKind();
        this.setCurrentNode(node);
        return parentKind;
    }

    @Override
    public boolean moveToNext() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasRightSibling()) {
            return this.moveTo(node.getRightSiblingKey());
        }
        return this.moveToNextFollowing();
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public NodeKind getLastChildKind() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node instanceof StructNode && this.hasLastChild()) {
            this.moveToLastChild();
            NodeKind lastChildKind = this.currentNode.getKind();
            this.setCurrentNode(node);
            return lastChildKind;
        }
        return NodeKind.UNKNOWN;
    }

    @Override
    public NodeKind getFirstChildKind() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node instanceof StructNode && this.hasFirstChild()) {
            this.moveToFirstChild();
            NodeKind firstChildKind = this.currentNode.getKind();
            this.setCurrentNode(node);
            return firstChildKind;
        }
        return NodeKind.UNKNOWN;
    }

    @Override
    public long getLastChildKey() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node instanceof StructNode && this.hasLastChild()) {
            long nodeKey = node.getNodeKey();
            this.moveToLastChild();
            long lastChildNodeKey = this.currentNode.getNodeKey();
            this.moveTo(nodeKey);
            return lastChildNodeKey;
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getChildCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getChildCount();
    }

    @Override
    public boolean hasChildren() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public long getDescendantCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getDescendantCount();
    }

    @Override
    public NodeKind getPathKind() {
        this.assertNotClosed();
        return NodeKind.UNKNOWN;
    }

    @Override
    public NodeKind getRightSiblingKind() {
        this.assertNotClosed();
        N node = this.currentNode;
        if (node instanceof StructNode && this.hasRightSibling()) {
            this.moveToRightSibling();
            NodeKind rightSiblingKind = this.currentNode.getKind();
            this.setCurrentNode(node);
            return rightSiblingKind;
        }
        return NodeKind.UNKNOWN;
    }

    @Override
    public PageReadOnlyTrx getPageTrx() {
        this.assertNotClosed();
        return this.pageReadOnlyTrx;
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.assertNotClosed();
        return this.pageReadOnlyTrx.getCommitCredentials();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        this.assertNotClosed();
        return this.currentNode.getDeweyID();
    }

    @Override
    public int getPreviousRevisionNumber() {
        this.assertNotClosed();
        return this.currentNode.getPreviousRevisionNumber();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            this.pageReadOnlyTrx.close();
            this.resourceSession.closeReadTransaction(this.id);
            this.setPageReadTransaction(null);
            this.pageReadOnlyTrx = null;
            this.currentNode = null;
            this.isClosed = true;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNodeReadOnlyTrx that = (AbstractNodeReadOnlyTrx)o;
        return this.currentNode.getNodeKey() == that.currentNode.getNodeKey() && this.pageReadOnlyTrx.getRevisionNumber() == that.pageReadOnlyTrx.getRevisionNumber();
    }

    public int hashCode() {
        return Objects.hash(this.currentNode.getNodeKey(), this.pageReadOnlyTrx.getRevisionNumber());
    }
}

