/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import cn.danielw.fop.ObjectFactory;
import cn.danielw.fop.ObjectPool;
import cn.danielw.fop.PoolConfig;
import cn.danielw.fop.PoolExhaustedException;
import cn.danielw.fop.PoolInvalidObjectException;
import cn.danielw.fop.Poolable;
import com.google.common.base.Preconditions;
import io.brackit.query.jdm.DocumentException;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.ResourceStore;
import io.sirix.access.User;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.access.trx.node.IndexController;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.page.NodePageReadOnlyTrx;
import io.sirix.access.trx.page.PageTrxFactory;
import io.sirix.access.trx.page.PageTrxReadOnlyFactory;
import io.sirix.access.trx.page.RevisionRootPageReader;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.ResourceSession;
import io.sirix.api.RevisionInfo;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.cache.BufferManager;
import io.sirix.cache.Cache;
import io.sirix.cache.RBIndexKey;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixIOException;
import io.sirix.exception.SirixThreadedException;
import io.sirix.exception.SirixUsageException;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.Writer;
import io.sirix.node.interfaces.Node;
import io.sirix.page.UberPage;
import io.sirix.settings.Fixed;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceSession<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
implements ResourceSession<R, W>,
InternalResourceSession<R, W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceSession.class);
    final Semaphore writeLock;
    final AtomicReference<UberPage> lastCommittedUberPage;
    final ConcurrentMap<Long, R> nodeTrxMap;
    final ConcurrentMap<Long, PageReadOnlyTrx> pageTrxMap;
    final ConcurrentMap<Long, PageTrx> nodePageTrxMap;
    private final Lock commitLock;
    final ResourceConfiguration resourceConfig;
    final IOStorage storage;
    private final AtomicLong nodeTrxIDCounter;
    final AtomicLong pageTrxIDCounter;
    private final AtomicReference<ObjectPool<PageReadOnlyTrx>> pool;
    volatile boolean isClosed;
    final BufferManager bufferManager;
    final ResourceStore<? extends ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx>> resourceStore;
    final User user;
    private final PageTrxFactory pageTrxFactory;
    private final String ID_GENERATION_EXCEPTION = "ID generation is bogus because of duplicate ID.";

    protected AbstractResourceSession(@NonNull ResourceStore<? extends ResourceSession<R, W>> resourceStore, @NonNull ResourceConfiguration resourceConf, @NonNull BufferManager bufferManager, @NonNull IOStorage storage, @NonNull UberPage uberPage, @NonNull Semaphore writeLock, @Nullable User user, PageTrxFactory pageTrxFactory) {
        this.resourceStore = Objects.requireNonNull(resourceStore);
        this.resourceConfig = Objects.requireNonNull(resourceConf);
        this.bufferManager = Objects.requireNonNull(bufferManager);
        this.storage = Objects.requireNonNull(storage);
        this.pageTrxFactory = pageTrxFactory;
        this.nodeTrxMap = new ConcurrentHashMap<Long, R>();
        this.pageTrxMap = new ConcurrentHashMap<Long, PageReadOnlyTrx>();
        this.nodePageTrxMap = new ConcurrentHashMap<Long, PageTrx>();
        this.nodeTrxIDCounter = new AtomicLong();
        this.pageTrxIDCounter = new AtomicLong();
        this.commitLock = new ReentrantLock(false);
        this.writeLock = Objects.requireNonNull(writeLock);
        this.lastCommittedUberPage = new AtomicReference<UberPage>(uberPage);
        this.user = user;
        this.pool = new AtomicReference();
        this.isClosed = false;
    }

    public void createPageTrxPool() {
        if (this.pool.get() == null) {
            PoolConfig config = new PoolConfig();
            config.setPartitionSize(3);
            config.setMaxSize(10);
            config.setMinSize(5);
            config.setScavengeIntervalMilliseconds(60000);
            config.setMaxIdleMilliseconds(5);
            config.setMaxWaitMilliseconds(5);
            config.setShutdownWaitMilliseconds(1);
            this.pool.set((ObjectPool<PageReadOnlyTrx>)new ObjectPool(config, (ObjectFactory)new PageTrxReadOnlyFactory(this)));
        }
    }

    private static long timeDiff(long lhs, long rhs) {
        return Math.abs(lhs - rhs);
    }

    protected void initializeIndexController(int revision, IndexController<?, ?> controller) {
        Path indexes = this.getResourceConfig().getResource().resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(revision + ".xml");
        if (Files.exists(indexes, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(indexes.toFile());){
                controller.getIndexes().init(IndexController.deserialize(in).getFirstChild());
            }
            catch (DocumentException | SirixException | IOException e) {
                throw new SirixIOException("Index definitions couldn't be deserialized!", e);
            }
        }
    }

    @Override
    public Cache<RBIndexKey, Node> getIndexCache() {
        return this.bufferManager.getIndexCache();
    }

    @Override
    public PageTrx createPageTransaction(@NonNegative long id, @NonNegative int representRevision, @NonNegative int storedRevision, InternalResourceSession.Abort abort, boolean isBoundToNodeTrx) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"id must be >= 0!");
        Preconditions.checkArgument((representRevision >= 0 ? 1 : 0) != 0, (Object)"representRevision must be >= 0!");
        Preconditions.checkArgument((storedRevision >= 0 ? 1 : 0) != 0, (Object)"storedRevision must be >= 0!");
        Writer writer = this.storage.createWriter();
        UberPage lastCommittedUberPage = this.lastCommittedUberPage.get();
        int lastCommittedRev = lastCommittedUberPage.getRevisionNumber();
        PageTrx pageTrx = this.pageTrxFactory.createPageTrx(this, abort == InternalResourceSession.Abort.YES && lastCommittedUberPage.isBootstrap() ? new UberPage() : new UberPage(lastCommittedUberPage), writer, id, representRevision, storedRevision, lastCommittedRev, isBoundToNodeTrx, this.bufferManager);
        this.truncateToLastSuccessfullyCommittedRevisionIfCommitLockFileExists(writer, lastCommittedRev, pageTrx);
        return pageTrx;
    }

    private void truncateToLastSuccessfullyCommittedRevisionIfCommitLockFileExists(Writer writer, int lastCommittedRev, PageTrx pageTrx) {
        if (Files.exists(this.getCommitFile(), new LinkOption[0])) {
            writer.truncateTo(pageTrx, lastCommittedRev);
        }
    }

    @Override
    public List<RevisionInfo> getHistory() {
        return this.getHistoryInformations(Integer.MAX_VALUE);
    }

    @Override
    public List<RevisionInfo> getHistory(int revisions) {
        return this.getHistoryInformations(revisions);
    }

    @Override
    public List<RevisionInfo> getHistory(int fromRevision, int toRevision) {
        this.assertAccess(fromRevision);
        this.assertAccess(toRevision);
        Preconditions.checkArgument((fromRevision > toRevision ? 1 : 0) != 0);
        ArrayList<CompletableFuture<RevisionInfo>> revisionInfos = new ArrayList<CompletableFuture<RevisionInfo>>();
        int revision = fromRevision;
        while (revision > 0 && revision >= toRevision) {
            int finalRevision = revision--;
            revisionInfos.add(CompletableFuture.supplyAsync(() -> {
                try (R rtx = this.beginNodeReadOnlyTrx(finalRevision);){
                    CommitCredentials commitCredentials = rtx.getCommitCredentials();
                    RevisionInfo revisionInfo = new RevisionInfo(commitCredentials.getUser(), rtx.getRevisionNumber(), rtx.getRevisionTimestamp(), commitCredentials.getMessage());
                    return revisionInfo;
                }
            }));
        }
        return this.getResult(revisionInfos);
    }

    private List<RevisionInfo> getHistoryInformations(int revisions) {
        Preconditions.checkArgument((revisions > 0 ? 1 : 0) != 0);
        int lastCommittedRevision = this.getMostRecentRevisionNumber();
        ArrayList<CompletableFuture<RevisionInfo>> revisionInfos = new ArrayList<CompletableFuture<RevisionInfo>>();
        int revision = lastCommittedRevision;
        while (revision > 0 && revision > lastCommittedRevision - revisions) {
            int finalRevision = revision--;
            revisionInfos.add(CompletableFuture.supplyAsync(() -> {
                try (R rtx = this.beginNodeReadOnlyTrx(finalRevision);){
                    CommitCredentials commitCredentials = rtx.getCommitCredentials();
                    RevisionInfo revisionInfo = new RevisionInfo(commitCredentials.getUser(), rtx.getRevisionNumber(), rtx.getRevisionTimestamp(), commitCredentials.getMessage());
                    return revisionInfo;
                }
            }));
        }
        return this.getResult(revisionInfos);
    }

    private List<RevisionInfo> getResult(List<CompletableFuture<RevisionInfo>> revisionInfos) {
        return revisionInfos.stream().map(CompletableFuture::join).toList();
    }

    @Override
    public Path getResourcePath() {
        this.assertNotClosed();
        return this.resourceConfig.resourcePath;
    }

    @Override
    public Lock getCommitLock() {
        this.assertNotClosed();
        return this.commitLock;
    }

    @Override
    public synchronized R beginNodeReadOnlyTrx(@NonNegative int revision) {
        this.assertAccess(revision);
        PageReadOnlyTrx pageReadTrx = this.beginPageReadOnlyTrx(revision);
        Node documentNode = AbstractResourceSession.getDocumentNode(pageReadTrx);
        R reader = this.createNodeReadOnlyTrx(this.nodeTrxIDCounter.incrementAndGet(), pageReadTrx, documentNode);
        if (this.nodeTrxMap.put(reader.getId(), reader) != null) {
            throw new SirixUsageException(new String[]{"ID generation is bogus because of duplicate ID."});
        }
        return reader;
    }

    public abstract R createNodeReadOnlyTrx(long var1, PageReadOnlyTrx var3, Node var4);

    public abstract W createNodeReadWriteTrx(long var1, PageTrx var3, int var4, Duration var5, Node var6, AfterCommitState var7);

    static Node getDocumentNode(PageReadOnlyTrx pageReadTrx) {
        Node node = (Node)pageReadTrx.getRecord(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), IndexType.DOCUMENT, -1);
        if (node == null) {
            pageReadTrx.close();
            throw new IllegalStateException("Node couldn't be fetched from persistent storage!");
        }
        return node;
    }

    @Override
    public Path getCommitFile() {
        return this.resourceConfig.resourcePath.resolve(ResourceConfiguration.ResourcePaths.TRANSACTION_INTENT_LOG.getPath()).resolve(".commit");
    }

    @Override
    public W beginNodeTrx() {
        return this.beginNodeTrx(0, 0, TimeUnit.MILLISECONDS, AfterCommitState.KEEP_OPEN);
    }

    @Override
    public W beginNodeTrx(@NonNegative int maxNodeCount) {
        return this.beginNodeTrx(maxNodeCount, 0, TimeUnit.MILLISECONDS, AfterCommitState.KEEP_OPEN);
    }

    @Override
    public W beginNodeTrx(@NonNegative int maxTime, @NonNull TimeUnit timeUnit) {
        return this.beginNodeTrx(0, maxTime, timeUnit, AfterCommitState.KEEP_OPEN);
    }

    @Override
    public W beginNodeTrx(@NonNegative int maxNodeCount, @NonNegative int maxTime, @NonNull TimeUnit timeUnit) {
        return this.beginNodeTrx(maxNodeCount, maxTime, timeUnit, AfterCommitState.KEEP_OPEN);
    }

    @Override
    public W beginNodeTrx(@NonNull AfterCommitState afterCommitState) {
        return this.beginNodeTrx(0, 0, TimeUnit.MILLISECONDS, afterCommitState);
    }

    @Override
    public W beginNodeTrx(@NonNegative int maxNodeCount, @NonNull AfterCommitState afterCommitState) {
        return this.beginNodeTrx(maxNodeCount, 0, TimeUnit.MILLISECONDS);
    }

    @Override
    public W beginNodeTrx(@NonNegative int maxTime, @NonNull TimeUnit timeUnit, @NonNull AfterCommitState afterCommitState) {
        return this.beginNodeTrx(0, maxTime, timeUnit, afterCommitState);
    }

    @Override
    public synchronized W beginNodeTrx(@NonNegative int maxNodeCount, @NonNegative int maxTime, @NonNull TimeUnit timeUnit, @NonNull AfterCommitState afterCommitState) {
        this.assertAccess(this.getMostRecentRevisionNumber());
        if (maxNodeCount < 0 || maxTime < 0) {
            throw new SirixUsageException(new String[]{"maxNodeCount may not be < 0!"});
        }
        Objects.requireNonNull(timeUnit);
        try {
            if (!this.writeLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No read-write transaction available, please close the running read-write transaction first."});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        LOGGER.trace("Lock: lock acquired (beginNodeTrx)");
        long nodeTrxId = this.nodeTrxIDCounter.incrementAndGet();
        int lastRev = this.getMostRecentRevisionNumber();
        PageTrx pageWtx = this.createPageTransaction(nodeTrxId, lastRev, lastRev, InternalResourceSession.Abort.NO, true);
        Node documentNode = AbstractResourceSession.getDocumentNode(pageWtx);
        Duration autoCommitDelay = Duration.of(maxTime, timeUnit.toChronoUnit());
        W wtx = this.createNodeReadWriteTrx(nodeTrxId, pageWtx, maxNodeCount, autoCommitDelay, documentNode, afterCommitState);
        if (this.nodeTrxMap.put(nodeTrxId, wtx) != null || this.nodePageTrxMap.put(nodeTrxId, pageWtx) != null) {
            throw new SirixThreadedException("ID generation is bogus because of duplicate ID.");
        }
        return wtx;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            for (AutoCloseable rtx : this.nodeTrxMap.values()) {
                if (rtx instanceof XmlNodeTrx) {
                    XmlNodeTrx xmlNodeTrx = (XmlNodeTrx)rtx;
                    xmlNodeTrx.rollback();
                } else if (rtx instanceof JsonNodeTrx) {
                    JsonNodeTrx jsonNodeTrx = (JsonNodeTrx)rtx;
                    jsonNodeTrx.rollback();
                }
                rtx.close();
            }
            for (AutoCloseable rtx : this.nodePageTrxMap.values()) {
                rtx.close();
            }
            for (AutoCloseable rtx : this.pageTrxMap.values()) {
                rtx.close();
            }
            this.nodeTrxMap.clear();
            this.pageTrxMap.clear();
            this.nodePageTrxMap.clear();
            this.resourceStore.closeResourceSession(this.resourceConfig.getResource());
            this.storage.close();
            if (this.pool.get() != null) {
                try {
                    this.pool.get().shutdown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.isClosed = true;
        }
    }

    @Override
    public void assertAccess(@NonNegative int revision) {
        this.assertNotClosed();
        if (revision > this.getMostRecentRevisionNumber()) {
            throw new IllegalArgumentException("Revision must not be bigger than " + Long.toString(this.getMostRecentRevisionNumber()) + "!");
        }
    }

    public String toString() {
        return "ResourceManager{resourceConfig=" + String.valueOf(this.resourceConfig) + ", isClosed=" + this.isClosed + "}";
    }

    private void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Resource manager is already closed!");
        }
    }

    @Override
    public boolean hasRunningNodeWriteTrx() {
        this.assertNotClosed();
        if (this.writeLock.tryAcquire()) {
            this.writeLock.release();
            return false;
        }
        return true;
    }

    @Override
    public void setNodePageWriteTransaction(@NonNegative long transactionID, @NonNull PageTrx pageTrx) {
        this.assertNotClosed();
        this.nodePageTrxMap.put(transactionID, pageTrx);
    }

    @Override
    public void closeNodePageWriteTransaction(@NonNegative long transactionID) {
        this.assertNotClosed();
        PageReadOnlyTrx pageRtx = (PageReadOnlyTrx)this.nodePageTrxMap.remove(transactionID);
        if (pageRtx != null) {
            pageRtx.close();
        }
    }

    @Override
    public void closeWriteTransaction(@NonNegative long transactionID) {
        this.assertNotClosed();
        this.removeFromPageMapping(transactionID);
        LOGGER.trace("Lock unlock (closeWriteTransaction).");
        this.writeLock.release();
    }

    @Override
    public void closeReadTransaction(@NonNegative long transactionID) {
        this.assertNotClosed();
        this.removeFromPageMapping(transactionID);
    }

    @Override
    public void closePageWriteTransaction(@NonNegative Long transactionID) {
        this.assertNotClosed();
        this.pageTrxMap.remove(transactionID);
        LOGGER.trace("Lock unlock (closePageWriteTransaction).");
        this.writeLock.release();
    }

    @Override
    public void closePageReadTransaction(@NonNegative Long transactionID) {
        this.assertNotClosed();
        this.pageTrxMap.remove(transactionID);
    }

    private void removeFromPageMapping(@NonNegative Long transactionID) {
        this.assertNotClosed();
        this.nodeTrxMap.remove(transactionID);
        this.nodePageTrxMap.remove(transactionID);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setLastCommittedUberPage(UberPage page) {
        this.assertNotClosed();
        this.lastCommittedUberPage.set(Objects.requireNonNull(page));
    }

    @Override
    public ResourceConfiguration getResourceConfig() {
        this.assertNotClosed();
        return this.resourceConfig;
    }

    @Override
    public int getMostRecentRevisionNumber() {
        this.assertNotClosed();
        return this.lastCommittedUberPage.get().getRevisionNumber();
    }

    @Override
    public synchronized PathSummaryReader openPathSummary(@NonNegative int revision) {
        PageReadOnlyTrx pageReadOnlyTrx;
        this.assertAccess(revision);
        ObjectPool<PageReadOnlyTrx> pool = this.pool.get();
        if (pool != null) {
            Poolable poolable = null;
            boolean invalidObject = true;
            while (invalidObject) {
                try {
                    poolable = pool.borrowObject(false);
                    invalidObject = false;
                }
                catch (PoolInvalidObjectException poolInvalidObjectException) {
                }
                catch (PoolExhaustedException exception) {
                    invalidObject = false;
                }
            }
            if (poolable == null) {
                pageReadOnlyTrx = this.beginPageReadOnlyTrx(revision);
            } else {
                pageReadOnlyTrx = (PageReadOnlyTrx)poolable.getObject();
                if (pageReadOnlyTrx.getRevisionNumber() != revision) {
                    pool.returnObject(poolable);
                    pageReadOnlyTrx = this.beginPageReadOnlyTrx(revision);
                }
            }
        } else {
            pageReadOnlyTrx = this.beginPageReadOnlyTrx(revision);
        }
        return PathSummaryReader.getInstance(pageReadOnlyTrx, this);
    }

    @Override
    public PageReadOnlyTrx beginPageReadOnlyTrx(@NonNegative int revision) {
        this.assertAccess(revision);
        long currentPageTrxID = this.pageTrxIDCounter.incrementAndGet();
        NodePageReadOnlyTrx pageReadTrx = new NodePageReadOnlyTrx(currentPageTrxID, this, this.lastCommittedUberPage.get(), revision, this.storage.createReader(), this.bufferManager, new RevisionRootPageReader(), null);
        if (this.pageTrxMap.put(currentPageTrxID, pageReadTrx) != null) {
            throw new SirixThreadedException("ID generation is bogus because of duplicate ID.");
        }
        return pageReadTrx;
    }

    @Override
    public synchronized PageTrx beginPageTrx(@NonNegative int revision) {
        this.assertAccess(revision);
        try {
            if (!this.writeLock.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No write transaction available, please close the write transaction first."});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        LOGGER.debug("Lock: lock acquired (beginPageTrx)");
        long currentPageTrxID = this.pageTrxIDCounter.incrementAndGet();
        int lastRev = this.getMostRecentRevisionNumber();
        PageTrx pageTrx = this.createPageTransaction(currentPageTrxID, lastRev, lastRev, InternalResourceSession.Abort.NO, false);
        if (this.pageTrxMap.put(currentPageTrxID, pageTrx) != null) {
            throw new SirixThreadedException("ID generation is bogus because of duplicate ID.");
        }
        return pageTrx;
    }

    @Override
    public Optional<R> getNodeReadTrxByTrxId(Long ID) {
        this.assertNotClosed();
        return Optional.ofNullable((NodeReadOnlyTrx)this.nodeTrxMap.get(ID));
    }

    @Override
    public synchronized Optional<W> getNodeTrx() {
        this.assertNotClosed();
        return this.nodeTrxMap.values().stream().filter(arg_0 -> AbstractResourceSession.lambda$getNodeTrx$2(NodeTrx.class, arg_0)).map(rtx -> (NodeTrx)rtx).findAny();
    }

    @Override
    public R beginNodeReadOnlyTrx(@NonNull Instant pointInTime) {
        Objects.requireNonNull(pointInTime);
        this.assertNotClosed();
        long timestamp = pointInTime.toEpochMilli();
        int revision = this.binarySearch(timestamp);
        if (revision < 0) {
            revision = -revision - 1;
        }
        if (revision == 0) {
            return this.beginNodeReadOnlyTrx(0);
        }
        if (revision == this.getMostRecentRevisionNumber() + 1) {
            return this.beginNodeReadOnlyTrx();
        }
        R rtxRevisionMinus1 = this.beginNodeReadOnlyTrx(revision - 1);
        R rtxRevision = this.beginNodeReadOnlyTrx(revision);
        if (AbstractResourceSession.timeDiff(timestamp, rtxRevisionMinus1.getRevisionTimestamp().toEpochMilli()) < AbstractResourceSession.timeDiff(timestamp, rtxRevision.getRevisionTimestamp().toEpochMilli())) {
            rtxRevision.close();
            return rtxRevisionMinus1;
        }
        rtxRevisionMinus1.close();
        return rtxRevision;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int binarySearch(long timestamp) {
        int low = 0;
        int high = this.getMostRecentRevisionNumber();
        try (Reader reader = this.storage.createReader();){
            while (low <= high) {
                int mid = low + high >>> 1;
                Instant midVal = reader.readRevisionRootPageCommitTimestamp(mid);
                int cmp = midVal.compareTo(Instant.ofEpochMilli(timestamp));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) {
                    int n = mid;
                    return n;
                }
                high = mid - 1;
            }
            return -(low + 1);
        }
    }

    @Override
    public int getRevisionNumber(@NonNull Instant pointInTime) {
        Objects.requireNonNull(pointInTime);
        this.assertNotClosed();
        long timestamp = pointInTime.toEpochMilli();
        int revision = this.binarySearch(timestamp);
        if (revision < 0) {
            revision = -revision - 1;
        }
        if (revision == 0) {
            return 0;
        }
        if (revision == this.getMostRecentRevisionNumber() + 1) {
            return this.getMostRecentRevisionNumber();
        }
        try (R rtxRevisionMinus1 = this.beginNodeReadOnlyTrx(revision - 1);){
            R rtxRevision = this.beginNodeReadOnlyTrx(revision);
            try {
                int revisionNumber = AbstractResourceSession.timeDiff(timestamp, rtxRevisionMinus1.getRevisionTimestamp().toEpochMilli()) < AbstractResourceSession.timeDiff(timestamp, rtxRevision.getRevisionTimestamp().toEpochMilli()) ? rtxRevisionMinus1.getRevisionNumber() : rtxRevision.getRevisionNumber();
                int n = revisionNumber;
                if (rtxRevision != null) {
                    rtxRevision.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (rtxRevision != null) {
                    try {
                        rtxRevision.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public Optional<User> getUser() {
        this.assertNotClosed();
        return Optional.ofNullable(this.user);
    }

    private static /* synthetic */ boolean lambda$getNodeTrx$2(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }
}

