/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.d2linked.D2NodeBuilder;
import io.brackit.query.node.parser.DocumentParser;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.util.path.PathException;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.ResourceSession;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexType;
import io.sirix.index.Indexes;
import io.sirix.index.SearchMode;
import io.sirix.index.cas.CASFilter;
import io.sirix.index.cas.CASFilterRange;
import io.sirix.index.name.NameFilter;
import io.sirix.index.path.PCRCollector;
import io.sirix.index.path.PathFilter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;

public interface IndexController<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> {
    public boolean containsIndex(IndexType var1);

    public static boolean containsIndex(IndexType type, ResourceSession<?, ?> resourceSession, int revision) {
        Indexes indexes;
        block8: {
            indexes = new Indexes();
            Path indexesFile = resourceSession.getResourcePath().resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(revision + ".xml");
            try {
                if (!Files.exists(indexesFile, new LinkOption[0]) || Files.size(indexesFile) <= 0L) break block8;
                try (FileInputStream in = new FileInputStream(indexesFile.toFile());){
                    indexes.init(IndexController.deserialize(in).getFirstChild());
                }
            }
            catch (DocumentException | SirixException | IOException e) {
                throw new SirixIOException("Index definitions couldn't be deserialized!", e);
            }
        }
        for (IndexDef indexDef : indexes.getIndexDefs()) {
            if (indexDef.getType() != type) continue;
            return true;
        }
        return false;
    }

    public Indexes getIndexes();

    public void serialize(OutputStream var1);

    public void notifyChange(ChangeType var1, ImmutableNode var2, long var3);

    public IndexController<R, W> createIndexes(Set<IndexDef> var1, W var2);

    public IndexController<R, W> createIndexListeners(Set<IndexDef> var1, W var2);

    public NameFilter createNameFilter(Set<String> var1);

    public PathFilter createPathFilter(Set<String> var1, R var2) throws PathException;

    public CASFilter createCASFilter(Set<String> var1, Atomic var2, SearchMode var3, PCRCollector var4) throws PathException;

    public CASFilterRange createCASFilterRange(Set<String> var1, Atomic var2, Atomic var3, boolean var4, boolean var5, PCRCollector var6) throws PathException;

    public Iterator<NodeReferences> openPathIndex(PageReadOnlyTrx var1, IndexDef var2, PathFilter var3);

    public Iterator<NodeReferences> openNameIndex(PageReadOnlyTrx var1, IndexDef var2, NameFilter var3);

    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx var1, IndexDef var2, CASFilter var3);

    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx var1, IndexDef var2, CASFilterRange var3);

    public static Node<?> deserialize(InputStream in) {
        try {
            DocumentParser parser = new DocumentParser(in);
            D2NodeBuilder builder = new D2NodeBuilder();
            parser.parse((NodeSubtreeHandler)builder);
            return builder.root();
        }
        catch (DocumentException e) {
            throw new SirixException(e);
        }
    }

    public static enum ChangeType {
        INSERT,
        DELETE;

    }
}

