/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PotentialLock
implements Lock,
AutoCloseable {
    private final Lock lock;

    public PotentialLock(Lock lock) {
        this.lock = Objects.requireNonNull(lock);
    }

    @Override
    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        if (this.lock != null) {
            this.lock.lockInterruptibly();
        }
    }

    @Override
    public boolean tryLock() {
        if (this.lock != null) {
            return this.lock.tryLock();
        }
        return true;
    }

    @Override
    public boolean tryLock(long time, @NonNull TimeUnit unit) throws InterruptedException {
        if (this.lock != null) {
            return this.lock.tryLock(time, unit);
        }
        return true;
    }

    @Override
    public void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    @Override
    public @NonNull Condition newCondition() {
        if (this.lock != null) {
            return this.lock.newCondition();
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

