/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.json;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.brackit.query.atomic.QNm;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.AbstractNodeReadOnlyTrx;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.json.InsertOperations;
import io.sirix.access.trx.node.json.InternalJsonNodeReadOnlyTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.diff.JsonDiffSerializer;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.immutable.json.ImmutableArrayNode;
import io.sirix.node.immutable.json.ImmutableBooleanNode;
import io.sirix.node.immutable.json.ImmutableJsonDocumentRootNode;
import io.sirix.node.immutable.json.ImmutableNullNode;
import io.sirix.node.immutable.json.ImmutableNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectBooleanNode;
import io.sirix.node.immutable.json.ImmutableObjectKeyNode;
import io.sirix.node.immutable.json.ImmutableObjectNode;
import io.sirix.node.immutable.json.ImmutableObjectNullNode;
import io.sirix.node.immutable.json.ImmutableObjectNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectStringNode;
import io.sirix.node.immutable.json.ImmutableStringNode;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.json.ArrayNode;
import io.sirix.node.json.BooleanNode;
import io.sirix.node.json.JsonDocumentRootNode;
import io.sirix.node.json.NullNode;
import io.sirix.node.json.NumberNode;
import io.sirix.node.json.ObjectBooleanNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.node.json.ObjectNode;
import io.sirix.node.json.ObjectNullNode;
import io.sirix.node.json.ObjectNumberNode;
import io.sirix.node.json.ObjectStringNode;
import io.sirix.node.json.StringNode;
import io.sirix.service.xml.xpath.ItemListImpl;
import io.sirix.settings.Constants;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.index.qual.NonNegative;

public final class JsonNodeReadOnlyTrxImpl
extends AbstractNodeReadOnlyTrx<JsonNodeReadOnlyTrx, JsonNodeTrx, ImmutableNode>
implements InternalJsonNodeReadOnlyTrx {
    private final String INSERT = InsertOperations.INSERT.getName();
    private final String UPDATE = InsertOperations.UPDATE.getName();
    private final String DELETE = InsertOperations.DELETE.getName();
    private final String REPLACE = InsertOperations.REPLACE.getName();

    JsonNodeReadOnlyTrxImpl(InternalResourceSession<JsonNodeReadOnlyTrx, JsonNodeTrx> resourceManager, @NonNegative long trxId, PageReadOnlyTrx pageReadTransaction, ImmutableJsonNode documentNode) {
        super(trxId, pageReadTransaction, documentNode, resourceManager, new ItemListImpl());
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLastChild();
    }

    @Override
    public boolean moveToLastChild() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasLastChild()) {
            this.moveTo(this.getStructuralNode().getLastChildKey());
            return true;
        }
        return false;
    }

    @Override
    public List<JsonObject> getUpdateOperations() {
        int revisionNumber = this.pageReadOnlyTrx instanceof PageTrx ? this.getRevisionNumber() - 1 : this.getRevisionNumber();
        Path updateOperationsFile = this.resourceSession.getResourceConfig().getResource().resolve(ResourceConfiguration.ResourcePaths.UPDATE_OPERATIONS.getPath()).resolve("diffFromRev" + (revisionNumber - 1) + "toRev" + revisionNumber + ".json");
        ArrayList<JsonObject> diffTuples = new ArrayList<JsonObject>();
        try {
            JsonElement jsonElement = JsonParser.parseString((String)Files.readString(updateOperationsFile));
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonArray diffs = jsonObject.getAsJsonArray("diffs");
            diffs.forEach(this.serializeJsonFragmentIfNeeded(diffTuples));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return diffTuples;
    }

    private Consumer<JsonElement> serializeJsonFragmentIfNeeded(List<JsonObject> diffTuples) {
        return diff -> {
            JsonObject diffObject = diff.getAsJsonObject();
            Object diffTupleObject = diffObject.has(this.INSERT) ? diffObject.getAsJsonObject(this.INSERT) : (diffObject.has(this.REPLACE) ? diffObject.getAsJsonObject(this.REPLACE) : null);
            if (diffTupleObject != null && "jsonFragment".equals(diffTupleObject.getAsJsonPrimitive("type").getAsString())) {
                long nodeKey = diffTupleObject.get("nodeKey").getAsLong();
                long currentNodeKey = this.getNodeKey();
                this.moveTo(nodeKey);
                int revisionNumber = this.pageReadOnlyTrx instanceof PageTrx ? this.getRevisionNumber() - 1 : this.getRevisionNumber();
                JsonDiffSerializer.serialize(revisionNumber, this.getResourceSession(), this, diffTupleObject);
                this.moveTo(currentNodeKey);
            }
            diffTuples.add(diff.getAsJsonObject());
        };
    }

    @Override
    public List<JsonObject> getUpdateOperationsInSubtreeOfNode(SirixDeweyID rootDeweyId, long maxDepth) {
        Objects.requireNonNull(rootDeweyId);
        List<JsonObject> updateOperations = this.getUpdateOperations();
        return updateOperations.stream().filter(this.filterAncestorOperations(rootDeweyId, maxDepth)).sorted(this.sortByDeweyID()).collect(Collectors.toList());
    }

    private Comparator<JsonObject> sortByDeweyID() {
        return Comparator.comparing(updateOperation -> {
            if (updateOperation.has(this.INSERT)) {
                return this.getDeweyID((JsonObject)updateOperation, this.INSERT);
            }
            if (updateOperation.has(this.DELETE)) {
                return this.getDeweyID((JsonObject)updateOperation, this.DELETE);
            }
            if (updateOperation.has(this.UPDATE)) {
                return this.getDeweyID((JsonObject)updateOperation, this.UPDATE);
            }
            if (updateOperation.has(this.REPLACE)) {
                return this.getDeweyID((JsonObject)updateOperation, this.REPLACE);
            }
            throw new IllegalStateException(String.valueOf(updateOperation) + " not known.");
        });
    }

    private Predicate<JsonObject> filterAncestorOperations(SirixDeweyID rootDeweyId, long maxDepth) {
        return updateOperation -> {
            if (updateOperation.has(this.INSERT)) {
                return this.isDescendatOrSelfOf(rootDeweyId, (JsonObject)updateOperation, this.INSERT, maxDepth);
            }
            if (updateOperation.has(this.DELETE)) {
                return this.isDescendatOrSelfOf(rootDeweyId, (JsonObject)updateOperation, this.DELETE, maxDepth);
            }
            if (updateOperation.has(this.UPDATE)) {
                return this.isDescendatOrSelfOf(rootDeweyId, (JsonObject)updateOperation, this.UPDATE, maxDepth);
            }
            if (updateOperation.has(this.REPLACE)) {
                return this.isDescendatOrSelfOf(rootDeweyId, (JsonObject)updateOperation, this.REPLACE, maxDepth);
            }
            throw new IllegalStateException(String.valueOf(updateOperation) + " not known.");
        };
    }

    private SirixDeweyID getDeweyID(JsonObject updateOperation, String operation) {
        JsonObject opAsJsonObject = updateOperation.getAsJsonObject(operation);
        return new SirixDeweyID(opAsJsonObject.getAsJsonPrimitive("deweyID").getAsString());
    }

    private boolean isDescendatOrSelfOf(SirixDeweyID rootDeweyId, JsonObject updateOperation, String operation, long maxDepth) {
        JsonObject opAsJsonObject = updateOperation.getAsJsonObject(operation);
        SirixDeweyID deweyId = new SirixDeweyID(opAsJsonObject.getAsJsonPrimitive("deweyID").getAsString());
        return deweyId.isDescendantOrSelfOf(rootDeweyId) && (long)(deweyId.getLevel() - rootDeweyId.getLevel()) <= maxDepth;
    }

    @Override
    public String getValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return switch (currentNode.getKind()) {
            case NodeKind.OBJECT_STRING_VALUE, NodeKind.STRING_VALUE -> new String(((ValueNode)currentNode).getRawValue(), Constants.DEFAULT_ENCODING);
            case NodeKind.OBJECT_BOOLEAN_VALUE -> String.valueOf(((ObjectBooleanNode)currentNode).getValue());
            case NodeKind.BOOLEAN_VALUE -> String.valueOf(((BooleanNode)currentNode).getValue());
            case NodeKind.OBJECT_NULL_VALUE, NodeKind.NULL_VALUE -> "null";
            case NodeKind.OBJECT_NUMBER_VALUE -> String.valueOf(((ObjectNumberNode)currentNode).getValue());
            case NodeKind.NUMBER_VALUE -> String.valueOf(((NumberNode)currentNode).getValue());
            default -> "";
        };
    }

    @Override
    public boolean getBooleanValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.BOOLEAN_VALUE) {
            return ((BooleanNode)currentNode).getValue();
        }
        if (currentNode.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE) {
            return ((ObjectBooleanNode)currentNode).getValue();
        }
        throw new IllegalStateException("Current node is no boolean node.");
    }

    @Override
    public Number getNumberValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.NUMBER_VALUE) {
            return ((NumberNode)currentNode).getValue();
        }
        if (currentNode.getKind() == NodeKind.OBJECT_NUMBER_VALUE) {
            return ((ObjectNumberNode)currentNode).getValue();
        }
        throw new IllegalStateException("Current node is no number node.");
    }

    @Override
    public JsonResourceSession getResourceSession() {
        this.assertNotClosed();
        return (JsonResourceSession)((Object)this.resourceSession);
    }

    @Override
    public ImmutableNode getNode() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return switch (currentNode.getKind()) {
            case NodeKind.OBJECT -> ImmutableObjectNode.of((ObjectNode)currentNode);
            case NodeKind.OBJECT_KEY -> ImmutableObjectKeyNode.of((ObjectKeyNode)currentNode);
            case NodeKind.ARRAY -> ImmutableArrayNode.of((ArrayNode)currentNode);
            case NodeKind.BOOLEAN_VALUE -> ImmutableBooleanNode.of((BooleanNode)currentNode);
            case NodeKind.NUMBER_VALUE -> ImmutableNumberNode.of((NumberNode)currentNode);
            case NodeKind.STRING_VALUE -> ImmutableStringNode.of((StringNode)currentNode);
            case NodeKind.NULL_VALUE -> ImmutableNullNode.of((NullNode)currentNode);
            case NodeKind.OBJECT_BOOLEAN_VALUE -> ImmutableObjectBooleanNode.of((ObjectBooleanNode)currentNode);
            case NodeKind.OBJECT_NUMBER_VALUE -> ImmutableObjectNumberNode.of((ObjectNumberNode)currentNode);
            case NodeKind.OBJECT_STRING_VALUE -> ImmutableObjectStringNode.of((ObjectStringNode)currentNode);
            case NodeKind.OBJECT_NULL_VALUE -> ImmutableObjectNullNode.of((ObjectNullNode)currentNode);
            case NodeKind.JSON_DOCUMENT -> ImmutableJsonDocumentRootNode.of((JsonDocumentRootNode)currentNode);
            default -> throw new IllegalStateException("Node kind not known!");
        };
    }

    @Override
    public boolean isArray() {
        this.assertNotClosed();
        return this.getCurrentNode().getKind() == NodeKind.ARRAY;
    }

    @Override
    public boolean isObject() {
        this.assertNotClosed();
        return this.getCurrentNode().getKind() == NodeKind.OBJECT;
    }

    @Override
    public boolean isObjectKey() {
        this.assertNotClosed();
        return this.getCurrentNode().getKind() == NodeKind.OBJECT_KEY;
    }

    @Override
    public boolean isNumberValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return currentNode.getKind() == NodeKind.NUMBER_VALUE || currentNode.getKind() == NodeKind.OBJECT_NUMBER_VALUE;
    }

    @Override
    public boolean isNullValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return currentNode.getKind() == NodeKind.NULL_VALUE || currentNode.getKind() == NodeKind.OBJECT_NULL_VALUE;
    }

    @Override
    public boolean isStringValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return currentNode.getKind() == NodeKind.STRING_VALUE || currentNode.getKind() == NodeKind.OBJECT_STRING_VALUE;
    }

    @Override
    public boolean isBooleanValue() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return currentNode.getKind() == NodeKind.BOOLEAN_VALUE || currentNode.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE;
    }

    @Override
    public boolean isDocumentRoot() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        return currentNode.getKind() == NodeKind.JSON_DOCUMENT;
    }

    @Override
    public QNm getName() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.OBJECT_KEY) {
            int nameKey = ((ObjectKeyNode)currentNode).getNameKey();
            String localName = nameKey == -1 ? "" : this.pageReadOnlyTrx.getName(nameKey, currentNode.getKind());
            return new QNm(localName);
        }
        return null;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        this.assertNotClosed();
        return ((ImmutableJsonNode)this.getCurrentNode()).acceptVisitor(visitor);
    }

    @Override
    public int getNameKey() {
        this.assertNotClosed();
        Object currentNode = this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.OBJECT_KEY) {
            return ((ObjectKeyNode)currentNode).getNameKey();
        }
        return -1;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("Revision number", this.getRevisionNumber());
        Object currentNode = this.getCurrentNode();
        QNm name = this.getName();
        if (currentNode.getKind() == NodeKind.OBJECT_KEY && name != null) {
            helper.add("Name of Node", (Object)name.toString());
        }
        if (currentNode.getKind() == NodeKind.BOOLEAN_VALUE || currentNode.getKind() == NodeKind.STRING_VALUE || currentNode.getKind() == NodeKind.NUMBER_VALUE || currentNode.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE || currentNode.getKind() == NodeKind.OBJECT_NULL_VALUE || currentNode.getKind() == NodeKind.OBJECT_NUMBER_VALUE || currentNode.getKind() == NodeKind.OBJECT_STRING_VALUE) {
            helper.add("Value of Node", (Object)this.getValue());
        }
        if (currentNode.getKind() == NodeKind.JSON_DOCUMENT) {
            helper.addValue((Object)"Node is DocumentRoot");
        }
        helper.add("node", (Object)currentNode.toString());
        return helper.toString();
    }
}

