/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.json;

import io.sirix.access.ResourceConfiguration;
import io.sirix.access.ResourceStore;
import io.sirix.access.User;
import io.sirix.access.trx.node.AbstractResourceSession;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.RecordToRevisionsIndex;
import io.sirix.access.trx.node.json.InternalJsonNodeReadOnlyTrx;
import io.sirix.access.trx.node.json.JsonIndexController;
import io.sirix.access.trx.node.json.JsonNodeFactoryImpl;
import io.sirix.access.trx.node.json.JsonNodeHashing;
import io.sirix.access.trx.node.json.JsonNodeReadOnlyTrxImpl;
import io.sirix.access.trx.node.json.JsonNodeTrxImpl;
import io.sirix.access.trx.page.PageTrxFactory;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.cache.BufferManager;
import io.sirix.dagger.DatabaseName;
import io.sirix.index.path.summary.PathSummaryWriter;
import io.sirix.io.IOStorage;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.page.UberPage;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;

public final class JsonResourceSessionImpl
extends AbstractResourceSession<JsonNodeReadOnlyTrx, JsonNodeTrx>
implements JsonResourceSession,
InternalResourceSession<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    private final ConcurrentMap<Integer, JsonIndexController> rtxIndexControllers;
    private final ConcurrentMap<Integer, JsonIndexController> wtxIndexControllers;
    private final String databaseName;

    @Inject
    JsonResourceSessionImpl(ResourceStore<JsonResourceSession> resourceStore, ResourceConfiguration resourceConf, BufferManager bufferManager, IOStorage storage, UberPage uberPage, Semaphore writeLock, User user, @DatabaseName String databaseName, PageTrxFactory pageTrxFactory) {
        super(resourceStore, resourceConf, bufferManager, storage, uberPage, writeLock, user, pageTrxFactory);
        this.databaseName = databaseName;
        this.rtxIndexControllers = new ConcurrentHashMap<Integer, JsonIndexController>();
        this.wtxIndexControllers = new ConcurrentHashMap<Integer, JsonIndexController>();
    }

    @Override
    public InternalJsonNodeReadOnlyTrx createNodeReadOnlyTrx(long nodeTrxId, PageReadOnlyTrx pageReadTrx, Node documentNode) {
        return new JsonNodeReadOnlyTrxImpl(this, nodeTrxId, pageReadTrx, (ImmutableJsonNode)((Object)documentNode));
    }

    @Override
    public JsonNodeTrx createNodeReadWriteTrx(long nodeTrxId, PageTrx pageTrx, int maxNodeCount, Duration autoCommitDelay, Node documentNode, AfterCommitState afterCommitState) {
        InternalJsonNodeReadOnlyTrx nodeReadOnlyTrx = this.createNodeReadOnlyTrx(nodeTrxId, pageTrx, documentNode);
        JsonNodeFactoryImpl nodeFactory = new JsonNodeFactoryImpl(this.getResourceConfig().nodeHashFunction, pageTrx);
        boolean buildPathSummary = this.getResourceConfig().withPathSummary;
        PathSummaryWriter<JsonNodeReadOnlyTrx> pathSummaryWriter = buildPathSummary ? new PathSummaryWriter<JsonNodeReadOnlyTrx>(pageTrx, this, nodeFactory, nodeReadOnlyTrx) : null;
        boolean isAutoCommitting = maxNodeCount > 0 || !autoCommitDelay.isZero();
        ReentrantLock lock = !autoCommitDelay.isZero() ? new ReentrantLock() : null;
        ResourceConfiguration resourceConfig = this.getResourceConfig();
        return new JsonNodeTrxImpl(this.databaseName, this, nodeReadOnlyTrx, pathSummaryWriter, maxNodeCount, lock, autoCommitDelay, new JsonNodeHashing(resourceConfig, nodeReadOnlyTrx, pageTrx), nodeFactory, afterCommitState, new RecordToRevisionsIndex(pageTrx), isAutoCommitting);
    }

    @Override
    public synchronized JsonIndexController getRtxIndexController(int revision) {
        return this.rtxIndexControllers.computeIfAbsent(revision, unused -> this.createIndexController(revision));
    }

    @Override
    public synchronized JsonIndexController getWtxIndexController(int revision) {
        return this.wtxIndexControllers.computeIfAbsent(revision, unused -> this.createIndexController(revision));
    }

    private JsonIndexController createIndexController(int revision) {
        JsonIndexController controller = new JsonIndexController();
        this.initializeIndexController(revision, controller);
        return controller;
    }
}

