/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import io.sirix.access.trx.node.AbstractDeweyIDManager;
import io.sirix.access.trx.node.xml.InternalXmlNodeTrx;
import io.sirix.api.PageTrx;
import io.sirix.axis.LevelOrderAxis;
import io.sirix.index.IndexType;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.xml.ElementNode;
import it.unimi.dsi.fastutil.longs.LongIterator;

final class XmlDeweyIDManager
extends AbstractDeweyIDManager<InternalXmlNodeTrx> {
    private final InternalXmlNodeTrx nodeTrx;
    private final PageTrx pageTrx;

    public XmlDeweyIDManager(InternalXmlNodeTrx nodeTrx) {
        super(nodeTrx);
        this.nodeTrx = nodeTrx;
        this.pageTrx = nodeTrx.getPageWtx();
    }

    public void computeNewDeweyIDs() {
        SirixDeweyID id = this.nodeTrx.hasLeftSibling() && this.nodeTrx.hasRightSibling() ? SirixDeweyID.newBetween(this.nodeTrx.getLeftSiblingDeweyID(), this.nodeTrx.getRightSiblingDeweyID()) : (this.nodeTrx.hasLeftSibling() ? SirixDeweyID.newBetween(this.nodeTrx.getLeftSiblingDeweyID(), null) : (this.nodeTrx.hasRightSibling() ? SirixDeweyID.newBetween(null, this.nodeTrx.getRightSiblingDeweyID()) : this.nodeTrx.getParentDeweyID().getNewChildID()));
        long nodeKey = this.nodeTrx.getNodeKey();
        StructNode root = (StructNode)this.nodeTrx.getPageWtx().prepareRecordForModification(nodeKey, IndexType.DOCUMENT, -1);
        root.setDeweyID(id);
        this.adaptNonStructuralNodes(root);
        if (root.hasFirstChild()) {
            this.nodeTrx.moveTo(root.getFirstChildKey());
            int attributeNr = 0;
            int nspNr = 0;
            long previousNodeKey = this.nodeTrx.getNodeKey();
            LongIterator longIterator = LevelOrderAxis.newBuilder(this.nodeTrx).includeNonStructuralNodes().includeSelf().build().iterator();
            while (longIterator.hasNext()) {
                SirixDeweyID deweyID;
                long ignored = (Long)longIterator.next();
                if (this.nodeTrx.isAttribute()) {
                    long attNodeKey = this.nodeTrx.getNodeKey();
                    if (attributeNr == 0) {
                        deweyID = this.nodeTrx.getParentDeweyID().getNewAttributeID();
                    } else {
                        this.nodeTrx.moveTo(attributeNr - 1);
                        deweyID = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
                    }
                    this.nodeTrx.moveTo(attNodeKey);
                    ++attributeNr;
                } else if (this.nodeTrx.isNamespace()) {
                    long nspNodeKey = this.nodeTrx.getNodeKey();
                    if (nspNr == 0) {
                        deweyID = this.nodeTrx.getParentDeweyID().getNewNamespaceID();
                    } else {
                        this.nodeTrx.moveTo(attributeNr - 1);
                        deweyID = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
                    }
                    this.nodeTrx.moveTo(nspNodeKey);
                    ++nspNr;
                } else {
                    attributeNr = 0;
                    nspNr = 0;
                    deweyID = previousNodeKey == this.nodeTrx.getLeftSiblingKey() ? SirixDeweyID.newBetween(this.nodeTrx.getLeftSiblingDeweyID(), null) : this.nodeTrx.getParentDeweyID().getNewChildID();
                }
                Node node = (Node)this.pageTrx.prepareRecordForModification(this.nodeTrx.getNodeKey(), IndexType.DOCUMENT, -1);
                node.setDeweyID(deweyID);
                previousNodeKey = node.getNodeKey();
            }
            this.nodeTrx.moveTo(nodeKey);
        }
    }

    public void adaptNonStructuralNodes(DataRecord root) {
        if (this.nodeTrx.isElement()) {
            Node node;
            SirixDeweyID deweyID;
            int i;
            ElementNode element = (ElementNode)root;
            int attLength = element.getAttributeCount();
            for (i = 0; i < attLength; ++i) {
                if (i == 0) {
                    this.nodeTrx.moveToAttribute(i);
                    deweyID = this.nodeTrx.getParentDeweyID().getNewAttributeID();
                } else {
                    this.nodeTrx.moveToAttribute(i - 1);
                    deweyID = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
                }
                this.nodeTrx.moveToParent();
                this.nodeTrx.moveToAttribute(i);
                node = (Node)this.pageTrx.prepareRecordForModification(this.nodeTrx.getNodeKey(), IndexType.DOCUMENT, -1);
                node.setDeweyID(deweyID);
                this.nodeTrx.moveToParent();
            }
            int nspLength = element.getNamespaceCount();
            for (i = 0; i < nspLength; ++i) {
                if (i == 0) {
                    this.nodeTrx.moveToNamespace(i);
                    deweyID = this.nodeTrx.getParentDeweyID().getNewNamespaceID();
                } else {
                    this.nodeTrx.moveToNamespace(i - 1);
                    deweyID = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
                }
                this.nodeTrx.moveToNamespace(i);
                node = (Node)this.pageTrx.prepareRecordForModification(this.nodeTrx.getNodeKey(), IndexType.DOCUMENT, -1);
                node.setDeweyID(deweyID);
                this.nodeTrx.moveToParent();
            }
        }
    }

    SirixDeweyID newNamespaceID() {
        SirixDeweyID id = null;
        if (this.nodeTrx.storeDeweyIDs()) {
            if (this.nodeTrx.hasNamespaces()) {
                this.nodeTrx.moveToNamespace(this.nodeTrx.getNamespaceCount() - 1);
                id = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
                this.nodeTrx.moveToParent();
            } else {
                id = this.nodeTrx.getDeweyID().getNewNamespaceID();
            }
        }
        return id;
    }

    SirixDeweyID newAttributeID() {
        SirixDeweyID id = null;
        if (this.nodeTrx.storeDeweyIDs()) {
            if (this.nodeTrx.hasAttributes()) {
                this.nodeTrx.moveToAttribute(this.nodeTrx.getAttributeCount() - 1);
                id = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
                this.nodeTrx.moveToParent();
            } else {
                id = this.nodeTrx.getDeweyID().getNewAttributeID();
            }
        }
        return id;
    }
}

