/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import io.brackit.query.atomic.QNm;
import io.sirix.access.trx.node.xml.XmlNodeFactory;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.PathNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.xml.AttributeNode;
import io.sirix.node.xml.CommentNode;
import io.sirix.node.xml.ElementNode;
import io.sirix.node.xml.NamespaceNode;
import io.sirix.node.xml.PINode;
import io.sirix.node.xml.TextNode;
import io.sirix.page.PathSummaryPage;
import io.sirix.settings.Fixed;
import io.sirix.utils.Compression;
import io.sirix.utils.NamePageHash;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Objects;
import net.openhft.hashing.LongHashFunction;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

final class XmlNodeFactoryImpl
implements XmlNodeFactory {
    private final PageTrx pageTrx;
    private final LongHashFunction hashFunction;
    private final int revisionNumber;

    XmlNodeFactoryImpl(LongHashFunction hashFunction, PageTrx pageWriteTrx) {
        this.pageTrx = Objects.requireNonNull(pageWriteTrx);
        this.pageTrx.createNameKey("xs:untyped", NodeKind.ATTRIBUTE);
        this.pageTrx.createNameKey("xs:untyped", NodeKind.NAMESPACE);
        this.pageTrx.createNameKey("xs:untyped", NodeKind.ELEMENT);
        this.pageTrx.createNameKey("xs:untyped", NodeKind.PROCESSING_INSTRUCTION);
        this.hashFunction = Objects.requireNonNull(hashFunction);
        this.revisionNumber = pageWriteTrx.getRevisionNumber();
    }

    @Override
    public PathNode createPathNode(@NonNegative long parentKey, @NonNegative long leftSibKey, long rightSibKey, @NonNull QNm name, @NonNull NodeKind kind, @NonNegative int level) {
        int uriKey = NamePageHash.generateHashForString(name.getNamespaceURI());
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? NamePageHash.generateHashForString(name.getPrefix()) : -1;
        int localName = name.getLocalName() != null && !name.getLocalName().isEmpty() ? NamePageHash.generateHashForString(name.getLocalName()) : -1;
        NodeDelegate nodeDel = new NodeDelegate(((PathSummaryPage)this.pageTrx.getActualRevisionRootPage().getPathSummaryPageReference().getPage()).getMaxNodeKey(0) + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, (SirixDeweyID)null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localName, 0L);
        return this.pageTrx.createRecord(new PathNode(name, nodeDel, structDel, nameDel, kind, 1, level), IndexType.PATH_SUMMARY, 0);
    }

    @Override
    public ElementNode createElementNode(@NonNegative long parentKey, @NonNegative long leftSibKey, @NonNegative long rightSibKey, @NonNull QNm name, @NonNegative long pathNodeKey, SirixDeweyID id) {
        int uriKey = name.getNamespaceURI() != null && !name.getNamespaceURI().isEmpty() ? this.pageTrx.createNameKey(name.getNamespaceURI(), NodeKind.NAMESPACE) : -1;
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.pageTrx.createNameKey(name.getPrefix(), NodeKind.ELEMENT) : -1;
        int localNameKey = this.pageTrx.createNameKey(name.getLocalName(), NodeKind.ELEMENT);
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, pathNodeKey);
        return this.pageTrx.createRecord(new ElementNode(structDel, nameDel, (LongList)new LongArrayList(), (LongList)new LongArrayList(), name), IndexType.DOCUMENT, -1);
    }

    @Override
    public TextNode createTextNode(@NonNegative long parentKey, @NonNegative long leftSibKey, @NonNegative long rightSibKey, byte[] value, boolean isCompressed, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        boolean compression = isCompressed && value.length > 10;
        byte[] compressedValue = compression ? Compression.compress(value, 2) : value;
        ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new TextNode(valDel, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public AttributeNode createAttributeNode(@NonNegative long parentKey, @NonNull QNm name, byte[] value, @NonNegative long pathNodeKey, SirixDeweyID id) {
        int uriKey = this.pageTrx.createNameKey(name.getNamespaceURI(), NodeKind.NAMESPACE);
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.pageTrx.createNameKey(name.getPrefix(), NodeKind.ATTRIBUTE) : -1;
        int localNameKey = this.pageTrx.createNameKey(name.getLocalName(), NodeKind.ATTRIBUTE);
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, pathNodeKey);
        ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, value, false);
        return this.pageTrx.createRecord(new AttributeNode(nodeDel, nameDel, valDel, name), IndexType.DOCUMENT, -1);
    }

    @Override
    public NamespaceNode createNamespaceNode(@NonNegative long parentKey, QNm name, @NonNegative long pathNodeKey, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        int uriKey = this.pageTrx.createNameKey(name.getNamespaceURI(), NodeKind.NAMESPACE);
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.pageTrx.createNameKey(name.getPrefix(), NodeKind.NAMESPACE) : -1;
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, -1, pathNodeKey);
        return this.pageTrx.createRecord(new NamespaceNode(nodeDel, nameDel, name), IndexType.DOCUMENT, -1);
    }

    @Override
    public PINode createPINode(@NonNegative long parentKey, @NonNegative long leftSibKey, @NonNegative long rightSibKey, QNm target, byte[] content, boolean isCompressed, @NonNegative long pathNodeKey, SirixDeweyID id) {
        int prefixKey = target.getPrefix() != null && !target.getPrefix().isEmpty() ? this.pageTrx.createNameKey(target.getPrefix(), NodeKind.PROCESSING_INSTRUCTION) : -1;
        int localNameKey = this.pageTrx.createNameKey(target.getLocalName(), NodeKind.PROCESSING_INSTRUCTION);
        int uriKey = this.pageTrx.createNameKey(target.getNamespaceURI(), NodeKind.NAMESPACE);
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, pathNodeKey);
        ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, content, false);
        return this.pageTrx.createRecord(new PINode(structDel, nameDel, valDel, this.pageTrx), IndexType.DOCUMENT, -1);
    }

    @Override
    public CommentNode createCommentNode(@NonNegative long parentKey, @NonNegative long leftSibKey, @NonNegative long rightSibKey, byte[] value, boolean isCompressed, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        boolean compression = isCompressed && value.length > 10;
        byte[] compressedValue = compression ? Compression.compress(value, 2) : value;
        ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new CommentNode(valDel, structDel), IndexType.DOCUMENT, -1);
    }
}

