/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import com.google.common.base.MoreObjects;
import io.brackit.query.atomic.QNm;
import io.sirix.access.trx.node.AbstractNodeReadOnlyTrx;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.xml.InternalXmlNodeReadOnlyTrx;
import io.sirix.api.ItemList;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.immutable.xml.ImmutableAttributeNode;
import io.sirix.node.immutable.xml.ImmutableComment;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.immutable.xml.ImmutableNamespace;
import io.sirix.node.immutable.xml.ImmutablePI;
import io.sirix.node.immutable.xml.ImmutableText;
import io.sirix.node.immutable.xml.ImmutableXmlDocumentRootNode;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableNameNode;
import io.sirix.node.interfaces.immutable.ImmutableValueNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.node.xml.AttributeNode;
import io.sirix.node.xml.CommentNode;
import io.sirix.node.xml.ElementNode;
import io.sirix.node.xml.NamespaceNode;
import io.sirix.node.xml.PINode;
import io.sirix.node.xml.TextNode;
import io.sirix.node.xml.XmlDocumentRootNode;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.ItemListImpl;
import io.sirix.settings.Constants;
import io.sirix.utils.NamePageHash;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class XmlNodeReadOnlyTrxImpl
extends AbstractNodeReadOnlyTrx<XmlNodeReadOnlyTrx, XmlNodeTrx, ImmutableXmlNode>
implements InternalXmlNodeReadOnlyTrx {
    XmlNodeReadOnlyTrxImpl(InternalResourceSession<XmlNodeReadOnlyTrx, XmlNodeTrx> resourceManager, @NonNegative long trxId, PageReadOnlyTrx pageReadTransaction, ImmutableXmlNode documentNode) {
        super(trxId, pageReadTransaction, documentNode, resourceManager, new ItemListImpl());
    }

    @Override
    public ImmutableXmlNode getNode() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        return switch (currentNode.getKind()) {
            case NodeKind.ELEMENT -> ImmutableElement.of((ElementNode)currentNode);
            case NodeKind.TEXT -> ImmutableText.of((TextNode)currentNode);
            case NodeKind.COMMENT -> ImmutableComment.of((CommentNode)currentNode);
            case NodeKind.PROCESSING_INSTRUCTION -> ImmutablePI.of((PINode)currentNode);
            case NodeKind.ATTRIBUTE -> ImmutableAttributeNode.of((AttributeNode)currentNode);
            case NodeKind.NAMESPACE -> ImmutableNamespace.of((NamespaceNode)currentNode);
            case NodeKind.XML_DOCUMENT -> ImmutableXmlDocumentRootNode.of((XmlDocumentRootNode)currentNode);
            default -> throw new IllegalStateException("Node kind not known!");
        };
    }

    @Override
    public ImmutableNameNode getNameNode() {
        this.assertNotClosed();
        return (ImmutableNameNode)this.getCurrentNode();
    }

    @Override
    public ImmutableValueNode getValueNode() {
        this.assertNotClosed();
        return (ImmutableValueNode)this.getCurrentNode();
    }

    @Override
    public boolean moveToAttribute(int index) {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            ElementNode element = (ElementNode)currentNode;
            if (element.getAttributeCount() > index) {
                return this.moveTo(element.getAttributeKey(index));
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean moveToNamespace(int index) {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            ElementNode element = (ElementNode)currentNode;
            if (element.getNamespaceCount() > index) {
                return this.moveTo(element.getNamespaceKey(index));
            }
            return false;
        }
        return false;
    }

    @Override
    public QNm getName() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)currentNode);
            String uri = this.pageReadOnlyTrx.getName(nameNode.getURIKey(), NodeKind.NAMESPACE);
            int prefixKey = nameNode.getPrefixKey();
            String prefix = prefixKey == -1 ? "" : this.pageReadOnlyTrx.getName(prefixKey, currentNode.getKind());
            int localNameKey = ((NameNode)((Object)currentNode)).getLocalNameKey();
            String localName = localNameKey == -1 ? "" : this.pageReadOnlyTrx.getName(localNameKey, currentNode.getKind());
            return new QNm(uri, prefix, localName);
        }
        return null;
    }

    @Override
    public String getType() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        return this.pageReadOnlyTrx.getName(currentNode.getTypeKey(), currentNode.getKind());
    }

    @Override
    public byte[] rawNameForKey(int key) {
        this.assertNotClosed();
        return this.pageReadOnlyTrx.getRawName(key, ((ImmutableXmlNode)this.getCurrentNode()).getKind());
    }

    @Override
    public ItemList<AtomicValue> getItemList() {
        this.assertNotClosed();
        return this.itemList;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("Revision number", this.getRevisionNumber());
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        QNm name = this.getName();
        if (name != null && (currentNode.getKind() == NodeKind.ATTRIBUTE || currentNode.getKind() == NodeKind.ELEMENT)) {
            helper.add("Name of Node", (Object)name.toString());
        }
        if (currentNode.getKind() == NodeKind.ATTRIBUTE || currentNode.getKind() == NodeKind.TEXT) {
            helper.add("Value of Node", (Object)this.getValue());
        }
        if (currentNode.getKind() == NodeKind.XML_DOCUMENT) {
            helper.addValue((Object)"Node is DocumentRoot");
        }
        helper.add("node", (Object)currentNode.toString());
        return helper.toString();
    }

    @Override
    public boolean moveToLastChild() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasFirstChild()) {
            this.moveToFirstChild();
            while (this.getStructuralNode().hasRightSibling()) {
                this.moveToRightSibling();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToAttributeByName(QNm name) {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            ElementNode element = (ElementNode)currentNode;
            long attKey = -1L;
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                QNm attName;
                long attributeKey = element.getAttributeKey(i);
                if (!this.moveTo(attributeKey) || (attName = this.getName()) == null || !attName.equals((Object)name)) continue;
                attKey = attributeKey;
                break;
            }
            this.setCurrentNode(currentNode);
            if (attKey != -1L) {
                return this.moveTo(attKey);
            }
        }
        return false;
    }

    @Override
    public int getAttributeCount() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            ElementNode node = (ElementNode)currentNode;
            return node.getAttributeCount();
        }
        return 0;
    }

    @Override
    public int getNamespaceCount() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            ElementNode node = (ElementNode)currentNode;
            return node.getNamespaceCount();
        }
        return 0;
    }

    @Override
    public boolean isNameNode() {
        this.assertNotClosed();
        return this.getCurrentNode() instanceof NameNode;
    }

    @Override
    public int getPrefixKey() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)currentNode);
            return nameNode.getPrefixKey();
        }
        return -1;
    }

    @Override
    public int getLocalNameKey() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)currentNode);
            return nameNode.getLocalNameKey();
        }
        return -1;
    }

    @Override
    public int getTypeKey() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getTypeKey();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).acceptVisitor(visitor);
    }

    @Override
    public long getAttributeKey(@NonNegative int index) {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            return ((ElementNode)currentNode).getAttributeKey(index);
        }
        return -1L;
    }

    @Override
    public boolean isStructuralNode() {
        this.assertNotClosed();
        return this.getCurrentNode() instanceof StructNode;
    }

    @Override
    public int getURIKey() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)currentNode);
            return nameNode.getURIKey();
        }
        return -1;
    }

    @Override
    public List<Long> getAttributeKeys() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            return ((ElementNode)currentNode).getAttributeKeys();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getNamespaceKeys() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.ELEMENT) {
            return ((ElementNode)currentNode).getNamespaceKeys();
        }
        return Collections.emptyList();
    }

    @Override
    public String getNamespaceURI() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)currentNode);
            return this.pageReadOnlyTrx.getName(nameNode.getURIKey(), NodeKind.NAMESPACE);
        }
        return null;
    }

    @Override
    public boolean isElement() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.ELEMENT;
    }

    @Override
    public boolean isText() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT;
    }

    @Override
    public boolean isDocumentRoot() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.XML_DOCUMENT;
    }

    @Override
    public boolean isComment() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.COMMENT;
    }

    @Override
    public boolean isAttribute() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.ATTRIBUTE;
    }

    @Override
    public boolean isNamespace() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.NAMESPACE;
    }

    @Override
    public boolean isPI() {
        this.assertNotClosed();
        return ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.PROCESSING_INSTRUCTION;
    }

    @Override
    public boolean hasAttributes() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        return currentNode.getKind() == NodeKind.ELEMENT && ((ElementNode)currentNode).getAttributeCount() > 0;
    }

    @Override
    public boolean hasNamespaces() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        return currentNode.getKind() == NodeKind.ELEMENT && ((ElementNode)currentNode).getNamespaceCount() > 0;
    }

    @Override
    public SirixDeweyID getLeftSiblingDeweyID() {
        this.assertNotClosed();
        if (this.resourceSession.getResourceConfig().areDeweyIDsStored) {
            StructNode node = this.getStructuralNode();
            long nodeKey = node.getNodeKey();
            SirixDeweyID deweyID = null;
            if (node.hasLeftSibling()) {
                this.moveTo(node.getLeftSiblingKey());
                deweyID = this.getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return null;
    }

    @Override
    public SirixDeweyID getRightSiblingDeweyID() {
        if (this.resourceSession.getResourceConfig().areDeweyIDsStored) {
            StructNode node = this.getStructuralNode();
            long nodeKey = node.getNodeKey();
            SirixDeweyID deweyID = null;
            if (node.hasRightSibling()) {
                this.moveTo(node.getRightSiblingKey());
                deweyID = this.getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return null;
    }

    @Override
    public SirixDeweyID getParentDeweyID() {
        if (this.resourceSession.getResourceConfig().areDeweyIDsStored) {
            ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
            long nodeKey = currentNode.getNodeKey();
            SirixDeweyID deweyID = null;
            if (currentNode.hasParent()) {
                this.moveTo(currentNode.getParentKey());
                deweyID = this.getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return null;
    }

    @Override
    public SirixDeweyID getFirstChildDeweyID() {
        if (this.resourceSession.getResourceConfig().areDeweyIDsStored) {
            StructNode node = this.getStructuralNode();
            long nodeKey = node.getNodeKey();
            SirixDeweyID deweyID = null;
            if (node.hasFirstChild()) {
                this.moveTo(node.getFirstChildKey());
                deweyID = this.getDeweyID();
            }
            this.moveTo(nodeKey);
            return deweyID;
        }
        return null;
    }

    @Override
    public String getValue() {
        String returnVal;
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)((Object)currentNode);
            returnVal = new String(valueNode.getRawValue(), Constants.DEFAULT_ENCODING);
        } else {
            returnVal = currentNode.getKind() == NodeKind.NAMESPACE ? this.pageReadOnlyTrx.getName(((NamespaceNode)currentNode).getURIKey(), NodeKind.NAMESPACE) : "";
        }
        return returnVal;
    }

    @Override
    public int getNameCount(String name, @NonNull NodeKind kind) {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof NameNode) {
            return this.pageReadOnlyTrx.getNameCount(NamePageHash.generateHashForString(name), kind);
        }
        return 0;
    }

    @Override
    public boolean isValueNode() {
        this.assertNotClosed();
        return this.getCurrentNode() instanceof ValueNode;
    }

    @Override
    public byte[] getRawValue() {
        this.assertNotClosed();
        ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
        if (currentNode instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)((Object)currentNode);
            return valueNode.getRawValue();
        }
        return null;
    }

    @Override
    public XmlResourceSession getResourceSession() {
        this.assertNotClosed();
        return (XmlResourceSession)((Object)this.resourceSession);
    }
}

