/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.page.RevisionRootPageReader;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.ResourceSession;
import io.sirix.cache.BufferManager;
import io.sirix.cache.Cache;
import io.sirix.cache.IndexLogKey;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexType;
import io.sirix.io.BytesUtils;
import io.sirix.io.Reader;
import io.sirix.node.DeletedNode;
import io.sirix.node.NodeKind;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.page.CASPage;
import io.sirix.page.DeweyIDPage;
import io.sirix.page.IndirectPage;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.NamePage;
import io.sirix.page.OverflowPage;
import io.sirix.page.PageReference;
import io.sirix.page.PathPage;
import io.sirix.page.PathSummaryPage;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.KeyValuePage;
import io.sirix.page.interfaces.Page;
import io.sirix.page.interfaces.PageFragmentKey;
import io.sirix.settings.Fixed;
import io.sirix.settings.VersioningType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodePageReadOnlyTrx
implements PageReadOnlyTrx {
    private final Reader pageReader;
    private final UberPage uberPage;
    final InternalResourceSession<?, ?> resourceSession;
    private final int revisionNumber;
    private volatile boolean isClosed;
    private final ResourceConfiguration resourceConfig;
    private final BufferManager resourceBufferManager;
    private final TransactionIntentLog trxIntentLog;
    private final long trxId;
    private final RevisionRootPage rootPage;
    private final NamePage namePage;
    private RecordPage mostRecentlyReadRecordPage;
    private RecordPage secondMostRecentlyReadRecordPage;
    private RecordPage pathSummaryRecordPage;
    private final Bytes<ByteBuffer> byteBufferForRecords = Bytes.elasticByteBuffer((int)40);

    public NodePageReadOnlyTrx(long trxId, InternalResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceSession, UberPage uberPage, @NonNegative int revision, Reader reader, BufferManager resourceBufferManager, @NonNull RevisionRootPageReader revisionRootPageReader, @Nullable TransactionIntentLog trxIntentLog) {
        Preconditions.checkArgument((trxId > 0L ? 1 : 0) != 0, (Object)"Transaction-ID must be >= 0.");
        this.trxId = trxId;
        this.resourceBufferManager = resourceBufferManager;
        this.isClosed = false;
        this.resourceSession = Objects.requireNonNull(resourceSession);
        this.resourceConfig = resourceSession.getResourceConfig();
        this.pageReader = Objects.requireNonNull(reader);
        this.uberPage = Objects.requireNonNull(uberPage);
        this.trxIntentLog = trxIntentLog;
        this.revisionNumber = revision;
        this.rootPage = revisionRootPageReader.loadRevisionRootPage(this, revision);
        this.namePage = revisionRootPageReader.getNamePage(this, this.rootPage);
    }

    private Page loadPage(PageReference reference) {
        Page page = reference.getPage();
        if (page != null) {
            return page;
        }
        if (this.trxIntentLog != null && reference.getLogKey() != -15 && (page = this.getFromTrxIntentLog(reference)) != null) {
            return page;
        }
        if (this.trxIntentLog == null) {
            assert (reference.getLogKey() == -15);
            page = this.resourceBufferManager.getPageCache().get(reference);
            if (page != null) {
                reference.setPage(page);
                return page;
            }
        }
        if (reference.getKey() != -15L || reference.getLogKey() != -15) {
            page = this.pageReader.read(reference, this);
        }
        if (page != null) {
            reference.setPage(page);
            this.putIntoPageCacheIfItIsNotAWriteTrx(reference, page);
        }
        return page;
    }

    private void putIntoPageCacheIfItIsNotAWriteTrx(PageReference reference, Page page) {
        assert (reference.getLogKey() == -15);
        if (this.trxIntentLog == null && !(page instanceof UberPage)) {
            this.resourceBufferManager.getPageCache().put(reference, page);
        }
    }

    @Override
    public boolean hasTrxIntentLog() {
        return this.trxIntentLog != null;
    }

    private @Nullable Page getFromTrxIntentLog(PageReference reference) {
        PageContainer cont = this.trxIntentLog.get(reference);
        return cont == null ? null : cont.getComplete();
    }

    @Override
    public long getTrxId() {
        this.assertNotClosed();
        return this.trxId;
    }

    @Override
    public ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> getResourceSession() {
        this.assertNotClosed();
        return this.resourceSession;
    }

    void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Transaction is already closed.");
        }
    }

    @Override
    public <V extends DataRecord> V getRecord(long recordKey, @NonNull IndexType indexType, @NonNegative int index) {
        Objects.requireNonNull(indexType);
        this.assertNotClosed();
        if (recordKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        long recordPageKey = this.pageKey(recordKey, indexType);
        IndexLogKey indexLogKey = new IndexLogKey(indexType, recordPageKey, index, this.revisionNumber);
        switch (indexType) {
            case DOCUMENT: 
            case CHANGED_NODES: 
            case RECORD_TO_REVISIONS: 
            case PATH_SUMMARY: 
            case PATH: 
            case CAS: 
            case NAME: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Page page = this.getRecordPage(indexLogKey);
        if (page == null) {
            return null;
        }
        DataRecord dataRecord = this.getValue((KeyValueLeafPage)page, recordKey);
        return (V)this.checkItemIfDeleted(dataRecord);
    }

    @Override
    public DataRecord getValue(KeyValueLeafPage page, long nodeKey) {
        int offset = PageReadOnlyTrx.recordPageOffset(nodeKey);
        DataRecord record = page.getRecord(offset);
        if (record == null) {
            byte[] data = page.getSlot(offset);
            if (data != null) {
                record = this.getDataRecord(nodeKey, offset, data, page);
            }
            if (record != null) {
                return record;
            }
            try {
                PageReference reference = page.getPageReference(nodeKey);
                if (reference == null || reference.getKey() == -15L) {
                    return null;
                }
                data = ((OverflowPage)this.pageReader.read(reference, this)).getData();
            }
            catch (SirixIOException e) {
                return null;
            }
            record = this.getDataRecord(nodeKey, offset, data, page);
        }
        return record;
    }

    private DataRecord getDataRecord(long key, int offset, byte[] data, KeyValueLeafPage page) {
        this.byteBufferForRecords.clear();
        BytesUtils.doWrite(this.byteBufferForRecords, data);
        DataRecord record = this.resourceConfig.recordPersister.deserialize((BytesIn<?>)this.byteBufferForRecords, key, page.getDeweyId(offset), this);
        this.byteBufferForRecords.clear();
        page.setRecord(record);
        return record;
    }

    <V extends DataRecord> V checkItemIfDeleted(@Nullable V toCheck) {
        if (toCheck instanceof DeletedNode) {
            return null;
        }
        return toCheck;
    }

    @Override
    public String getName(int nameKey, @NonNull NodeKind nodeKind) {
        this.assertNotClosed();
        return this.namePage.getName(nameKey, nodeKind, this);
    }

    @Override
    public byte[] getRawName(int nameKey, @NonNull NodeKind nodeKind) {
        this.assertNotClosed();
        return this.namePage.getRawName(nameKey, nodeKind, this);
    }

    @Override
    public RevisionRootPage loadRevRoot(@NonNegative int revisionKey) {
        assert (revisionKey <= this.resourceSession.getMostRecentRevisionNumber());
        if (this.trxIntentLog == null) {
            Cache<Integer, RevisionRootPage> cache = this.resourceBufferManager.getRevisionRootPageCache();
            RevisionRootPage revisionRootPage = cache.get(revisionKey);
            if (revisionRootPage == null) {
                revisionRootPage = this.pageReader.readRevisionRootPage(revisionKey, this);
                cache.put(revisionKey, revisionRootPage);
            }
            return revisionRootPage;
        }
        if (revisionKey == 0 && this.uberPage.getRevisionRootReference() != null) {
            PageReference revisionRootPageReference = this.uberPage.getRevisionRootReference();
            PageContainer pageContainer = this.trxIntentLog.get(revisionRootPageReference);
            return (RevisionRootPage)pageContainer.getModified();
        }
        return this.pageReader.readRevisionRootPage(revisionKey, this);
    }

    @Override
    public NamePage getNamePage(@NonNull RevisionRootPage revisionRoot) {
        this.assertNotClosed();
        return (NamePage)this.getPage(revisionRoot.getNamePageReference());
    }

    @Override
    public PathSummaryPage getPathSummaryPage(@NonNull RevisionRootPage revisionRoot) {
        this.assertNotClosed();
        return (PathSummaryPage)this.getPage(revisionRoot.getPathSummaryPageReference());
    }

    @Override
    public PathPage getPathPage(@NonNull RevisionRootPage revisionRoot) {
        this.assertNotClosed();
        return (PathPage)this.getPage(revisionRoot.getPathPageReference());
    }

    @Override
    public CASPage getCASPage(@NonNull RevisionRootPage revisionRoot) {
        this.assertNotClosed();
        return (CASPage)this.getPage(revisionRoot.getCASPageReference());
    }

    @Override
    public DeweyIDPage getDeweyIDPage(@NonNull RevisionRootPage revisionRoot) {
        this.assertNotClosed();
        return (DeweyIDPage)this.getPage(revisionRoot.getDeweyIdPageReference());
    }

    @Override
    public BufferManager getBufferManager() {
        return this.resourceBufferManager;
    }

    private Page getPage(PageReference reference) {
        Page page = this.loadPage(reference);
        reference.setPage(page);
        return page;
    }

    @Override
    public UberPage getUberPage() {
        this.assertNotClosed();
        return this.uberPage;
    }

    @Override
    public Page getRecordPage(@NonNull IndexLogKey indexLogKey) {
        this.assertNotClosed();
        Preconditions.checkArgument((indexLogKey.getRecordPageKey() >= 0L ? 1 : 0) != 0, (Object)"recordPageKey must not be negative!");
        if (indexLogKey.getIndexType() == IndexType.PATH_SUMMARY && this.isMostRecentlyReadPathSummaryPage(indexLogKey)) {
            return this.pathSummaryRecordPage.page();
        }
        if (this.isMostRecentlyReadPage(indexLogKey)) {
            return this.mostRecentlyReadRecordPage.page();
        }
        if (this.isSecondMostRecentlyReadPage(indexLogKey)) {
            return this.secondMostRecentlyReadRecordPage.page();
        }
        PageReference pageReferenceToRecordPage = this.getLeafPageReference(indexLogKey.getRecordPageKey(), indexLogKey.getIndexNumber(), Objects.requireNonNull(indexLogKey.getIndexType()));
        if (pageReferenceToRecordPage == null) {
            return null;
        }
        Page page = this.getInMemoryPageInstance(indexLogKey, pageReferenceToRecordPage);
        if (page != null) {
            return page;
        }
        Page recordPageFromBuffer = this.getFromBufferManager(indexLogKey, pageReferenceToRecordPage);
        if (recordPageFromBuffer != null) {
            return recordPageFromBuffer;
        }
        if (pageReferenceToRecordPage.getKey() == -15L) {
            return null;
        }
        return this.loadDataPageFromDurableStorageAndCombinePageFragments(indexLogKey, pageReferenceToRecordPage);
    }

    private boolean isMostRecentlyReadPathSummaryPage(IndexLogKey indexLogKey) {
        return this.pathSummaryRecordPage != null && this.pathSummaryRecordPage.recordPageKey == indexLogKey.getRecordPageKey() && this.pathSummaryRecordPage.index == indexLogKey.getIndexNumber() && this.pathSummaryRecordPage.revision == indexLogKey.getRevisionNumber();
    }

    private boolean isMostRecentlyReadPage(IndexLogKey indexLogKey) {
        return this.mostRecentlyReadRecordPage != null && this.mostRecentlyReadRecordPage.recordPageKey == indexLogKey.getRecordPageKey() && this.mostRecentlyReadRecordPage.index == indexLogKey.getIndexNumber() && this.mostRecentlyReadRecordPage.indexType == indexLogKey.getIndexType() && this.mostRecentlyReadRecordPage.revision == indexLogKey.getRevisionNumber();
    }

    private boolean isSecondMostRecentlyReadPage(IndexLogKey indexLogKey) {
        return this.secondMostRecentlyReadRecordPage != null && this.secondMostRecentlyReadRecordPage.recordPageKey == indexLogKey.getRecordPageKey() && this.secondMostRecentlyReadRecordPage.index == indexLogKey.getIndexNumber() && this.secondMostRecentlyReadRecordPage.indexType == indexLogKey.getIndexType() && this.secondMostRecentlyReadRecordPage.revision == indexLogKey.getRevisionNumber();
    }

    private @Nullable Page getFromBufferManager(@NonNull IndexLogKey indexLogKey, PageReference pageReferenceToRecordPage) {
        Page recordPageFromBuffer = this.resourceBufferManager.getRecordPageCache().get(pageReferenceToRecordPage);
        if (recordPageFromBuffer != null) {
            this.setMostRecentlyReadRecordPage(indexLogKey, recordPageFromBuffer);
            pageReferenceToRecordPage.setPage(recordPageFromBuffer);
            return recordPageFromBuffer;
        }
        return null;
    }

    private void setMostRecentlyReadRecordPage(@NonNull IndexLogKey indexLogKey, Page recordPageFromBuffer) {
        if (indexLogKey.getIndexType() == IndexType.PATH_SUMMARY) {
            this.pathSummaryRecordPage = new RecordPage(indexLogKey.getIndexNumber(), indexLogKey.getIndexType(), indexLogKey.getRecordPageKey(), indexLogKey.getRevisionNumber(), recordPageFromBuffer);
        } else {
            this.secondMostRecentlyReadRecordPage = this.mostRecentlyReadRecordPage;
            this.mostRecentlyReadRecordPage = new RecordPage(indexLogKey.getIndexNumber(), indexLogKey.getIndexType(), indexLogKey.getRecordPageKey(), indexLogKey.getRevisionNumber(), recordPageFromBuffer);
        }
    }

    private @Nullable Page loadDataPageFromDurableStorageAndCombinePageFragments(@NonNull IndexLogKey indexLogKey, PageReference pageReferenceToRecordPage) {
        List<KeyValuePage<DataRecord>> pages = this.getPageFragments(pageReferenceToRecordPage);
        if (pages.isEmpty()) {
            return null;
        }
        int maxRevisionsToRestore = this.resourceConfig.maxNumberOfRevisionsToRestore;
        VersioningType versioningApproach = this.resourceConfig.versioningType;
        KeyValuePage<DataRecord> completePage = versioningApproach.combineRecordPages(pages, maxRevisionsToRestore, this);
        if (this.trxIntentLog == null) {
            this.resourceBufferManager.getRecordPageCache().put(pageReferenceToRecordPage, (KeyValueLeafPage)completePage);
        }
        pageReferenceToRecordPage.setPage(completePage);
        this.setMostRecentlyReadRecordPage(indexLogKey, completePage);
        return completePage;
    }

    private @Nullable Page getInMemoryPageInstance(@NonNull IndexLogKey indexLogKey, @NonNull PageReference pageReferenceToRecordPage) {
        Page page = pageReferenceToRecordPage.getPage();
        if (page != null) {
            this.setMostRecentlyReadRecordPage(indexLogKey, page);
            return page;
        }
        return null;
    }

    PageReference getLeafPageReference(@NonNegative long recordPageKey, int indexNumber, IndexType indexType) {
        PageReference pageReferenceToSubtree = this.getPageReference(this.rootPage, indexType, indexNumber);
        return this.getReferenceToLeafOfSubtree(pageReferenceToSubtree, recordPageKey, indexNumber, indexType, this.rootPage);
    }

    PageReference getLeafPageReference(PageReference pageReferenceToSubtree, @NonNegative long recordPageKey, int indexNumber, IndexType indexType, RevisionRootPage revisionRootPage) {
        return this.getReferenceToLeafOfSubtree(pageReferenceToSubtree, recordPageKey, indexNumber, indexType, revisionRootPage);
    }

    List<KeyValuePage<DataRecord>> getPageFragments(PageReference pageReference) {
        KeyValuePage page;
        assert (pageReference != null);
        ResourceConfiguration config = this.resourceSession.getResourceConfig();
        int revsToRestore = config.maxNumberOfRevisionsToRestore;
        int[] revisionsToRead = config.versioningType.getRevisionRoots(this.rootPage.getRevision(), revsToRestore);
        ArrayList<KeyValuePage<DataRecord>> pages = new ArrayList<KeyValuePage<DataRecord>>(revisionsToRead.length);
        List<PageFragmentKey> pageFragments = pageReference.getPageFragments();
        PageReference pageReferenceWithKey = new PageReference().setKey(pageReference.getKey());
        if (this.trxIntentLog == null) {
            page = (KeyValuePage)this.resourceBufferManager.getPageCache().get(pageReferenceWithKey);
            if (page == null) {
                page = (KeyValuePage)this.pageReader.read(pageReferenceWithKey, this);
                assert (pageReferenceWithKey.getLogKey() == -15);
                this.resourceBufferManager.getPageCache().put(pageReferenceWithKey, page);
            }
        } else {
            page = (KeyValuePage)this.pageReader.read(pageReferenceWithKey, this);
        }
        pages.add(page);
        if (pageFragments.isEmpty() || page.size() == 1024) {
            return pages;
        }
        ArrayList<PageFragmentKey> pageFragmentKeys = new ArrayList<PageFragmentKey>(pageFragments.size() + 1);
        pageFragmentKeys.addAll(pageFragments);
        pages.addAll(this.getPreviousPageFragments(pageFragmentKeys));
        return pages;
    }

    private List<KeyValuePage<DataRecord>> getPreviousPageFragments(List<PageFragmentKey> pageFragments) {
        List<CompletableFuture<KeyValuePage<DataRecord>>> pages = pageFragments.stream().map(this::readPage).collect(Collectors.toList());
        return NodePageReadOnlyTrx.sequence(pages).join().stream().sorted(Comparator.comparing(KeyValuePage::getRevision).reversed()).collect(Collectors.toList());
    }

    private CompletableFuture<KeyValuePage<DataRecord>> readPage(PageFragmentKey pageFragmentKey) {
        Page pageFromBufferManager;
        PageReference pageReference = new PageReference().setKey(pageFragmentKey.key());
        if (this.trxIntentLog == null && (pageFromBufferManager = this.resourceBufferManager.getPageCache().get(pageReference)) != null) {
            assert (pageFragmentKey.revision() == ((KeyValuePage)pageFromBufferManager).getRevision());
            return CompletableFuture.completedFuture((KeyValuePage)pageFromBufferManager);
        }
        PageReadOnlyTrx pageReadOnlyTrx = this.resourceSession.beginPageReadOnlyTrx(pageFragmentKey.revision());
        return pageReadOnlyTrx.getReader().readAsync(pageReference, pageReadOnlyTrx).whenComplete((page, exception) -> {
            pageReadOnlyTrx.close();
            if (this.trxIntentLog == null) {
                assert (pageFragmentKey.revision() == ((KeyValuePage)page).getRevision());
                this.resourceBufferManager.getPageCache().put(pageReference, (Page)page);
            }
        });
    }

    static CompletableFuture<List<KeyValuePage<DataRecord>>> sequence(List<CompletableFuture<KeyValuePage<DataRecord>>> listOfCompletableFutures) {
        return CompletableFuture.allOf(listOfCompletableFutures.toArray(new CompletableFuture[0])).thenApply(v -> listOfCompletableFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    PageReference getPageReference(RevisionRootPage revisionRoot, IndexType indexType, int index) {
        assert (revisionRoot != null);
        return switch (indexType) {
            case IndexType.DOCUMENT -> revisionRoot.getIndirectDocumentIndexPageReference();
            case IndexType.CHANGED_NODES -> revisionRoot.getIndirectChangedNodesIndexPageReference();
            case IndexType.RECORD_TO_REVISIONS -> revisionRoot.getIndirectRecordToRevisionsIndexPageReference();
            case IndexType.DEWEYID_TO_RECORDID -> this.getDeweyIDPage(revisionRoot).getIndirectPageReference();
            case IndexType.CAS -> this.getCASPage(revisionRoot).getIndirectPageReference(index);
            case IndexType.PATH -> this.getPathPage(revisionRoot).getIndirectPageReference(index);
            case IndexType.NAME -> this.getNamePage(revisionRoot).getIndirectPageReference(index);
            case IndexType.PATH_SUMMARY -> this.getPathSummaryPage(revisionRoot).getIndirectPageReference(index);
            default -> throw new IllegalStateException("Only defined for node, path summary, text value and attribute value pages!");
        };
    }

    @Override
    public IndirectPage dereferenceIndirectPageReference(PageReference reference) {
        return (IndirectPage)this.loadPage(reference);
    }

    @Override
    public @Nullable PageReference getReferenceToLeafOfSubtree(PageReference startReference, @NonNegative long pageKey, int indexNumber, @NonNull IndexType indexType, RevisionRootPage revisionRootPage) {
        this.assertNotClosed();
        PageReference reference = Objects.requireNonNull(startReference);
        long levelKey = pageKey;
        int[] inpLevelPageCountExp = this.uberPage.getPageCountExp(indexType);
        int maxHeight = this.getCurrentMaxIndirectPageTreeLevel(indexType, indexNumber, revisionRootPage);
        int height = inpLevelPageCountExp.length;
        for (int level = inpLevelPageCountExp.length - maxHeight; level < height; ++level) {
            IndirectPage derefPage = this.dereferenceIndirectPageReference(reference);
            if (derefPage == null) {
                reference = null;
                break;
            }
            int offset = (int)(levelKey >> inpLevelPageCountExp[level]);
            levelKey -= (long)offset << inpLevelPageCountExp[level];
            try {
                reference = derefPage.getOrCreateReference(offset);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new SirixIOException("Node key isn't supported, it's too big!");
            }
        }
        return reference;
    }

    @Override
    public long pageKey(@NonNegative long recordKey, @NonNull IndexType indexType) {
        this.assertNotClosed();
        return switch (indexType) {
            case IndexType.PATH_SUMMARY -> recordKey >> 10;
            case IndexType.REVISIONS -> recordKey >> 10;
            case IndexType.DOCUMENT, IndexType.PATH, IndexType.CAS, IndexType.NAME -> recordKey >> 10;
            default -> recordKey >> 10;
        };
    }

    @Override
    public int getCurrentMaxIndirectPageTreeLevel(IndexType indexType, int index, RevisionRootPage revisionRootPage) {
        RevisionRootPage currentRevisionRootPage = revisionRootPage == null ? this.rootPage : revisionRootPage;
        int maxLevel = switch (indexType) {
            default -> throw new MatchException(null, null);
            case IndexType.REVISIONS -> throw new IllegalStateException();
            case IndexType.DOCUMENT -> currentRevisionRootPage.getCurrentMaxLevelOfDocumentIndexIndirectPages();
            case IndexType.CHANGED_NODES -> currentRevisionRootPage.getCurrentMaxLevelOfChangedNodesIndexIndirectPages();
            case IndexType.RECORD_TO_REVISIONS -> currentRevisionRootPage.getCurrentMaxLevelOfRecordToRevisionsIndexIndirectPages();
            case IndexType.CAS -> this.getCASPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
            case IndexType.PATH -> this.getPathPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
            case IndexType.NAME -> this.getNamePage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
            case IndexType.PATH_SUMMARY -> this.getPathSummaryPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages(index);
            case IndexType.DEWEYID_TO_RECORDID -> this.getDeweyIDPage(currentRevisionRootPage).getCurrentMaxLevelOfIndirectPages();
        };
        return maxLevel;
    }

    @Override
    public RevisionRootPage getActualRevisionRootPage() {
        this.assertNotClosed();
        return this.rootPage;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Session", this.resourceSession).add("PageReader", (Object)this.pageReader).add("UberPage", (Object)this.uberPage).add("RevRootPage", (Object)this.rootPage).toString();
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            if (this.trxIntentLog == null) {
                this.pageReader.close();
            }
            if (this.resourceSession.getNodeReadTrxByTrxId(this.trxId).isEmpty()) {
                this.resourceSession.closePageReadTransaction(this.trxId);
            }
            this.isClosed = true;
        }
    }

    @Override
    public int getNameCount(int key, @NonNull NodeKind kind) {
        this.assertNotClosed();
        return this.namePage.getCount(key, kind, this);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getRevisionNumber() {
        this.assertNotClosed();
        return this.rootPage.getRevision();
    }

    @Override
    public Reader getReader() {
        this.assertNotClosed();
        return this.pageReader;
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.assertNotClosed();
        return this.rootPage.getCommitCredentials();
    }

    private record RecordPage(int index, IndexType indexType, long recordPageKey, int revision, Page page) {
    }
}

